/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

public final class HsqlStringBuffer {
    private static final int BEGINNING_OFFSET = 1;
    private static final int END_OFFSET = 1;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final float DEFAULT_RESIZE_FACTOR = 2.0f;
    private char[] data;
    private int charCount;
    private int hash;

    public HsqlStringBuffer() {
        this(16);
    }

    public HsqlStringBuffer(int n) {
        if (n < 0) {
            throw new NegativeArraySizeException("Invalid length passed");
        }
        if (n == 0) {
            n = 1;
        }
        this.data = new char[1 + n + 1];
        this.charCount = 0;
    }

    public HsqlStringBuffer(String string) {
        this.data = new char[1 + string.length() + 16 + 1];
        this.charCount = 0;
        this.append(string);
    }

    public HsqlStringBuffer append(char c) {
        this.makeRoom(this.charCount, 1);
        this.data[1 + this.charCount] = c;
        ++this.charCount;
        return this;
    }

    public HsqlStringBuffer append(String string) {
        int n = string.length();
        this.makeRoom(this.charCount, n);
        string.getChars(0, n, this.data, this.charCount + 1);
        this.charCount += n;
        return this;
    }

    public HsqlStringBuffer append(HsqlStringBuffer hsqlStringBuffer) {
        this.makeRoom(this.charCount, hsqlStringBuffer.charCount);
        System.arraycopy(hsqlStringBuffer.data, 1, this.data, 1 + this.charCount, hsqlStringBuffer.charCount);
        this.charCount += hsqlStringBuffer.charCount;
        return this;
    }

    public HsqlStringBuffer insert(int n, char c) {
        this.checkInsertPosition(n);
        this.makeRoom(n, 1);
        this.data[n + 1] = c;
        ++this.charCount;
        return this;
    }

    public HsqlStringBuffer insert(int n, String string) {
        this.checkInsertPosition(n);
        int n2 = string.length();
        this.makeRoom(n, n2);
        string.getChars(0, n2, this.data, 1 + n);
        this.charCount += n2;
        return this;
    }

    public String toString() {
        return new String(this.data, 1, this.charCount);
    }

    public String toQuotedString() {
        this.data[this.charCount + 1] = 39;
        this.data[0] = 39;
        String string = new String(this.data, 0, this.charCount + 1 + 1);
        this.data[this.charCount + 1] = '\u0000';
        this.data[0] = '\u0000';
        return string;
    }

    public boolean equals(String string) {
        if (string.length() != this.charCount) {
            return false;
        }
        int n = 0;
        while (n < this.charCount) {
            if (string.charAt(n) != this.data[1 + n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HsqlStringBuffer)) {
            return false;
        }
        HsqlStringBuffer hsqlStringBuffer = (HsqlStringBuffer)object;
        if (hsqlStringBuffer.charCount != this.charCount) {
            return false;
        }
        int n = 0;
        while (n < this.charCount) {
            if (hsqlStringBuffer.data[n] != this.data[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        int n = this.hash;
        if (n == 0) {
            int n2 = 0;
            while (n2 < this.charCount) {
                n = 31 * n + this.data[1 + n2];
                ++n2;
            }
            this.hash = n;
        }
        return n;
    }

    public int compareTo(HsqlStringBuffer hsqlStringBuffer) {
        if (this == hsqlStringBuffer) {
            return 0;
        }
        int n = Math.min(this.charCount, hsqlStringBuffer.charCount) + 1;
        int n2 = 1;
        while (n2 < n) {
            if (this.data[n2] != hsqlStringBuffer.data[n2]) {
                return this.data[n2] - hsqlStringBuffer.data[n2];
            }
            ++n2;
        }
        return this.charCount - hsqlStringBuffer.charCount;
    }

    public int compareTo(String string) {
        char[] cArray = string.toCharArray();
        int n = Math.min(this.charCount, cArray.length) + 1;
        int n2 = 1;
        while (n2 < n) {
            if (this.data[n2] != cArray[n2 - 1]) {
                return this.data[n2] - cArray[n2 - 1];
            }
            ++n2;
        }
        return this.charCount - cArray.length;
    }

    public int compareTo(Object object) {
        if (object instanceof HsqlStringBuffer) {
            return this.compareTo((HsqlStringBuffer)object);
        }
        if (object instanceof String) {
            return this.compareTo((String)object);
        }
        throw new ClassCastException("Unsupported comparison attempted");
    }

    public final int length() {
        return this.charCount;
    }

    public void setLength(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException("Length given is less than zero: " + n);
        }
        if (n > this.charCount) {
            this.makeRoom(this.charCount, n - this.charCount);
            while (this.charCount < n) {
                this.data[this.charCount + 1] = '\u0000';
                ++this.charCount;
            }
        } else {
            this.charCount = n;
        }
    }

    private void checkInsertPosition(int n) {
        if (n > this.charCount) {
            throw new IndexOutOfBoundsException("Invalid position passed: " + n + ">" + this.charCount);
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Invalid position passed: " + n + "<0");
        }
    }

    private void makeRoom(int n, int n2) {
        boolean bl = false;
        if (n != this.charCount) {
            bl = true;
        }
        if (1 + n2 + this.charCount + 1 >= this.data.length) {
            int n3 = (int)((float)this.data.length * 2.0f);
            char[] cArray = n3 <= 1 + this.charCount + n2 + 1 ? new char[n3 + n2] : new char[n3];
            int n4 = this.charCount + 1;
            if (bl) {
                System.arraycopy(this.data, n, cArray, n + n2 - 1 + 1, n4 -= n);
                if (n != 0) {
                    System.arraycopy(this.data, 1, cArray, 1, n - 1 + 1);
                }
            } else {
                System.arraycopy(this.data, 0, cArray, 0, n4);
            }
            this.data = cArray;
            cArray = null;
        } else if (bl) {
            int n5 = 1 + n + n2;
            int n6 = this.charCount - 1 + n2 + 1;
            while (n6 >= n5) {
                this.data[n6] = this.data[n6 - n2];
                --n6;
            }
        }
    }

    public HsqlStringBuffer append(int n) {
        return this.append(Integer.toString(n));
    }

    public HsqlStringBuffer append(long l) {
        return this.append(Long.toString(l));
    }

    public char charAt(int n) {
        return this.data[n + 1];
    }

    public void setCharAt(int n, char c) {
        this.data[n + 1] = c;
    }

    public HsqlStringBuffer reverse() {
        int n = 0;
        while (n < this.charCount / 2) {
            char c = this.data[1 + n];
            this.data[1 + n] = this.data[1 + this.charCount - n - 1];
            this.data[1 + this.charCount - n - 1] = c;
            ++n;
        }
        return this;
    }

    public HsqlStringBuffer append(char[] cArray, int n, int n2) {
        this.makeRoom(this.charCount, n2);
        System.arraycopy(cArray, n, this.data, 1 + this.charCount, n2);
        this.charCount += n2;
        return this;
    }
}

