/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.HsqlDeque;

public class HsqlTaskQueue {
    protected Thread taskRunnerThread;
    protected static Runnable SHUTDOWNTASK = new Runnable(){

        public void run() {
        }
    };
    protected volatile boolean isShutdown;
    protected final HsqlDeque queue = new HsqlDeque();
    protected final TaskRunner taskRunner = new TaskRunner();

    public synchronized Thread getTaskRunnerThread() {
        return this.taskRunnerThread;
    }

    protected synchronized void clearThread() {
        this.taskRunnerThread = null;
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    public synchronized void restart() {
        if (this.taskRunnerThread == null && !this.isShutdown) {
            this.taskRunnerThread = new Thread(this.taskRunner);
            this.taskRunnerThread.start();
        }
    }

    public void execute(Runnable runnable) throws RuntimeException {
        if (!this.isShutdown) {
            this.restart();
            HsqlDeque hsqlDeque = this.queue;
            synchronized (hsqlDeque) {
                this.queue.addLast(runnable);
            }
        }
    }

    public synchronized void shutdownAfterQueued() {
        if (this.taskRunnerThread != null && !this.isShutdown) {
            HsqlDeque hsqlDeque = this.queue;
            synchronized (hsqlDeque) {
                this.queue.addLast(SHUTDOWNTASK);
            }
        }
    }

    public synchronized void shutdownAfterCurrent() {
        this.isShutdown = true;
        if (this.taskRunnerThread != null) {
            HsqlDeque hsqlDeque = this.queue;
            synchronized (hsqlDeque) {
                this.queue.clear();
                this.queue.addLast(SHUTDOWNTASK);
            }
        }
    }

    public synchronized void shutdownImmediately() {
        this.isShutdown = true;
        if (this.taskRunnerThread != null) {
            this.taskRunnerThread.interrupt();
            this.shutdownAfterCurrent();
        }
    }

    protected class TaskRunner
    implements Runnable {
        protected TaskRunner() {
        }

        public void run() {
            try {
                while (!HsqlTaskQueue.this.isShutdown) {
                    Runnable runnable;
                    HsqlDeque hsqlDeque = HsqlTaskQueue.this.queue;
                    synchronized (hsqlDeque) {
                        runnable = (Runnable)HsqlTaskQueue.this.queue.getFirst();
                    }
                    if (runnable == SHUTDOWNTASK) {
                        HsqlTaskQueue.this.isShutdown = true;
                        break;
                    }
                    if (runnable == null) break;
                    runnable.run();
                    runnable = null;
                }
                Object var5_4 = null;
                HsqlTaskQueue.this.clearThread();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                HsqlTaskQueue.this.clearThread();
                throw throwable;
            }
        }
    }
}

