/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UTFDataFormatException;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.HsqlStringBuffer;

public class StringConverter {
    private static final char[] HEXCHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String HEXINDEX = "0123456789abcdef0123456789ABCDEF";

    public static byte[] hexToByte(String string) throws IOException {
        int n = string.length() / 2;
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c;
            int n4;
            if ((n4 = HEXINDEX.indexOf(c = string.charAt(n2++))) == -1) {
                throw new IOException("hexadecimal string contains non hex character");
            }
            int n5 = (n4 & 0xF) << 4;
            c = string.charAt(n2++);
            n4 = HEXINDEX.indexOf(c);
            byArray[n3] = (byte)(n5 += n4 & 0xF);
            ++n3;
        }
        return byArray;
    }

    public static String byteToHex(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n * 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4 = byArray[n2] & 0xFF;
            cArray[n3++] = HEXCHAR[n4 >> 4 & 0xF];
            cArray[n3++] = HEXCHAR[n4 & 0xF];
            ++n2;
        }
        return new String(cArray);
    }

    public static String byteToString(byte[] byArray, String string) {
        try {
            return string == null ? new String(byArray) : new String(byArray, string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String unicodeToHexString(String string) {
        HsqlByteArrayOutputStream hsqlByteArrayOutputStream = new HsqlByteArrayOutputStream();
        try {
            StringConverter.writeUTF(string, hsqlByteArrayOutputStream);
        }
        catch (IOException iOException) {
            return null;
        }
        return StringConverter.byteToHex(hsqlByteArrayOutputStream.toByteArray());
    }

    public static String hexStringToUnicode(String string) throws IOException {
        byte[] byArray = StringConverter.hexToByte(string);
        return StringConverter.readUTF(byArray, 0, byArray.length);
    }

    public static int unicodeToAscii(OutputStream outputStream, String string, boolean bl) throws IOException {
        int n = 0;
        if (string == null || string.length() == 0) {
            return 0;
        }
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            char c = string.charAt(n3);
            if (c == '\\') {
                if (n3 < n2 - 1 && string.charAt(n3 + 1) == 'u') {
                    outputStream.write(c);
                    outputStream.write(117);
                    outputStream.write(48);
                    outputStream.write(48);
                    outputStream.write(53);
                    outputStream.write(99);
                    n += 6;
                } else {
                    outputStream.write(c);
                    ++n;
                }
            } else if (c >= ' ' && c <= '\u007f') {
                outputStream.write(c);
                ++n;
                if (c == '\'' && bl) {
                    outputStream.write(c);
                    ++n;
                }
            } else {
                outputStream.write(92);
                outputStream.write(117);
                outputStream.write(HEXCHAR[c >> 12 & 0xF]);
                outputStream.write(HEXCHAR[c >> 8 & 0xF]);
                outputStream.write(HEXCHAR[c >> 4 & 0xF]);
                outputStream.write(HEXCHAR[c & 0xF]);
                n += 6;
            }
            ++n3;
        }
        return n;
    }

    public static String asciiToUnicode(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return "";
        }
        char[] cArray = new char[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            byte by = byArray[n + n4];
            if (by == 92 && n4 < n2 - 5) {
                byte by2 = byArray[n + n4 + 1];
                if (by2 == 117) {
                    ++n4;
                    int n5 = HEXINDEX.indexOf(byArray[n + ++n4]) << 12;
                    n5 += HEXINDEX.indexOf(byArray[n + ++n4]) << 8;
                    n5 += HEXINDEX.indexOf(byArray[n + ++n4]) << 4;
                    cArray[n3++] = (char)(n5 += HEXINDEX.indexOf(byArray[n + ++n4]));
                } else {
                    cArray[n3++] = (char)by;
                }
            } else {
                cArray[n3++] = (char)by;
            }
            ++n4;
        }
        return new String(cArray, 0, n3);
    }

    public static String asciiToUnicode(String string) {
        if (string == null || string.indexOf("\\u") == -1) {
            return string;
        }
        int n = string.length();
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            if (c == '\\' && n3 < n - 5) {
                char c2 = string.charAt(n3 + 1);
                if (c2 == 'u') {
                    ++n3;
                    int n4 = HEXINDEX.indexOf(string.charAt(++n3)) << 12;
                    n4 += HEXINDEX.indexOf(string.charAt(++n3)) << 8;
                    n4 += HEXINDEX.indexOf(string.charAt(++n3)) << 4;
                    cArray[n2++] = (char)(n4 += HEXINDEX.indexOf(string.charAt(++n3)));
                } else {
                    cArray[n2++] = c;
                }
            } else {
                cArray[n2++] = c;
            }
            ++n3;
        }
        return new String(cArray, 0, n2);
    }

    public static String readUTF(byte[] byArray, int n, int n2) throws IOException {
        HsqlStringBuffer hsqlStringBuffer = new HsqlStringBuffer(n2);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = byArray[n + n3];
            if (n4 > 0) {
                ++n3;
                hsqlStringBuffer.append((char)n4);
                continue;
            }
            switch ((n4 &= 0xFF) >> 4) {
                case 12: 
                case 13: {
                    if ((n3 += 2) > n2) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n + n3 - 1];
                    if ((by & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    hsqlStringBuffer.append((char)((n4 & 0x1F) << 6 | by & 0x3F));
                    break;
                }
                case 14: {
                    if ((n3 += 3) > n2) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n + n3 - 2];
                    byte by2 = byArray[n + n3 - 1];
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    hsqlStringBuffer.append((char)((n4 & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0));
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        return hsqlStringBuffer.toString();
    }

    public static int writeUTF(String string, OutputStream outputStream) throws IOException {
        int n = string.length();
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            if (c >= '\u0001' && c <= '\u007f') {
                outputStream.write(c);
                ++n2;
            } else if (c > '\u07ff') {
                outputStream.write(0xE0 | c >> 12 & 0xF);
                outputStream.write(0x80 | c >> 6 & 0x3F);
                outputStream.write(0x80 | c >> 0 & 0x3F);
                n2 += 3;
            } else {
                outputStream.write(0xC0 | c >> 6 & 0x1F);
                outputStream.write(0x80 | c >> 0 & 0x3F);
                n2 += 2;
            }
            ++n3;
        }
        return n2;
    }

    public static String inputStreamToString(InputStream inputStream) throws IOException {
        int n;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        StringWriter stringWriter = new StringWriter();
        int n2 = 8192;
        char[] cArray = new char[n2];
        while ((n = inputStreamReader.read(cArray, 0, n2)) != -1) {
            stringWriter.write(cArray, 0, n);
        }
        stringWriter.close();
        inputStream.close();
        return stringWriter.toString();
    }

    public static String toQuotedString(String string, char c, boolean bl) {
        if (string == null) {
            return null;
        }
        int n = bl ? StringConverter.count(string, c) : 0;
        int n2 = string.length();
        char[] cArray = new char[2 + n + n2];
        int n3 = 0;
        int n4 = 0;
        cArray[n4++] = c;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            cArray[n4++] = c2;
            if (bl && c2 == c) {
                cArray[n4++] = c2;
            }
            ++n3;
        }
        cArray[n4] = c;
        return new String(cArray);
    }

    static int count(String string, char c) {
        int n = 0;
        if (string != null) {
            int n2 = string.length();
            while (--n2 >= 0) {
                char c2 = string.charAt(n2);
                if (c2 != c) continue;
                ++n;
            }
        }
        return n;
    }
}

