/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.store;

import java.math.BigDecimal;
import java.sql.Date;
import org.hsqldb.store.ValuePoolHashMap;

public class ValuePool {
    static ValuePoolHashMap intPool;
    static ValuePoolHashMap longPool;
    static ValuePoolHashMap doublePool;
    static ValuePoolHashMap bigdecimalPool;
    static ValuePoolHashMap stringPool;
    static ValuePoolHashMap datePool;
    static final int[] defaultPoolLookupSize;
    static final int defaultSizeFactor = 2;
    static final int defaultMaxStringLength = 16;
    static ValuePoolHashMap[] poolList;
    static int maxStringLength;
    static /* synthetic */ Class class$org$hsqldb$store$ValuePool;

    private static void initPool() {
        int[] nArray = defaultPoolLookupSize;
        int n = 2;
        Class clazz = class$org$hsqldb$store$ValuePool == null ? (class$org$hsqldb$store$ValuePool = ValuePool.class$("org.hsqldb.store.ValuePool")) : class$org$hsqldb$store$ValuePool;
        synchronized (clazz) {
            maxStringLength = 16;
            poolList = new ValuePoolHashMap[6];
            int n2 = 0;
            while (n2 < poolList.length) {
                int n3 = nArray[n2];
                ValuePool.poolList[n2] = new ValuePoolHashMap(n3, n3 * n, 2);
                ++n2;
            }
            intPool = poolList[0];
            longPool = poolList[1];
            doublePool = poolList[2];
            bigdecimalPool = poolList[3];
            stringPool = poolList[4];
            datePool = poolList[5];
        }
    }

    public static void resetPool(int[] nArray, int n) {
        int n2 = 0;
        while (n2 < poolList.length) {
            poolList[n2].resetCapacity(nArray[n2] * n, 2);
            ++n2;
        }
    }

    public static void resetPool() {
        ValuePool.resetPool(defaultPoolLookupSize, 2);
    }

    public static void clearPool() {
        int n = 0;
        while (n < poolList.length) {
            poolList[n].clear();
            ++n;
        }
    }

    public static synchronized Integer getInt(int n) {
        return intPool.getOrAddInteger(n);
    }

    public static synchronized Long getLong(long l) {
        return longPool.getOrAddLong(l);
    }

    public static synchronized Double getDouble(long l) {
        return doublePool.getOrAddDouble(l);
    }

    public static synchronized String getString(String string) {
        if (string == null || string.length() > maxStringLength) {
            return string;
        }
        return stringPool.getOrAddString(string);
    }

    public static synchronized Date getDate(long l) {
        return datePool.getOrAddDate(l);
    }

    public static synchronized BigDecimal getBigDecimal(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return bigDecimal;
        }
        return (BigDecimal)bigdecimalPool.getOrAddObject(bigDecimal);
    }

    public static Boolean getBoolean(boolean bl) {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Object getObject(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? Boolean.TRUE : Boolean.FALSE;
        }
        if (object instanceof BigDecimal) {
            return ValuePool.getBigDecimal((BigDecimal)object);
        }
        if (object instanceof Date) {
            return ValuePool.getDate(((Date)object).getTime());
        }
        if (object instanceof Double) {
            return ValuePool.getDouble(Double.doubleToLongBits((Double)object));
        }
        if (object instanceof Integer) {
            return ValuePool.getInt((Integer)object);
        }
        if (object instanceof Long) {
            return ValuePool.getLong((Long)object);
        }
        if (object instanceof String) {
            return ValuePool.getString((String)object);
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        defaultPoolLookupSize = new int[]{10000, 10000, 10000, 10000, 10000, 10000};
        ValuePool.initPool();
    }

    public static class poolSettings {
        String[] propertyStrings = new String[]{"runtime.pool.int_size", "runtime.pool.long_size", "runtime.pool.double_size", "runtime.pool.decimal_size", "runtime.pool.string_size", "runtime.pool.date_size", "runtime.pool.factor", "runtime.pool.string_length"};
        static final int[] defaultPoolLookupSize = new int[]{1000, 1000, 1000, 1000, 1000, 1000};
    }
}

