/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import org.hsqldb.lib.java.javaSystem;
import org.hsqldb.util.Grid;

public class QueryTool
extends Applet
implements WindowListener,
ActionListener {
    static Properties pProperties = new Properties();
    boolean bApplication;
    static Frame fMain;
    Connection cConn;
    Statement sStatement;
    String[] sRecent;
    static int iMaxRecent;
    int iRecent;
    TextArea txtCommand;
    Button butExecute;
    Button butScript;
    Button butImport;
    Choice choRecent;
    Grid gResult;
    static String[] sTestData;

    public static void main(String[] stringArray) {
        Object object;
        fMain = new Frame("Query Tool");
        QueryTool queryTool = new QueryTool();
        queryTool.bApplication = true;
        int n = 0;
        while (n < stringArray.length) {
            object = stringArray[n];
            if (((String)object).equals("-?")) {
                QueryTool.printHelp();
            }
            if (((String)object).charAt(0) == '-') {
                ((Hashtable)pProperties).put(((String)object).substring(1), stringArray[n + 1]);
                ++n;
            }
            ++n;
        }
        queryTool.init();
        queryTool.start();
        fMain.add("Center", queryTool);
        object = new MenuBar();
        Menu menu = new Menu("File");
        menu.add("Exit");
        menu.addActionListener(queryTool);
        ((MenuBar)object).add(menu);
        fMain.setMenuBar((MenuBar)object);
        ((Component)fMain).setSize(500, 400);
        fMain.show();
        fMain.addWindowListener(queryTool);
    }

    public void init() {
        this.initGUI();
        Properties properties = pProperties;
        if (!this.bApplication) {
            ((Hashtable)properties).put("database", ".");
            try {
                ((Hashtable)pProperties).put("database", this.getParameter("database"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String string = properties.getProperty("driver", "org.hsqldb.jdbcDriver");
        String string2 = properties.getProperty("url", "jdbc:hsqldb:");
        String string3 = properties.getProperty("database", ".");
        String string4 = properties.getProperty("user", "sa");
        String string5 = properties.getProperty("password", "");
        boolean bl = properties.getProperty("test", "true").equalsIgnoreCase("true");
        boolean bl2 = properties.getProperty("log", "true").equalsIgnoreCase("true");
        try {
            if (bl2) {
                this.trace("driver  =" + string);
                this.trace("url     =" + string2);
                this.trace("database=" + string3);
                this.trace("user    =" + string4);
                this.trace("password=" + string5);
                this.trace("test    =" + bl);
                this.trace("log     =" + bl2);
                javaSystem.setLogToSystem(true);
            }
            Class.forName(string).newInstance();
            this.cConn = DriverManager.getConnection(string2 + string3, string4, string5);
        }
        catch (Exception exception) {
            System.out.println("QueryTool.init: " + exception.getMessage());
            exception.printStackTrace();
        }
        this.sRecent = new String[iMaxRecent];
        this.iRecent = 0;
        try {
            this.sStatement = this.cConn.createStatement();
        }
        catch (SQLException sQLException) {
            System.out.println("Exception: " + sQLException);
        }
        if (bl) {
            this.insertTestData();
        }
        this.txtCommand.requestFocus();
    }

    void trace(String string) {
        System.out.println(string);
    }

    public boolean action(Event event, Object object) {
        String string = object.toString();
        if (string.equals("Execute")) {
            String string2 = this.txtCommand.getText();
            String[] stringArray = new String[1];
            try {
                this.sStatement.execute(string2);
                int n = this.sStatement.getUpdateCount();
                if (n == -1) {
                    this.formatResultSet(this.sStatement.getResultSet());
                } else {
                    stringArray[0] = "update count";
                    this.gResult.setHead(stringArray);
                    stringArray[0] = String.valueOf(n);
                    this.gResult.addRow(stringArray);
                }
                this.setRecent(this.txtCommand.getText());
            }
            catch (SQLException sQLException) {
                stringArray[0] = "SQL Error";
                this.gResult.setHead(stringArray);
                stringArray[0] = sQLException.getMessage();
                this.gResult.addRow(stringArray);
            }
            this.gResult.repaint();
            this.txtCommand.selectAll();
            this.txtCommand.requestFocus();
        } else if (string.equals("Script")) {
            String string3 = this.getScript();
            this.txtCommand.setText(string3);
            this.txtCommand.selectAll();
            this.txtCommand.requestFocus();
        } else if (string.equals("Import")) {
            String string4 = this.getImport();
            this.txtCommand.setText(string4);
            this.txtCommand.selectAll();
            this.txtCommand.requestFocus();
        } else if (string.equals("Exit")) {
            System.exit(0);
        } else {
            this.txtCommand.setText(string);
        }
        return true;
    }

    void formatResultSet(ResultSet resultSet) {
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            String[] stringArray = new String[n];
            int n2 = 1;
            while (n2 <= n) {
                stringArray[n2 - 1] = resultSetMetaData.getColumnLabel(n2);
                ++n2;
            }
            this.gResult.setHead(stringArray);
            while (resultSet.next()) {
                int n3 = 1;
                while (n3 <= n) {
                    stringArray[n3 - 1] = resultSet.getString(n3);
                    if (resultSet.wasNull()) {
                        stringArray[n3 - 1] = "(null)";
                    }
                    ++n3;
                }
                this.gResult.addRow(stringArray);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    String getScript() {
        try {
            ResultSet resultSet = this.sStatement.executeQuery("SCRIPT");
            StringBuffer stringBuffer = new StringBuffer();
            while (resultSet.next()) {
                stringBuffer.append(resultSet.getString(1));
                stringBuffer.append('\n');
            }
            stringBuffer.append('\n');
            return stringBuffer.toString();
        }
        catch (SQLException sQLException) {
            return "";
        }
    }

    String getImport() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "import.sql";
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append('\n');
            }
            stringBuffer.append('\n');
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    private void setRecent(String string) {
        int n = 0;
        while (n < iMaxRecent) {
            if (string.equals(this.sRecent[n])) {
                return;
            }
            ++n;
        }
        if (this.sRecent[this.iRecent] != null) {
            this.choRecent.remove(this.sRecent[this.iRecent]);
        }
        this.sRecent[this.iRecent] = string;
        this.iRecent = (this.iRecent + 1) % iMaxRecent;
        this.choRecent.addItem(string);
    }

    private void initGUI() {
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        Panel panel3 = new Panel();
        Panel panel4 = new Panel();
        Panel panel5 = new Panel();
        Panel panel6 = new Panel();
        Panel panel7 = new Panel();
        Panel panel8 = new Panel();
        panel.setLayout(new BorderLayout());
        panel2.setLayout(new BorderLayout());
        panel3.setLayout(new BorderLayout());
        panel4.setLayout(new BorderLayout());
        panel5.setLayout(new BorderLayout());
        panel6.setBackground(SystemColor.control);
        panel8.setBackground(SystemColor.control);
        panel7.setBackground(SystemColor.control);
        Label label = new Label(" Command", 0);
        Label label2 = new Label(" Recent", 0);
        Label label3 = new Label(" Result", 0);
        label.setBackground(SystemColor.control);
        label2.setBackground(SystemColor.control);
        label3.setBackground(SystemColor.control);
        this.butExecute = new Button("Execute");
        this.butScript = new Button("Script");
        this.butImport = new Button("Import");
        panel3.add("South", this.butScript);
        panel3.add("Center", this.butExecute);
        panel3.add("North", this.butImport);
        Font font = new Font("Dialog", 0, 12);
        this.txtCommand = new TextArea(5, 40);
        this.txtCommand.setFont(font);
        this.choRecent = new Choice();
        this.gResult = new Grid();
        this.setLayout(new BorderLayout());
        panel4.add("Center", this.choRecent);
        panel4.add("North", label2);
        panel2.add("North", label);
        panel2.add("East", panel3);
        panel2.add("Center", this.txtCommand);
        panel2.add("South", panel4);
        panel5.add("North", label3);
        panel5.add("Center", this.gResult);
        panel.add("North", panel2);
        panel.add("Center", panel5);
        this.add("Center", panel);
        this.add("West", panel6);
        this.add("East", panel7);
        this.add("South", panel8);
        this.doLayout();
    }

    void insertTestData() {
        int n = 0;
        while (n < sTestData.length) {
            try {
                this.sStatement.executeQuery(sTestData[n]);
            }
            catch (SQLException sQLException) {
                System.out.println("Exception: " + sQLException);
            }
            ++n;
        }
        this.setRecent("select * from place");
        this.setRecent("select * from Customer");
        this.setRecent("select * from Customer where place<>3000");
        this.setRecent("select * from place where code>3000 or code=1200");
        this.setRecent("select * from Customer where nr<=8\nand name<>'Mueller'");
        this.setRecent("update Customer set name='Russi'\nwhere name='Rossi'");
        this.setRecent("delete from Customer where place=8000");
        this.setRecent("insert into place values(3600,'Thun')");
        this.setRecent("drop index Customer.iNr");
        this.setRecent("select * from Customer where name like '%e%'");
        this.setRecent("select count(*),min(code),max(code),sum(code) from place");
        String string = "select * from Customer,place\nwhere Customer.place=place.code\nand place.name='Berne'";
        this.setRecent(string);
        this.txtCommand.setText(string);
        this.txtCommand.selectAll();
    }

    static void printHelp() {
        System.out.println("Usage: java QueryTool [-options]\nwhere options include:\n    -driver <classname>  name of the driver class\n    -url <name>          first part of the jdbc url\n    -database <name>     second part of the jdbc url\n    -user <name>         username used for connection\n    -password <name>     password for this user\n    -test <true/false>   insert test data\n    -log <true/false>    write log to system out");
        System.exit(0);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        try {
            this.cConn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fMain != null) {
            fMain.dispose();
        }
        System.exit(0);
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string != null && string.equals("Exit")) {
            this.windowClosing(null);
        }
    }

    static {
        iMaxRecent = 24;
        sTestData = new String[]{"drop table Place if exists", "create table Place (Code integer,Name varchar(255))", "create index iCode on Place (Code)", "delete from place", "insert into Place values (4900,'Langenthal')", "insert into Place values (8000,'Zurich')", "insert into Place values (3000,'Berne')", "insert into Place values (1200,'Geneva')", "insert into Place values (6900,'Lugano')", "drop table Customer if exists", "create table Customer (Nr integer,Name varchar(255),Place integer)", "create index iNr on Customer (Nr)", "delete from Customer", "insert into Customer values (1,'Meier',3000)", "insert into Customer values (2,'Mueller',8000)", "insert into Customer values (3,'Devaux',1200)", "insert into Customer values (4,'Rossi',6900)", "insert into Customer values (5,'Rickli',3000)", "insert into Customer values (6,'Graf',3000)", "insert into Customer values (7,'Mueller',4900)", "insert into Customer values (8,'May',1200)", "insert into Customer values (9,'Berger',8000)", "insert into Customer values (10,'D''Ascoli',6900)", "insert into Customer values (11,'Padruz',1200)", "insert into Customer values (12,'Hug',4900)"};
    }
}

