/*
 * Decompiled with CFR 0.152.
 */
package jtools;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class Process {
    protected String[] cmd = null;
    protected ByteArrayOutputStream buff_out = null;
    protected ByteArrayOutputStream buff_err = null;

    public Process(String[] command) {
        this.cmd = command;
    }

    public ByteArrayOutputStream getProcessOutputStream() {
        return this.buff_out;
    }

    public ByteArrayOutputStream getProcessErrorStream() {
        return this.buff_err;
    }

    public int exec() throws IOException {
        java.lang.Process proc = Runtime.getRuntime().exec(this.cmd);
        InputStream proc_out = proc.getInputStream();
        InputStream proc_err = proc.getErrorStream();
        this.buff_out = new ByteArrayOutputStream();
        this.buff_err = new ByteArrayOutputStream();
        new ProcessStreamReader(this.buff_out, proc_out);
        new ProcessStreamReader(this.buff_err, proc_err);
        try {
            proc.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        proc_out.close();
        proc_err.close();
        return proc.exitValue();
    }

    public void close() {
        try {
            if (this.buff_out != null) {
                this.buff_out.close();
                this.buff_out = null;
            }
            if (this.buff_err != null) {
                this.buff_err.close();
                this.buff_err = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.cmd = null;
    }

    class ProcessStreamReader
    extends Thread {
        ByteArrayOutputStream buff_out = null;
        InputStream proc_in = null;

        protected ProcessStreamReader(ByteArrayOutputStream buff_o, InputStream proc_i) {
            this.buff_out = buff_o;
            this.proc_in = proc_i;
            this.setDaemon(true);
            this.start();
        }

        public void run() {
            try {
                byte[] buff = new byte[1000];
                int res = this.proc_in.read(buff);
                while (res != -1) {
                    this.buff_out.write(buff, 0, res);
                    res = this.proc_in.read(buff);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

