/*
 * Decompiled with CFR 0.152.
 */
package remotecons;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import remotecons.SocketListener;
import remotecons.ifc.CommandHandlerIfc;
import remotecons.wttools.ConnectionHandlerImpl;
import remotecons.wttools.ConnectionServer;

public class RemoteServer {
    protected int server_port = 1612;
    protected boolean as_daemon = true;
    protected SocketListener s_listener = null;

    public void initialize(List command_handlers) throws IOException {
        this.initialize(this.server_port, command_handlers);
    }

    public void initialize(int port_no, List command_handlers) throws IOException {
        this.s_listener = new SocketListener();
        this.s_listener.setConn_handler(new ConnectionHandlerImpl());
        this.s_listener.setCommand_handlers(command_handlers);
        this.s_listener.startListening(port_no, this.as_daemon);
    }

    public void disable() {
        this.s_listener.close();
    }

    public static void main(String[] args) {
        RemoteServer rs = new RemoteServer();
        rs.setServer_port(2702);
        rs.setAs_daemon(false);
        LinkedList<SampleCommandHandler> l = new LinkedList<SampleCommandHandler>();
        l.add(rs.new SampleCommandHandler());
        try {
            rs.initialize(l);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Remote server started in test mode.");
        System.out.println("Waiting for incoming connections on port " + rs.server_port + "...");
    }

    public int getServer_port() {
        return this.server_port;
    }

    public void setServer_port(int argServer_port) {
        this.server_port = argServer_port;
    }

    public boolean isAs_daemon() {
        return this.as_daemon;
    }

    public void setAs_daemon(boolean argAs_daemon) {
        this.as_daemon = argAs_daemon;
    }

    public class SampleCommandHandler
    implements CommandHandlerIfc {
        public void register(ConnectionServer server) {
        }

        public String handleCommand(String comm) {
            if (comm.trim().equals("hello")) {
                return "Hello world!\r\n";
            }
            if (comm.trim().equals("isdaemon")) {
                return "" + RemoteServer.this.as_daemon + "\r\n";
            }
            return null;
        }

        public String help() {
            return "\r\n  hello    - Returns 'Hello world!' string as a result.\r\n  isdaemon - returns info if console started as daemon.\r\n";
        }

        public String help(String comm) {
            return "";
        }

        public CommandHandlerIfc getInstance() {
            return new SampleCommandHandler();
        }
    }
}

