/*
 * Decompiled with CFR 0.152.
 */
package remotecons;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import remotecons.ifc.ConnectionHandlerIfc;
import remotecons.ifc.LogIfc;

public class SocketListener
extends Thread {
    protected int port_no = 1612;
    protected ConnectionHandlerIfc conn_handler = null;
    protected List command_handlers = null;
    protected ServerSocket server_socket = null;
    protected LogIfc log_impl = null;
    protected boolean may_run = true;

    public void startListening() throws IOException {
        this.startListening(1612, true);
    }

    public void startListening(int port_no, boolean daemon) throws IOException {
        this.may_run = true;
        this.port_no = port_no;
        this.server_socket = new ServerSocket(port_no);
        this.setDaemon(daemon);
        this.start();
    }

    public void close() {
        this.may_run = false;
        try {
            Socket socket = new Socket(this.server_socket.getInetAddress(), this.port_no);
            socket.close();
        }
        catch (IOException e) {
            System.err.println("shutdown problem: " + e.toString());
        }
        try {
            this.server_socket.close();
        }
        catch (IOException e) {
            System.err.println("shutdown problem: " + e.toString());
        }
    }

    public void run() {
        while (this.may_run) {
            try {
                Socket socket = this.server_socket.accept();
                this.log("Connection request received.");
                this.log("Remote host is: " + socket.getInetAddress().getHostAddress());
                if (this.conn_handler != null) {
                    this.conn_handler.handleNewConnection(socket, this.command_handlers);
                    continue;
                }
                this.log("Cant handle received connection request!");
                this.log("No connection handler defined.");
            }
            catch (IOException e) {
                if (this.conn_handler != null) {
                    this.conn_handler.handleException(e);
                    break;
                }
                e.printStackTrace();
                break;
            }
        }
    }

    protected void log(String msg) {
        if (this.log_impl != null) {
            this.log_impl.log(msg);
        }
    }

    public int getPort_no() {
        return this.port_no;
    }

    public void setPort_no(int argPort_no) {
        this.port_no = argPort_no;
    }

    public ConnectionHandlerIfc getConn_handler() {
        return this.conn_handler;
    }

    public void setConn_handler(ConnectionHandlerIfc argConn_handler) {
        this.conn_handler = argConn_handler;
    }

    public List getCommand_handlers() {
        return this.command_handlers;
    }

    public void setCommand_handlers(List argCommand_handlers) {
        this.command_handlers = argCommand_handlers;
    }
}

