/*
 * Decompiled with CFR 0.152.
 */
package remotecons.wttools;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Date;
import java.util.StringTokenizer;
import jtools.Process;
import remotecons.ifc.CommandHandlerIfc;
import remotecons.wttools.ConnectionServer;

public class CommandHandlerImpl
implements CommandHandlerIfc {
    protected String last_command = null;

    public void register(ConnectionServer server) {
    }

    public String handleCommand(String command) {
        String res = null;
        if (command.trim().equals("time")) {
            res = "" + new Date() + "\r\n";
        }
        if (command.trim().equals("gc")) {
            System.gc();
            res = "OK\r\n";
        }
        if (command.trim().startsWith("mem")) {
            Runtime rt = Runtime.getRuntime();
            res = "" + rt.totalMemory() + "/" + rt.freeMemory() + "\r\n";
        }
        if (command.trim().startsWith("exit")) {
            res = "\r\nYou are going to shutdown remote JVM!\r\nAre you sure to do this and lost all data? (yes/no): ";
        }
        if (command.trim().equals("yes") && this.last_command.trim().startsWith("exit")) {
            System.exit(10);
        }
        if (command.trim().equals("no") && this.last_command.trim().startsWith("exit")) {
            res = "\r\n";
        }
        this.last_command = command;
        return res;
    }

    public String help() {
        String help_text = "\r\n  time - display current time on server\r\n  gc   - run System.gc() command on remote system\r\n  mem [total|free] - display amount of total/free memory on remote system\r\n  exit [n] - call System.exit(n) on remote system\r\n";
        return help_text;
    }

    public String help(String command) {
        return "";
    }

    protected String externalCommand(String comm) {
        String res = "";
        StringTokenizer stt = new StringTokenizer(comm);
        String[] cmd = new String[stt.countTokens()];
        int i = 0;
        while (stt.hasMoreTokens()) {
            cmd[i++] = stt.nextToken();
        }
        try {
            Process proc = new Process(cmd);
            proc.exec();
            ByteArrayOutputStream buff_out = proc.getProcessOutputStream();
            ByteArrayOutputStream buff_err = proc.getProcessErrorStream();
            BufferedReader brout = new BufferedReader(new StringReader(buff_out.toString()));
            String line = brout.readLine();
            while (line != null) {
                res = res + line + "\r\n";
                line = brout.readLine();
            }
            brout.close();
            buff_out.close();
            BufferedReader brerr = new BufferedReader(new StringReader(buff_err.toString()));
            line = brerr.readLine();
            while (line != null) {
                res = res + line + "\r\n";
                line = brerr.readLine();
            }
            brerr.close();
            buff_err.close();
        }
        catch (Exception e) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(baos, false);
            e.printStackTrace(pw);
            pw.flush();
            res = baos.toString();
            pw.close();
        }
        return "\r\n" + res;
    }

    public CommandHandlerIfc getInstance() {
        return new CommandHandlerImpl();
    }
}

