/*
 * Decompiled with CFR 0.152.
 */
package remotecons.wttools;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import remotecons.ifc.CommandHandlerIfc;
import remotecons.ifc.LogIfc;

public class ConnectionServer
extends Thread {
    protected static List active_connections = Collections.synchronizedList(new ArrayList());
    protected Socket my_socket = null;
    protected BufferedReader inst = null;
    protected PrintWriter out = null;
    protected List comm_handl = null;
    protected LogIfc log_impl = null;
    protected boolean prompt = true;
    protected boolean echo = true;

    public ConnectionServer(Socket socket, List command_handlers) throws IOException {
        this.comm_handl = command_handlers;
        if (this.comm_handl == null) {
            this.comm_handl = new ArrayList();
        }
        this.comm_handl.add(0, new InternalCommands());
        int i = 0;
        while (i < this.comm_handl.size()) {
            ((CommandHandlerIfc)this.comm_handl.get(i)).register(this);
            ++i;
        }
        this.my_socket = socket;
        this.inst = new BufferedReader(new InputStreamReader(this.my_socket.getInputStream()));
        this.out = new PrintWriter(this.my_socket.getOutputStream(), true);
        this.setDaemon(true);
        this.start();
        active_connections.add(this);
    }

    public void shutdown() {
        try {
            if (this.out != null) {
                this.out.print("\r\n" + this.my_socket.getLocalAddress().getHostAddress() + " << Outologout, bye.\r\n");
                this.out.flush();
                this.out.close();
            }
            if (this.inst != null) {
                this.inst.close();
                this.inst = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void run() {
        this.log("Connection server started for client: " + this.my_socket.getInetAddress().getHostAddress());
        while (this.inst != null) {
            try {
                if (this.prompt) {
                    this.out.print(this.my_socket.getLocalAddress().getHostAddress() + " << ");
                    this.out.flush();
                }
                String line = "";
                if (this.echo) {
                    char chr = (char)this.inst.read();
                    while (chr != '\n') {
                        if (chr != '\r') {
                            line = line + chr;
                        }
                        this.out.print(chr);
                        this.out.flush();
                        chr = (char)this.inst.read();
                    }
                    this.out.print(chr);
                    this.out.flush();
                } else {
                    line = this.inst.readLine();
                }
                this.log("Received command: " + line);
                if (this.processCommand(line) || this.out == null || line.equals("")) continue;
                this.out.println(this.getClass().getName() + " >> Command '" + line + "' not understood.");
            }
            catch (SocketException e) {
                this.out = null;
                this.inst = null;
                this.my_socket = null;
            }
            catch (IOException e) {
                e.printStackTrace();
                this.out = null;
                this.inst = null;
                this.my_socket = null;
            }
            catch (NullPointerException e) {
                this.out = null;
                this.inst = null;
                this.my_socket = null;
            }
        }
        active_connections.remove(this);
    }

    protected boolean processCommand(String line) {
        boolean comm_found = false;
        int i = 0;
        while (i < this.comm_handl.size()) {
            String res = ((CommandHandlerIfc)this.comm_handl.get(i)).handleCommand(line);
            if (res != null && !res.equals("")) {
                if (this.out != null) {
                    this.out.print(res);
                    this.out.flush();
                }
                this.prompt = res.endsWith("\r\n");
                comm_found = true;
            }
            ++i;
        }
        return comm_found;
    }

    protected void log(String msg) {
        if (this.log_impl != null) {
            this.log_impl.log(msg);
        }
    }

    class InternalCommands
    implements CommandHandlerIfc {
        protected String last_command = null;

        InternalCommands() {
        }

        public void register(ConnectionServer server) {
        }

        public String handleCommand(String comm) {
            ConnectionServer cs;
            String ret_res = null;
            if (comm.trim().startsWith("echo")) {
                ConnectionServer.this.echo = !ConnectionServer.this.echo;
                ret_res = "Echo your command is now in '" + ConnectionServer.this.echo + "' mode\r\n";
            }
            if (comm.equals("quit")) {
                ret_res = "OK";
                ConnectionServer.this.log("'quit' received, closing connection...");
                ConnectionServer.this.out.println("Bye");
                ConnectionServer.this.out.close();
                ConnectionServer.this.out = null;
                try {
                    ConnectionServer.this.inst.close();
                    ConnectionServer.this.inst = null;
                    ConnectionServer.this.my_socket.close();
                    ConnectionServer.this.my_socket = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ConnectionServer.this.out = null;
                    ConnectionServer.this.inst = null;
                    ConnectionServer.this.my_socket = null;
                }
            }
            if (comm.startsWith("help")) {
                String res;
                ret_res = "";
                if (comm.trim().equals("help")) {
                    int i = 0;
                    while (i < ConnectionServer.this.comm_handl.size()) {
                        res = ((CommandHandlerIfc)ConnectionServer.this.comm_handl.get(i)).help();
                        ret_res = ret_res + ConnectionServer.this.comm_handl.get(i).getClass().getName() + " >> " + res;
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < ConnectionServer.this.comm_handl.size()) {
                        res = ((CommandHandlerIfc)ConnectionServer.this.comm_handl.get(i)).help(comm.substring(5));
                        ret_res = ret_res + ConnectionServer.this.comm_handl.get(i).getClass().getName() + " >> " + res;
                        ++i;
                    }
                }
            }
            if (comm.trim().equals("who")) {
                ret_res = "\r\n";
                int i = 0;
                while (i < active_connections.size()) {
                    cs = (ConnectionServer)active_connections.get(i);
                    ret_res = cs.my_socket == ConnectionServer.this.my_socket ? ret_res + "this:  " : ret_res + "other: ";
                    ret_res = ret_res + "" + i + ". " + cs.my_socket + "\r\n";
                    ++i;
                }
            }
            if (comm.trim().startsWith("close")) {
                int no = -1;
                try {
                    no = Integer.parseInt(comm.substring(6).trim());
                    if (no >= 0 && no < active_connections.size()) {
                        cs = (ConnectionServer)active_connections.get(no);
                        ConnectionServer.this.out.print("closing " + cs.my_socket + " ... ");
                        ConnectionServer.this.out.flush();
                        cs.processCommand("quit");
                        active_connections.remove(cs);
                        ret_res = "OK\r\n";
                    } else {
                        ret_res = "Argument out of range. Check valid ranges with 'who' command.";
                    }
                }
                catch (StringIndexOutOfBoundsException e) {
                    ret_res = "Wrong number of arguments. I need integer number here.";
                }
                catch (NumberFormatException e) {
                    ret_res = "Bad argument to 'close' command. I need integer number here.";
                }
            }
            return ret_res;
        }

        protected String buildFileString(File ff) {
            StringBuffer res = new StringBuffer(80);
            res.append(this.setForTrueOrFalse(ff.isDirectory(), "d", "-"));
            res.append(this.setForTrueOrFalse(ff.canRead(), "r", "-"));
            res.append(this.setForTrueOrFalse(ff.canWrite(), "w", "-"));
            res.append(this.setForTrueOrFalse(ff.isHidden(), "h", "-"));
            res.append("   " + ff.length());
            while (res.length() < 17) {
                res.append(' ');
            }
            DateFormat dt = DateFormat.getDateInstance();
            res.append("   " + dt.format(new Date(ff.lastModified())));
            res.append("   " + ff.getName());
            res.append(this.setForTrueOrFalse(ff.isDirectory(), "/", ""));
            return res.toString();
        }

        protected String setForTrueOrFalse(boolean cond, String for_true, String for_false) {
            if (cond) {
                return for_true;
            }
            return for_false;
        }

        public String help() {
            String help_text = "\r\n  echo           - switch 'echo' mode (for windows telnet is really needed)\r\n  quit           - close connection to server\r\n  who            - list all active connections\r\n  close n        - close active connection number 'n'\r\n  help [command] - display this message info\r\n\r\n";
            return help_text;
        }

        public String help(String command) {
            return "";
        }

        public CommandHandlerIfc getInstance() {
            return new InternalCommands();
        }
    }
}

