/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class LinkedList
extends AbstractSequentialList
implements List,
Cloneable,
Serializable {
    private transient Entry header;
    private transient int size;

    public LinkedList() {
        this.header.next = this.header.previous = (this.header = new Entry(null, null, null));
    }

    public LinkedList(Collection collection) {
        this();
        this.addAll(collection);
    }

    public Object getFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.header.next.element;
    }

    public Object getLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.header.previous.element;
    }

    public Object removeFirst() {
        Object object = this.header.next.element;
        this.remove(this.header.next);
        return object;
    }

    public Object removeLast() {
        Object object = this.header.previous.element;
        this.remove(this.header.previous);
        return object;
    }

    public void addFirst(Object object) {
        this.addBefore(object, this.header.next);
    }

    public void addLast(Object object) {
        this.addBefore(object, this.header);
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        ++this.modCount;
        this.header.next = this.header.previous = (this.header = new Entry(null, null, null));
        this.size = 0;
    }

    public ListIterator listIterator(int n) {
        return new ListItr(n);
    }

    private Entry addBefore(Object object, Entry entry) {
        Entry entry2;
        entry2.previous.next = entry2 = new Entry(object, entry, entry.previous);
        entry2.next.previous = entry2;
        ++this.size;
        ++this.modCount;
        return entry2;
    }

    private void remove(Entry entry) {
        if (entry == this.header) {
            throw new NoSuchElementException();
        }
        entry.previous.next = entry.next;
        entry.next.previous = entry.previous;
        --this.size;
        ++this.modCount;
    }

    public Object clone() {
        return new LinkedList(this);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        ListIterator listIterator = this.listIterator();
        while (listIterator.hasNext()) {
            objectOutputStream.writeObject(listIterator.next());
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.header.next = this.header.previous = (this.header = new Entry(null, null, null));
        int n2 = 0;
        while (n2 < n) {
            this.add(objectInputStream.readObject());
            ++n2;
        }
    }

    private class ListItr
    implements ListIterator {
        private Entry lastReturned;
        private Entry next;
        private int nextIndex;
        private boolean forward;
        private int expectedModCount;

        ListItr(int n) {
            LinkedList.this = LinkedList.this;
            this.lastReturned = LinkedList.this.header;
            this.expectedModCount = LinkedList.this.modCount;
            if (n < 0 || n > LinkedList.this.size) {
                throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + LinkedList.this.size);
            }
            if (n < LinkedList.this.size / 2) {
                this.next = ((LinkedList)LinkedList.this).header.next;
                this.nextIndex = 0;
                while (this.nextIndex < n) {
                    this.next = this.next.next;
                    ++this.nextIndex;
                }
                return;
            }
            this.next = LinkedList.this.header;
            this.nextIndex = LinkedList.this.size;
            while (this.nextIndex > n) {
                this.next = this.next.previous;
                --this.nextIndex;
            }
        }

        public boolean hasNext() {
            return this.nextIndex != LinkedList.this.size;
        }

        public Object next() {
            this.checkForComodification();
            if (this.nextIndex == LinkedList.this.size) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            this.next = this.next.next;
            ++this.nextIndex;
            this.forward = true;
            return this.lastReturned.element;
        }

        public boolean hasPrevious() {
            return this.nextIndex != 0;
        }

        public Object previous() {
            if (this.nextIndex == 0) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next = this.next.previous;
            --this.nextIndex;
            this.checkForComodification();
            this.forward = false;
            return this.lastReturned.element;
        }

        public int nextIndex() {
            return this.nextIndex;
        }

        public int previousIndex() {
            return this.nextIndex - 1;
        }

        public void remove() {
            LinkedList.this.remove(this.lastReturned);
            this.lastReturned = LinkedList.this.header;
            if (this.forward) {
                --this.nextIndex;
            }
            ++this.expectedModCount;
        }

        public void set(Object object) {
            if (this.lastReturned == LinkedList.this.header) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            this.lastReturned.element = object;
        }

        public void add(Object object) {
            this.checkForComodification();
            this.lastReturned = LinkedList.this.header;
            this.next = LinkedList.this.addBefore(object, this.next);
            ++this.expectedModCount;
        }

        final void checkForComodification() {
            if (LinkedList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private static class Entry {
        Object element;
        Entry next;
        Entry previous;

        Entry(Object object, Entry entry, Entry entry2) {
            this.element = object;
            this.next = entry;
            this.previous = entry2;
        }
    }
}

