/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class SimpleTimeZone
extends TimeZone {
    private int startMonth;
    private int startDay;
    private int startDayOfWeek;
    private int startTime;
    private int endMonth;
    private int endDay;
    private int endDayOfWeek;
    private int endTime;
    private int startYear;
    private int rawOffset;
    private boolean useDaylight = false;
    private static final int millisPerHour = 3600000;
    private final byte[] monthLength = staticMonthLength;
    private static final byte[] staticMonthLength = new byte[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private int startMode;
    private int endMode;
    private int dstSavings;
    private static final int DOM_MODE = 1;
    private static final int DOW_IN_MONTH_MODE = 2;
    private static final int DOW_GE_DOM_MODE = 3;
    private static final int DOW_LE_DOM_MODE = 4;
    static final long serialVersionUID = -403250971215465050L;
    static final int currentSerialVersion = 1;
    private int serialVersionOnStream = 1;

    public SimpleTimeZone(int n, String string) {
        this.rawOffset = n;
        this.setID(string);
        this.dstSavings = 3600000;
    }

    public SimpleTimeZone(int n, String string, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this(n, string, n2, n3, n4, n5, n6, n7, n8, n9, 3600000);
    }

    public SimpleTimeZone(int n, String string, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        this.setID(string);
        this.rawOffset = n;
        this.startMonth = n2;
        this.startDay = n3;
        this.startDayOfWeek = n4;
        this.startTime = n5;
        this.endMonth = n6;
        this.endDay = n7;
        this.endDayOfWeek = n8;
        this.endTime = n9;
        this.dstSavings = n10;
        this.decodeRules();
    }

    public void setStartYear(int n) {
        this.startYear = n;
    }

    public void setStartRule(int n, int n2, int n3, int n4) {
        this.startMonth = n;
        this.startDay = n2;
        this.startDayOfWeek = n3;
        this.startTime = n4;
        this.decodeStartRule();
    }

    public void setStartRule(int n, int n2, int n3) {
        this.setStartRule(n, n2, 0, n3);
    }

    public void setStartRule(int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            this.setStartRule(n, n2, -n3, n4);
            return;
        }
        this.setStartRule(n, -n2, -n3, n4);
    }

    public void setEndRule(int n, int n2, int n3, int n4) {
        this.endMonth = n;
        this.endDay = n2;
        this.endDayOfWeek = n3;
        this.endTime = n4;
        this.decodeEndRule();
    }

    public void setEndRule(int n, int n2, int n3) {
        this.setEndRule(n, n2, 0, n3);
    }

    public void setEndRule(int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            this.setEndRule(n, n2, -n3, n4);
            return;
        }
        this.setEndRule(n, -n2, -n3, n4);
    }

    public int getOffset(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.rawOffset;
        if (!this.useDaylight || n2 < this.startYear || n != 1) {
            return n7;
        }
        boolean bl = this.startMonth > this.endMonth;
        int n8 = SimpleTimeZone.compareToRule(n3, n4, n5, n6, this.startMode, this.startMonth, this.startDayOfWeek, this.startDay, this.startTime);
        int n9 = SimpleTimeZone.compareToRule(n3, n4, n5, n6 + this.dstSavings, this.endMode, this.endMonth, this.endDayOfWeek, this.endDay, this.endTime);
        if (!bl && n8 >= 0 && n9 < 0 || bl && (n8 >= 0 || n9 < 0)) {
            n7 += this.dstSavings;
        }
        return n7;
    }

    private static int compareToRule(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (n < n6) {
            return -1;
        }
        if (n > n6) {
            return 1;
        }
        int n10 = 0;
        switch (n5) {
            case 1: {
                n10 = n8;
                break;
            }
            case 2: {
                if (n8 > 0) {
                    n10 = 1 + (n8 - 1) * 7 + (7 + n7 - (n3 - n2 + 1)) % 7;
                    break;
                }
                byte by = staticMonthLength[n];
                n10 = by + (n8 + 1) * 7 - (7 + (n3 + by - n2) - n7) % 7;
                break;
            }
            case 3: {
                n10 = n8 + (49 + n7 - n8 - n3 + n2) % 7;
                break;
            }
            case 4: {
                n10 = n8 - (49 - n7 + n8 + n3 - n2) % 7;
                break;
            }
        }
        if (n2 < n10) {
            return -1;
        }
        if (n2 > n10) {
            return 1;
        }
        if (n4 < n9) {
            return -1;
        }
        if (n4 > n9) {
            return 1;
        }
        return 0;
    }

    public int getRawOffset() {
        return this.rawOffset;
    }

    public void setRawOffset(int n) {
        this.rawOffset = n;
    }

    public void setDSTSavings(int n) {
        this.dstSavings = n;
    }

    public int getDSTSavings() {
        return this.dstSavings;
    }

    public boolean useDaylightTime() {
        return this.useDaylight;
    }

    public boolean inDaylightTime(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this);
        gregorianCalendar.setTime(date);
        return gregorianCalendar.inDaylightTime();
    }

    public Object clone() {
        return super.clone();
    }

    public synchronized int hashCode() {
        return this.startMonth ^ this.startDay ^ this.startDayOfWeek ^ this.startTime ^ this.endMonth ^ this.endDay ^ this.endDayOfWeek ^ this.endTime ^ this.rawOffset;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SimpleTimeZone)) {
            return false;
        }
        SimpleTimeZone simpleTimeZone = (SimpleTimeZone)object;
        return this.getID().equals(simpleTimeZone.getID()) && this.hasSameRules(simpleTimeZone);
    }

    public boolean hasSameRules(TimeZone timeZone) {
        if (this == timeZone) {
            return true;
        }
        if (!(timeZone instanceof SimpleTimeZone)) {
            return false;
        }
        SimpleTimeZone simpleTimeZone = (SimpleTimeZone)timeZone;
        return this.rawOffset == simpleTimeZone.rawOffset && this.useDaylight == simpleTimeZone.useDaylight && this.dstSavings == simpleTimeZone.dstSavings && this.startMode == simpleTimeZone.startMode && this.startMonth == simpleTimeZone.startMonth && this.startDay == simpleTimeZone.startDay && this.startDayOfWeek == simpleTimeZone.startDayOfWeek && this.startTime == simpleTimeZone.startTime && this.endMode == simpleTimeZone.endMode && this.endMonth == simpleTimeZone.endMonth && this.endDay == simpleTimeZone.endDay && this.endDayOfWeek == simpleTimeZone.endDayOfWeek && this.endTime == simpleTimeZone.endTime && this.startYear == simpleTimeZone.startYear;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[id=" + this.getID() + ",offset=" + this.rawOffset + ",dstSavings=" + this.dstSavings + ",useDaylight=" + this.useDaylight + ",startYear=" + this.startYear + ",startMode=" + this.startMode + ",startMonth=" + this.startMonth + ",startDay=" + this.startDay + ",startDayOfWeek=" + this.startDayOfWeek + ",startTime=" + this.startTime + ",endMode=" + this.endMode + ",endMonth=" + this.endMonth + ",endDay=" + this.endDay + ",endDayOfWeek=" + this.endDayOfWeek + ",endTime=" + this.endTime + ']';
    }

    private void decodeRules() {
        this.decodeStartRule();
        this.decodeEndRule();
    }

    private void decodeStartRule() {
        boolean bl = this.useDaylight = this.startDay != 0 && this.endDay != 0;
        if (this.startDayOfWeek == 0) {
            this.startMode = 1;
            return;
        }
        if (this.startDayOfWeek > 0) {
            this.startMode = 2;
            return;
        }
        this.startDayOfWeek = -this.startDayOfWeek;
        if (this.startDay > 0) {
            this.startMode = 3;
            return;
        }
        this.startDay = -this.startDay;
        this.startMode = 4;
    }

    private void decodeEndRule() {
        boolean bl = this.useDaylight = this.startDay != 0 && this.endDay != 0;
        if (this.endDayOfWeek == 0) {
            this.endMode = 1;
            return;
        }
        if (this.endDayOfWeek > 0) {
            this.endMode = 2;
            return;
        }
        this.endDayOfWeek = -this.endDayOfWeek;
        if (this.endDay > 0) {
            this.endMode = 3;
            return;
        }
        this.endDay = -this.endDay;
        this.endMode = 4;
    }

    private void makeRulesCompatible() {
        switch (this.startMode) {
            case 1: {
                this.startDay = 1 + this.startDay / 7;
                this.startDayOfWeek = 1;
                break;
            }
            case 3: {
                if (this.startDay == 1) break;
                this.startDay = 1 + this.startDay / 7;
                break;
            }
            case 4: {
                if (this.startDay >= 30) {
                    this.startDay = -1;
                    break;
                }
                this.startDay = 1 + this.startDay / 7;
                break;
            }
        }
        switch (this.endMode) {
            case 1: {
                this.endDay = 1 + this.endDay / 7;
                this.endDayOfWeek = 1;
                return;
            }
            case 3: {
                if (this.endDay == 1) break;
                this.endDay = 1 + this.endDay / 7;
                return;
            }
            case 4: {
                if (this.endDay >= 30) {
                    this.endDay = -1;
                    return;
                }
                this.endDay = 1 + this.endDay / 7;
                return;
            }
        }
    }

    private byte[] packRules() {
        byte[] byArray = new byte[]{(byte)this.startDay, (byte)this.startDayOfWeek, (byte)this.endDay, (byte)this.endDayOfWeek};
        return byArray;
    }

    private void unpackRules(byte[] byArray) {
        this.startDay = byArray[0];
        this.startDayOfWeek = byArray[1];
        this.endDay = byArray[2];
        this.endDayOfWeek = byArray[3];
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        byte[] byArray = this.packRules();
        this.makeRulesCompatible();
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(byArray.length);
        objectOutputStream.write(byArray);
        this.unpackRules(byArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            if (this.startDayOfWeek == 0) {
                this.startDayOfWeek = 1;
            }
            if (this.endDayOfWeek == 0) {
                this.endDayOfWeek = 1;
            }
            this.endMode = 2;
            this.startMode = 2;
            this.dstSavings = 3600000;
        } else {
            int n = objectInputStream.readInt();
            byte[] byArray = new byte[n];
            objectInputStream.readFully(byArray);
            this.unpackRules(byArray);
        }
        this.serialVersionOnStream = 1;
    }
}

