/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public class TreeMap
extends AbstractMap
implements SortedMap,
Cloneable,
Serializable {
    private Comparator comparator;
    private transient Entry root;
    private transient int size;
    private transient int modCount;
    private transient Set keySet;
    private transient Set entrySet;
    private transient Collection values;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;
    private static final boolean RED = false;
    private static final boolean BLACK = true;

    private void incrementSize() {
        ++this.modCount;
        ++this.size;
    }

    private void decrementSize() {
        ++this.modCount;
        --this.size;
    }

    public TreeMap() {
    }

    public TreeMap(Comparator comparator) {
        this.comparator = comparator;
    }

    public TreeMap(Map map) {
        this.putAll(map);
    }

    public TreeMap(SortedMap sortedMap) {
        this.comparator = sortedMap.comparator();
        this.putAll(sortedMap);
    }

    public int size() {
        return this.size;
    }

    public boolean containsKey(Object object) {
        return this.getEntry(object) != null;
    }

    public Object get(Object object) {
        Entry entry = this.getEntry(object);
        if (entry == null) {
            return null;
        }
        return entry.value;
    }

    public Comparator comparator() {
        return this.comparator;
    }

    public Object firstKey() {
        return TreeMap.key(this.firstEntry());
    }

    public Object lastKey() {
        return TreeMap.key(this.lastEntry());
    }

    private Entry getEntry(Object object) {
        Entry entry = this.root;
        while (entry != null) {
            int n = this.compare(object, entry.key);
            if (n == 0) {
                return entry;
            }
            entry = n < 0 ? entry.left : entry.right;
        }
        return null;
    }

    private Entry getCeilEntry(Object object) {
        Entry entry = this.root;
        if (entry == null) {
            return null;
        }
        while (true) {
            int n;
            if ((n = this.compare(object, entry.key)) == 0) {
                return entry;
            }
            if (n < 0) {
                if (entry.left != null) {
                    entry = entry.left;
                    continue;
                }
                return entry;
            }
            if (entry.right == null) break;
            entry = entry.right;
        }
        Entry entry2 = entry.parent;
        Entry entry3 = entry;
        while (entry2 != null && entry3 == entry2.right) {
            entry3 = entry2;
            entry2 = entry2.parent;
        }
        return entry2;
    }

    private Entry getPrecedingEntry(Object object) {
        Entry entry = this.root;
        if (entry == null) {
            return null;
        }
        while (true) {
            int n;
            if ((n = this.compare(object, entry.key)) > 0) {
                if (entry.right != null) {
                    entry = entry.right;
                    continue;
                }
                return entry;
            }
            if (entry.left == null) break;
            entry = entry.left;
        }
        Entry entry2 = entry.parent;
        Entry entry3 = entry;
        while (entry2 != null && entry3 == entry2.left) {
            entry3 = entry2;
            entry2 = entry2.parent;
        }
        return entry2;
    }

    private static Object key(Entry entry) {
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return entry.key;
    }

    public Object put(Object object, Object object2) {
        Entry entry = this.root;
        if (entry == null) {
            this.incrementSize();
            this.root = new Entry(object, object2, null);
            return null;
        }
        while (true) {
            int n;
            if ((n = this.compare(object, entry.key)) == 0) {
                return entry.setValue(object2);
            }
            if (n < 0) {
                if (entry.left != null) {
                    entry = entry.left;
                    continue;
                }
                this.incrementSize();
                entry.left = new Entry(object, object2, entry);
                this.fixAfterInsertion(entry.left);
                return null;
            }
            if (entry.right == null) break;
            entry = entry.right;
        }
        this.incrementSize();
        entry.right = new Entry(object, object2, entry);
        this.fixAfterInsertion(entry.right);
        return null;
    }

    public Object remove(Object object) {
        Entry entry = this.getEntry(object);
        if (entry == null) {
            return null;
        }
        Object object2 = entry.value;
        this.deleteEntry(entry);
        return object2;
    }

    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = null;
    }

    public Object clone() {
        return new TreeMap(this);
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new 1();
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new 2();
        }
        return this.values;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new 3();
        }
        return this.entrySet;
    }

    public SortedMap subMap(Object object, Object object2) {
        return new SubMap(object, object2);
    }

    public SortedMap headMap(Object object) {
        return new SubMap(object, true);
    }

    public SortedMap tailMap(Object object) {
        return new SubMap(object, false);
    }

    private int compare(Object object, Object object2) {
        if (this.comparator == null) {
            return ((Comparable)object).compareTo(object2);
        }
        return this.comparator.compare(object, object2);
    }

    private static boolean valEquals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    private Entry firstEntry() {
        Entry entry = this.root;
        if (entry != null) {
            while (entry.left != null) {
                entry = entry.left;
            }
        }
        return entry;
    }

    private Entry lastEntry() {
        Entry entry = this.root;
        if (entry != null) {
            while (entry.right != null) {
                entry = entry.right;
            }
        }
        return entry;
    }

    private Entry successor(Entry entry) {
        if (entry == null) {
            return null;
        }
        if (entry.right != null) {
            Entry entry2 = entry.right;
            while (entry2.left != null) {
                entry2 = entry2.left;
            }
            return entry2;
        }
        Entry entry3 = entry.parent;
        Entry entry4 = entry;
        while (entry3 != null && entry4 == entry3.right) {
            entry4 = entry3;
            entry3 = entry3.parent;
        }
        return entry3;
    }

    private static boolean colorOf(Entry entry) {
        if (entry == null) {
            return true;
        }
        return entry.color;
    }

    private static Entry parentOf(Entry entry) {
        if (entry == null) {
            return null;
        }
        return entry.parent;
    }

    private static void setColor(Entry entry, boolean bl) {
        if (entry != null) {
            entry.color = bl;
        }
    }

    private static Entry leftOf(Entry entry) {
        if (entry == null) {
            return null;
        }
        return entry.left;
    }

    private static Entry rightOf(Entry entry) {
        if (entry == null) {
            return null;
        }
        return entry.right;
    }

    private void rotateLeft(Entry entry) {
        Entry entry2 = entry.right;
        entry.right = entry2.left;
        if (entry2.left != null) {
            entry2.left.parent = entry;
        }
        entry2.parent = entry.parent;
        if (entry.parent == null) {
            this.root = entry2;
        } else if (entry.parent.left == entry) {
            entry.parent.left = entry2;
        } else {
            entry.parent.right = entry2;
        }
        entry2.left = entry;
        entry.parent = entry2;
    }

    private void rotateRight(Entry entry) {
        Entry entry2 = entry.left;
        entry.left = entry2.right;
        if (entry2.right != null) {
            entry2.right.parent = entry;
        }
        entry2.parent = entry.parent;
        if (entry.parent == null) {
            this.root = entry2;
        } else if (entry.parent.right == entry) {
            entry.parent.right = entry2;
        } else {
            entry.parent.left = entry2;
        }
        entry2.right = entry;
        entry.parent = entry2;
    }

    private void fixAfterInsertion(Entry entry) {
        entry.color = false;
        while (entry != null && entry != this.root && !entry.parent.color) {
            Entry entry2;
            if (TreeMap.parentOf(entry) == TreeMap.leftOf(TreeMap.parentOf(TreeMap.parentOf(entry)))) {
                entry2 = TreeMap.rightOf(TreeMap.parentOf(TreeMap.parentOf(entry)));
                if (!TreeMap.colorOf(entry2)) {
                    TreeMap.setColor(TreeMap.parentOf(entry), true);
                    TreeMap.setColor(entry2, true);
                    TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(entry)), false);
                    entry = TreeMap.parentOf(TreeMap.parentOf(entry));
                    continue;
                }
                if (entry == TreeMap.rightOf(TreeMap.parentOf(entry))) {
                    entry = TreeMap.parentOf(entry);
                    this.rotateLeft(entry);
                }
                TreeMap.setColor(TreeMap.parentOf(entry), true);
                TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(entry)), false);
                if (TreeMap.parentOf(TreeMap.parentOf(entry)) == null) continue;
                this.rotateRight(TreeMap.parentOf(TreeMap.parentOf(entry)));
                continue;
            }
            entry2 = TreeMap.leftOf(TreeMap.parentOf(TreeMap.parentOf(entry)));
            if (!TreeMap.colorOf(entry2)) {
                TreeMap.setColor(TreeMap.parentOf(entry), true);
                TreeMap.setColor(entry2, true);
                TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(entry)), false);
                entry = TreeMap.parentOf(TreeMap.parentOf(entry));
                continue;
            }
            if (entry == TreeMap.leftOf(TreeMap.parentOf(entry))) {
                entry = TreeMap.parentOf(entry);
                this.rotateRight(entry);
            }
            TreeMap.setColor(TreeMap.parentOf(entry), true);
            TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(entry)), false);
            if (TreeMap.parentOf(TreeMap.parentOf(entry)) == null) continue;
            this.rotateLeft(TreeMap.parentOf(TreeMap.parentOf(entry)));
        }
        this.root.color = true;
    }

    private void deleteEntry(Entry entry) {
        Entry entry2;
        this.decrementSize();
        if (entry.left != null && entry.right != null) {
            entry2 = this.successor(entry);
            this.swapPosition(entry2, entry);
        }
        Entry entry3 = entry2 = entry.left != null ? entry.left : entry.right;
        if (entry2 != null) {
            entry2.parent = entry.parent;
            if (entry.parent == null) {
                this.root = entry2;
            } else if (entry == entry.parent.left) {
                entry.parent.left = entry2;
            } else {
                entry.parent.right = entry2;
            }
            entry.parent = null;
            entry.right = null;
            entry.left = null;
            if (entry.color) {
                this.fixAfterDeletion(entry2);
                return;
            }
        } else {
            if (entry.parent == null) {
                this.root = null;
                return;
            }
            if (entry.color) {
                this.fixAfterDeletion(entry);
            }
            if (entry.parent != null) {
                if (entry == entry.parent.left) {
                    entry.parent.left = null;
                } else if (entry == entry.parent.right) {
                    entry.parent.right = null;
                }
                entry.parent = null;
            }
        }
    }

    private void fixAfterDeletion(Entry entry) {
        while (entry != this.root && TreeMap.colorOf(entry)) {
            Entry entry2;
            if (entry == TreeMap.leftOf(TreeMap.parentOf(entry))) {
                entry2 = TreeMap.rightOf(TreeMap.parentOf(entry));
                if (!TreeMap.colorOf(entry2)) {
                    TreeMap.setColor(entry2, true);
                    TreeMap.setColor(TreeMap.parentOf(entry), false);
                    this.rotateLeft(TreeMap.parentOf(entry));
                    entry2 = TreeMap.rightOf(TreeMap.parentOf(entry));
                }
                if (TreeMap.colorOf(TreeMap.leftOf(entry2)) && TreeMap.colorOf(TreeMap.rightOf(entry2))) {
                    TreeMap.setColor(entry2, false);
                    entry = TreeMap.parentOf(entry);
                    continue;
                }
                if (TreeMap.colorOf(TreeMap.rightOf(entry2))) {
                    TreeMap.setColor(TreeMap.leftOf(entry2), true);
                    TreeMap.setColor(entry2, false);
                    this.rotateRight(entry2);
                    entry2 = TreeMap.rightOf(TreeMap.parentOf(entry));
                }
                TreeMap.setColor(entry2, TreeMap.colorOf(TreeMap.parentOf(entry)));
                TreeMap.setColor(TreeMap.parentOf(entry), true);
                TreeMap.setColor(TreeMap.rightOf(entry2), true);
                this.rotateLeft(TreeMap.parentOf(entry));
                entry = this.root;
                continue;
            }
            entry2 = TreeMap.leftOf(TreeMap.parentOf(entry));
            if (!TreeMap.colorOf(entry2)) {
                TreeMap.setColor(entry2, true);
                TreeMap.setColor(TreeMap.parentOf(entry), false);
                this.rotateRight(TreeMap.parentOf(entry));
                entry2 = TreeMap.leftOf(TreeMap.parentOf(entry));
            }
            if (TreeMap.colorOf(TreeMap.rightOf(entry2)) && TreeMap.colorOf(TreeMap.leftOf(entry2))) {
                TreeMap.setColor(entry2, false);
                entry = TreeMap.parentOf(entry);
                continue;
            }
            if (TreeMap.colorOf(TreeMap.leftOf(entry2))) {
                TreeMap.setColor(TreeMap.rightOf(entry2), true);
                TreeMap.setColor(entry2, false);
                this.rotateLeft(entry2);
                entry2 = TreeMap.leftOf(TreeMap.parentOf(entry));
            }
            TreeMap.setColor(entry2, TreeMap.colorOf(TreeMap.parentOf(entry)));
            TreeMap.setColor(TreeMap.parentOf(entry), true);
            TreeMap.setColor(TreeMap.leftOf(entry2), true);
            this.rotateRight(TreeMap.parentOf(entry));
            entry = this.root;
        }
        TreeMap.setColor(entry, true);
    }

    private void swapPosition(Entry entry, Entry entry2) {
        boolean bl;
        Entry entry3 = entry.parent;
        Entry entry4 = entry.left;
        Entry entry5 = entry.right;
        Entry entry6 = entry2.parent;
        Entry entry7 = entry2.left;
        Entry entry8 = entry2.right;
        boolean bl2 = entry3 != null && entry == entry3.left;
        boolean bl3 = bl = entry6 != null && entry2 == entry6.left;
        if (entry == entry6) {
            entry.parent = entry2;
            if (bl) {
                entry2.left = entry;
                entry2.right = entry5;
            } else {
                entry2.right = entry;
                entry2.left = entry4;
            }
        } else {
            entry.parent = entry6;
            if (entry6 != null) {
                if (bl) {
                    entry6.left = entry;
                } else {
                    entry6.right = entry;
                }
            }
            entry2.left = entry4;
            entry2.right = entry5;
        }
        if (entry2 == entry3) {
            entry2.parent = entry;
            if (bl2) {
                entry.left = entry2;
                entry.right = entry8;
            } else {
                entry.right = entry2;
                entry.left = entry7;
            }
        } else {
            entry2.parent = entry3;
            if (entry3 != null) {
                if (bl2) {
                    entry3.left = entry2;
                } else {
                    entry3.right = entry2;
                }
            }
            entry.left = entry7;
            entry.right = entry8;
        }
        if (entry.left != null) {
            entry.left.parent = entry;
        }
        if (entry.right != null) {
            entry.right.parent = entry;
        }
        if (entry2.left != null) {
            entry2.left.parent = entry2;
        }
        if (entry2.right != null) {
            entry2.right.parent = entry2;
        }
        boolean bl4 = entry.color;
        entry.color = entry2.color;
        entry2.color = bl4;
        if (this.root == entry) {
            this.root = entry2;
            return;
        }
        if (this.root == entry2) {
            this.root = entry;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        java.util.Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            objectOutputStream.writeObject(entry.key);
            objectOutputStream.writeObject(entry.value);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
            ++n2;
        }
    }

    static /* synthetic */ int access$0() {
        return 0;
    }

    static /* synthetic */ int access$1() {
        return 1;
    }

    static /* synthetic */ int access$6() {
        return 2;
    }

    static /* synthetic */ boolean access$9() {
        return true;
    }

    private final class 1
    extends AbstractSet {
        public java.util.Iterator iterator() {
            return new Iterator(TreeMap.access$0());
        }

        public int size() {
            return TreeMap.this.size();
        }

        public boolean contains(Object object) {
            return TreeMap.this.containsKey(object);
        }

        public boolean remove(Object object) {
            return TreeMap.this.remove(object) != null;
        }

        public void clear() {
            TreeMap.this.clear();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends AbstractCollection {
        public java.util.Iterator iterator() {
            return new Iterator(TreeMap.access$1());
        }

        public int size() {
            return TreeMap.this.size();
        }

        public boolean contains(Object object) {
            Entry entry = TreeMap.this.firstEntry();
            while (entry != null) {
                if (TreeMap.valEquals(entry.getValue(), object)) {
                    return true;
                }
                entry = TreeMap.this.successor(entry);
            }
            return false;
        }

        public boolean remove(Object object) {
            Entry entry = TreeMap.this.firstEntry();
            while (entry != null) {
                if (TreeMap.valEquals(entry.getValue(), object)) {
                    TreeMap.this.deleteEntry(entry);
                    return true;
                }
                entry = TreeMap.this.successor(entry);
            }
            return false;
        }

        public void clear() {
            TreeMap.this.clear();
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends AbstractSet {
        public java.util.Iterator iterator() {
            return new Iterator(TreeMap.access$6());
        }

        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object object2 = entry.getValue();
            Entry entry2 = TreeMap.this.getEntry(entry.getKey());
            return entry2 != null && TreeMap.valEquals(entry2.getValue(), object2);
        }

        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object object2 = entry.getValue();
            Entry entry2 = TreeMap.this.getEntry(entry.getKey());
            if (entry2 != null && TreeMap.valEquals(entry2.getValue(), object2)) {
                TreeMap.this.deleteEntry(entry2);
                return true;
            }
            return false;
        }

        public int size() {
            return TreeMap.this.size();
        }

        public void clear() {
            TreeMap.this.clear();
        }

        /* synthetic */ 3() {
        }
    }

    private class SubMap
    extends AbstractMap
    implements SortedMap,
    Serializable {
        private boolean fromStart = false;
        private boolean toEnd = false;
        private Object fromKey;
        private Object toKey;
        private transient Set entrySet = new EntrySetView();

        SubMap(Object object, Object object2) {
            TreeMap.this = TreeMap.this;
            if (TreeMap.this.compare(object, object2) > 0) {
                throw new IllegalArgumentException("fromKey > toKey");
            }
            this.fromKey = object;
            this.toKey = object2;
        }

        SubMap(Object object, boolean bl) {
            TreeMap.this = TreeMap.this;
            if (bl) {
                this.fromStart = true;
                this.toKey = object;
                return;
            }
            this.toEnd = true;
            this.fromKey = object;
        }

        SubMap(boolean bl, Object object, boolean bl2, Object object2) {
            TreeMap.this = TreeMap.this;
            this.fromStart = bl;
            this.fromKey = object;
            this.toEnd = bl2;
            this.toKey = object2;
        }

        public boolean isEmpty() {
            return this.entrySet.isEmpty();
        }

        public boolean containsKey(Object object) {
            return this.inRange(object) && TreeMap.this.containsKey(object);
        }

        public Object get(Object object) {
            if (!this.inRange(object)) {
                return null;
            }
            return TreeMap.this.get(object);
        }

        public Object put(Object object, Object object2) {
            if (!this.inRange(object)) {
                throw new IllegalArgumentException("key out of range");
            }
            return TreeMap.this.put(object, object2);
        }

        public Comparator comparator() {
            return TreeMap.this.comparator;
        }

        public Object firstKey() {
            return TreeMap.key(this.fromStart ? TreeMap.this.firstEntry() : TreeMap.this.getCeilEntry(this.fromKey));
        }

        public Object lastKey() {
            return TreeMap.key(this.toEnd ? TreeMap.this.lastEntry() : TreeMap.this.getPrecedingEntry(this.toKey));
        }

        public Set entrySet() {
            return this.entrySet;
        }

        public SortedMap subMap(Object object, Object object2) {
            if (!this.inRange(object)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            if (!this.inRange2(object2)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new SubMap(object, object2);
        }

        public SortedMap headMap(Object object) {
            if (!this.inRange2(object)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new SubMap(this.fromStart, this.fromKey, false, object);
        }

        public SortedMap tailMap(Object object) {
            if (!this.inRange(object)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            return new SubMap(false, object, this.toEnd, this.toKey);
        }

        private boolean inRange(Object object) {
            return (this.fromStart || TreeMap.this.compare(object, this.fromKey) >= 0) && (this.toEnd || TreeMap.this.compare(object, this.toKey) < 0);
        }

        private boolean inRange2(Object object) {
            return (this.fromStart || TreeMap.this.compare(object, this.fromKey) >= 0) && (this.toEnd || TreeMap.this.compare(object, this.toKey) <= 0);
        }

        private class EntrySetView
        extends AbstractSet {
            private transient int size = -1;
            private transient int sizeModCount;

            public int size() {
                if (this.size == -1 || this.sizeModCount != TreeMap.this.modCount) {
                    this.size = 0;
                    this.sizeModCount = TreeMap.this.modCount;
                    java.util.Iterator iterator = this.iterator();
                    while (iterator.hasNext()) {
                        ++this.size;
                        iterator.next();
                    }
                }
                return this.size;
            }

            public boolean isEmpty() {
                return !this.iterator().hasNext();
            }

            public boolean contains(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Object object2 = entry.getKey();
                if (!SubMap.this.inRange(object2)) {
                    return false;
                }
                Entry entry2 = TreeMap.this.getEntry(object2);
                return entry2 != null && TreeMap.valEquals(entry2.getValue(), entry.getValue());
            }

            public boolean remove(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Object object2 = entry.getKey();
                if (!SubMap.this.inRange(object2)) {
                    return false;
                }
                Entry entry2 = TreeMap.this.getEntry(object2);
                if (entry2 != null && TreeMap.valEquals(entry2.getValue(), entry.getValue())) {
                    TreeMap.this.deleteEntry(entry2);
                    return true;
                }
                return false;
            }

            public java.util.Iterator iterator() {
                TreeMap treeMap = TreeMap.this;
                treeMap.getClass();
                return treeMap.new Iterator(SubMap.this.fromStart ? TreeMap.this.firstEntry() : TreeMap.this.getCeilEntry(SubMap.this.fromKey), SubMap.this.toEnd ? null : TreeMap.this.getCeilEntry(SubMap.this.toKey));
            }

            EntrySetView() {
                SubMap.this = SubMap.this;
            }
        }
    }

    private class Iterator
    implements java.util.Iterator {
        private int type;
        private int expectedModCount;
        private Entry lastReturned;
        private Entry next;
        private Entry firstExcluded;

        Iterator(int n) {
            TreeMap.this = TreeMap.this;
            this.expectedModCount = TreeMap.this.modCount;
            this.type = n;
            this.next = TreeMap.this.firstEntry();
        }

        Iterator(Entry entry, Entry entry2) {
            TreeMap.this = TreeMap.this;
            this.expectedModCount = TreeMap.this.modCount;
            this.type = TreeMap.access$6();
            this.next = entry;
            this.firstExcluded = entry2;
        }

        public boolean hasNext() {
            return this.next != this.firstExcluded;
        }

        public Object next() {
            if (this.next == this.firstExcluded) {
                throw new NoSuchElementException();
            }
            if (TreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.lastReturned = this.next;
            this.next = TreeMap.this.successor(this.next);
            if (this.type == TreeMap.access$0()) {
                return this.lastReturned.key;
            }
            if (this.type == TreeMap.access$1()) {
                return this.lastReturned.value;
            }
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (TreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            TreeMap.this.deleteEntry(this.lastReturned);
            ++this.expectedModCount;
            this.lastReturned = null;
        }
    }

    static class Entry
    implements Map.Entry {
        Object key;
        Object value;
        Entry left;
        Entry right;
        Entry parent;
        boolean color = TreeMap.access$9();

        Entry(Object object, Object object2, Entry entry) {
            this.key = object;
            this.value = object2;
            this.parent = entry;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return TreeMap.valEquals(this.key, entry.getKey()) && TreeMap.valEquals(this.value, entry.getValue());
        }

        public int hashCode() {
            int n = this.key == null ? 0 : this.key.hashCode();
            int n2 = this.value == null ? 0 : this.value.hashCode();
            return n ^ n2;
        }

        public String toString() {
            return String.valueOf(this.key) + "=" + this.value;
        }
    }
}

