/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;

public class TreeSet
extends AbstractSet
implements SortedSet,
Cloneable,
Serializable {
    private transient SortedMap m;
    private transient Set keySet;
    private static final Object PRESENT = new Object();

    private TreeSet(SortedMap sortedMap) {
        this.m = sortedMap;
        this.keySet = sortedMap.keySet();
    }

    public TreeSet() {
        this(new TreeMap());
    }

    public TreeSet(Comparator comparator) {
        this(new TreeMap(comparator));
    }

    public TreeSet(Collection collection) {
        this();
        this.addAll(collection);
    }

    public TreeSet(SortedSet sortedSet) {
        this(sortedSet.comparator());
        this.addAll(sortedSet);
    }

    public Iterator iterator() {
        return this.keySet.iterator();
    }

    public int size() {
        return this.m.size();
    }

    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    public boolean contains(Object object) {
        return this.m.containsKey(object);
    }

    public boolean add(Object object) {
        return this.m.put(object, PRESENT) == null;
    }

    public boolean remove(Object object) {
        return this.m.remove(object) == PRESENT;
    }

    public void clear() {
        this.m.clear();
    }

    public SortedSet subSet(Object object, Object object2) {
        return new TreeSet(this.m.subMap(object, object2));
    }

    public SortedSet headSet(Object object) {
        return new TreeSet(this.m.headMap(object));
    }

    public SortedSet tailSet(Object object) {
        return new TreeSet(this.m.tailMap(object));
    }

    public Comparator comparator() {
        return this.m.comparator();
    }

    public Object first() {
        return this.m.firstKey();
    }

    public Object last() {
        return this.m.lastKey();
    }

    public Object clone() {
        return new TreeSet(this);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.m.comparator());
        objectOutputStream.writeInt(this.m.size());
        Iterator iterator = this.m.keySet().iterator();
        while (iterator.hasNext()) {
            objectOutputStream.writeObject(iterator.next());
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Comparator comparator = (Comparator)objectInputStream.readObject();
        this.m = comparator == null ? new TreeMap() : new TreeMap(comparator);
        this.keySet = this.m.keySet();
        int n = objectInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            this.m.put(objectInputStream.readObject(), PRESENT);
            ++n2;
        }
    }
}

