/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL;

import ORG.as220.tinySQL.Utils;
import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tsColumn;
import ORG.as220.tinySQL.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class DBFHeader {
    public static final short TYPE_DB2 = 2;
    public static final short TYPE_DB3 = 3;
    public static final short TYPE_VISUAL_FOXPRO = 48;
    public static final short TYPE_DB4_SQLTABLE_NOMEMO = 67;
    public static final short TYPE_DB4_SQLSYSTEM_NOMEMO = 99;
    public static final short TYPE_DB3_MEMO = 131;
    public static final short TYPE_DB4_MEMO = 139;
    public static final short TYPE_DB4_SQLTABLE_MEMO = 203;
    public static final short TYPE_FOXPRO2 = 245;
    public static final short TYPE_FOXBASE = 251;
    private short file_update_year = 0;
    private short file_update_month = 0;
    private short file_update_day = 0;
    private int numFields = 0;
    private int numRecords = 0;
    private int headerLength = -1;
    private int recordLength = 0;
    private String encoding;
    private boolean readOnly;
    private static final int BULK_SIZE = 32;
    private static final int FLAG_INDEX = 0;
    private static final int DATE_INDEX = 1;
    private static final int NUMBER_OF_REC_INDEX = 4;
    private static final int LENGTH_OF_HEADER_INDEX = 8;
    private static final int LENGTH_OF_REC_INDEX = 10;
    private static final int RESERVED_INDEX = 12;
    private static final int TABLE_FLAGS = 28;
    private static final int ENCODING_INDEX = 29;
    private static final int DBF_HEADER_SIZE = 32;
    public static final int TABLE_HAS_STRUCTURE_CDX = 1;
    public static final int TABLE_HAS_MEMO_FIELD = 2;
    public static final int TABLE_IS_DATABASE = 4;
    private static final int DBF_COLDEF_SIZE = 32;
    private static final int FIELD_NAME_INDEX = 0;
    private static final int FIELD_TYPE_INDEX = 11;
    private static final int IMU_INDEX = 12;
    private static final int FIELD_LENGTH_INDEX = 16;
    private static final int DECIMAL_COUNT_INDEX = 17;
    private static final int FIELD_FLAGS_INDEX = 18;
    private static final int FIELD_RESERVED_INDEX = 19;
    public static final int FIELD_FLAG_SYSTEM_COLUMN = 1;
    public static final int FIELD_FLAG_IS_NULLABLE = 2;
    public static final int FIELD_FLAG_IS_BINARY = 4;
    private static final int BACKLINK_STRUCTURE_SIZE = 263;
    private byte[] fileHeader;
    private byte[] colHeader;
    private Vector coldefsSorted;
    private RandomAccessFile ff;
    private short type;
    private boolean autoEncoding;

    public DBFHeader(String encoding, boolean automode) throws tinySQLException {
        this.encoding = encoding;
        this.autoEncoding = automode;
        this.fileHeader = new byte[32];
    }

    public void initializeHeader(RandomAccessFile ff) throws tinySQLException {
        try {
            this.readFileHeader(ff);
            this.readColHeader(ff);
        }
        catch (IOException ioe) {
            throw new tinySQLException("Error reading the header of the table", ioe);
        }
    }

    public DBFHeader(DBFHeader old, int numFields, String encoding) throws tinySQLException {
        if (numFields > 255) {
            throw new tinySQLException("There are not more than 255 columns per table supported");
        }
        if (numFields < 0) {
            throw new tinySQLException("Negative column count is invalid.");
        }
        this.encoding = encoding;
        if (encoding == null) {
            throw new NullPointerException("Auto-Mode encoding is not applicable to created tables");
        }
        this.fileHeader = new byte[32];
        System.arraycopy(old.fileHeader, 0, this.fileHeader, 0, 32);
        this.applyFileHeader();
        this.colHeader = old.type == 48 ? new byte[numFields * 32 + 1 + 263] : new byte[numFields * 32 + 1];
        this.setTimestamp();
        this.setNumberOfFields(numFields);
        this.setRecordLength(-1);
        this.setNumRecords(0);
    }

    public DBFHeader(int numFields, short type, String encoding) throws tinySQLException {
        this.encoding = encoding;
        if (encoding == null) {
            throw new NullPointerException("Auto-Mode encoding is not applicable to created tables");
        }
        this.fileHeader = new byte[32];
        this.setTimestamp();
        this.setType(type);
        this.setNumberOfFields(numFields);
        this.setRecordLength(-1);
        this.setNumRecords(0);
        this.colHeader = new byte[this.getHeaderLength() - 32];
    }

    public void create(String dataDir, String tableName) throws tinySQLException {
        try {
            this.mkDataDirectory(dataDir);
            File fullPath = new File(dataDir, tableName + ".DBF");
            if (fullPath.exists()) {
                throw new tinySQLException("Table " + tableName + " exists.");
            }
            this.ff = new RandomAccessFile(fullPath, "rw");
        }
        catch (Exception e) {
            try {
                this.ff.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw new tinySQLException(e);
        }
    }

    public void close() throws IllegalStateException {
        if (this.ff == null) {
            throw new IllegalStateException("This file is not created by create()");
        }
        try {
            this.writeFileHeader(this.ff);
            this.writeColHeader(this.ff);
            this.ff.getFD().sync();
            this.ff.close();
            this.colHeader = null;
            this.fileHeader = null;
        }
        catch (Exception ex) {
            try {
                this.ff.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Log.error("Failed to write the header.", ex);
        }
    }

    public int getNumberOfRecords() {
        return this.numRecords;
    }

    public int getNumberOfFields() {
        return this.numFields;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public int getHeaderLength() {
        return this.headerLength;
    }

    public int getType() {
        return this.type;
    }

    private void setType(short type) {
        this.type = type;
    }

    public Vector getFields() {
        Vector<tsColumn> v = new Vector<tsColumn>(this.coldefsSorted.size());
        Enumeration enumeration = this.coldefsSorted.elements();
        while (enumeration.hasMoreElements()) {
            tsColumn col = new tsColumn((tsColumn)enumeration.nextElement());
            v.addElement(col);
        }
        return v;
    }

    public tsColumn getColumnDefinition(int column) {
        tsColumn col = (tsColumn)this.coldefsSorted.elementAt(column);
        return col;
    }

    public void writeFileHeader(RandomAccessFile ff) throws IOException {
        this.setTimestamp();
        this.fileHeader[0] = (byte)this.type;
        this.fileHeader[29] = (byte)this.transformEncoding(this.encoding);
        ff.seek(0L);
        ff.write(this.fileHeader);
    }

    public void readFileHeader(RandomAccessFile ff) throws IOException {
        ff.seek(0L);
        ff.readFully(this.fileHeader);
        this.applyFileHeader();
    }

    private void applyFileHeader() {
        this.type = Utils.fixByte(this.fileHeader[0]);
        this.file_update_year = Utils.fixByte(this.fileHeader[1]);
        this.file_update_month = Utils.fixByte(this.fileHeader[2]);
        this.file_update_day = Utils.fixByte(this.fileHeader[3]);
        byte[] b = new byte[]{this.fileHeader[4], this.fileHeader[5], this.fileHeader[6], this.fileHeader[7]};
        this.numRecords = (int)Utils.vax_to_long(b);
        b = new byte[]{this.fileHeader[8], this.fileHeader[9]};
        this.headerLength = Utils.vax_to_short(b);
        b[0] = this.fileHeader[10];
        b[1] = this.fileHeader[11];
        this.recordLength = Utils.vax_to_short(b);
        String fileenc = this.resolveEncoding(Utils.fixByte(this.fileHeader[29]));
        if (fileenc == null) {
            Log.info("Unable to determine table codepage, using default: " + this.encoding);
        } else if (this.autoEncoding) {
            Log.info("Table encoding set to : " + fileenc);
            this.encoding = fileenc;
        } else if (!this.encoding.equals(fileenc)) {
            Log.warn("Table encoding of '" + fileenc + "' does not match specified encoding of '" + this.encoding + "'");
        } else {
            Log.info("Table uses encoding of " + this.encoding);
        }
        this.colHeader = new byte[this.headerLength - 32];
    }

    public String getEncoding() {
        return this.encoding;
    }

    private String resolveEncoding(int b) {
        String encoding = this.encoding;
        switch (b) {
            case 15: {
                encoding = "Cp850";
                break;
            }
            case 1: {
                encoding = "Cp437";
                break;
            }
            case 105: {
                encoding = "Cp620";
                break;
            }
            case 106: {
                encoding = "Cp737";
                break;
            }
            case 2: {
                encoding = "Cp850";
                break;
            }
            case 100: {
                encoding = "Cp852";
                break;
            }
            case 107: {
                encoding = "Cp857";
                break;
            }
            case 103: {
                encoding = "Cp861";
                break;
            }
            case 102: {
                encoding = "Cp865";
                break;
            }
            case 101: {
                encoding = "Cp866";
                break;
            }
            case 124: {
                encoding = "Cp874";
                break;
            }
            case 104: {
                encoding = "Cp895";
                break;
            }
            case 123: {
                encoding = "Cp932";
                break;
            }
            case 122: {
                encoding = "Cp936";
                break;
            }
            case 121: {
                encoding = "Cp949";
                break;
            }
            case 120: {
                encoding = "Cp950";
                break;
            }
            case 200: {
                encoding = "Cp1250";
                break;
            }
            case 201: {
                encoding = "Cp1251";
                break;
            }
            case 3: {
                encoding = "Cp1252";
                break;
            }
            case 203: {
                encoding = "Cp1253";
                break;
            }
            case 202: {
                encoding = "Cp1254";
                break;
            }
            case 125: {
                encoding = "Cp1255";
                break;
            }
            case 126: {
                encoding = "Cp1256";
                break;
            }
            case 4: {
                encoding = "Cp10000";
                break;
            }
            case 152: {
                encoding = "Cp10006";
                break;
            }
            case 150: {
                encoding = "Cp10007";
                break;
            }
            case 151: {
                encoding = "Cp10029";
            }
        }
        return encoding;
    }

    public int transformEncoding(String encoding) {
        if (encoding.equals("Cp437")) {
            return 1;
        }
        if (encoding.equals("Cp620")) {
            return 105;
        }
        if (encoding.equals("Cp737")) {
            return 106;
        }
        if (encoding.equals("Cp850")) {
            return 2;
        }
        if (encoding.equals("Cp852")) {
            return 100;
        }
        if (encoding.equals("Cp857")) {
            return 107;
        }
        if (encoding.equals("Cp861")) {
            return 103;
        }
        if (encoding.equals("Cp865")) {
            return 102;
        }
        if (encoding.equals("Cp866")) {
            return 101;
        }
        if (encoding.equals("Cp874")) {
            return 124;
        }
        if (encoding.equals("Cp895")) {
            return 104;
        }
        if (encoding.equals("Cp932")) {
            return 123;
        }
        if (encoding.equals("Cp936")) {
            return 122;
        }
        if (encoding.equals("Cp949")) {
            return 121;
        }
        if (encoding.equals("Cp950")) {
            return 120;
        }
        if (encoding.equals("Cp1250")) {
            return 200;
        }
        if (encoding.equals("Cp1251")) {
            return 201;
        }
        if (encoding.equals("Cp1252")) {
            return 3;
        }
        if (encoding.equals("Cp1253")) {
            return 203;
        }
        if (encoding.equals("Cp1254")) {
            return 202;
        }
        if (encoding.equals("Cp1255")) {
            return 125;
        }
        if (encoding.equals("Cp1256")) {
            return 126;
        }
        if (encoding.equals("Cp10000")) {
            return 4;
        }
        if (encoding.equals("Cp10006")) {
            return 152;
        }
        if (encoding.equals("Cp10007")) {
            return 150;
        }
        if (encoding.equals("Cp10029")) {
            return 151;
        }
        Log.warn("Specified Encoding [" + encoding + "] is not defined, using default: Cp1252");
        return 3;
    }

    public void writeColHeader(RandomAccessFile ff) throws IOException {
        this.colHeader[this.numFields * 32] = 13;
        ff.seek(32L);
        ff.write(this.colHeader);
    }

    public void readColHeader(RandomAccessFile ff) throws IOException {
        ff.seek(32L);
        ff.readFully(this.colHeader);
        Vector<tsColumn> sorted = new Vector<tsColumn>();
        int pos = 1;
        int i = 0;
        int maxI = this.colHeader.length / 32;
        while (this.colHeader[i * 32] != 13 && i < maxI) {
            tsColumn col = this.extractColdef(i);
            col.setBytePosition(pos);
            col.setTablePosition(i);
            sorted.add(col);
            ++i;
            pos += this.calculateSize(col);
        }
        if (pos != this.getRecordLength()) {
            Log.warn("calcuated recordlength does not match defined record length");
        }
        this.numFields = i;
        this.coldefsSorted = sorted;
    }

    private void mkDataDirectory(String dataDir) throws NullPointerException {
        File dd = new File(dataDir);
        if (!dd.exists()) {
            dd.mkdir();
        }
    }

    private void setTimestamp() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        int dd = cal.get(5);
        int mm = cal.get(2) + 1;
        int yy = cal.get(1);
        this.fileHeader[1] = (byte)(yy %= 100);
        this.fileHeader[2] = (byte)mm;
        this.fileHeader[3] = (byte)dd;
    }

    public void updateNumberOfRecords(int numRecords, RandomAccessFile ff) throws IOException {
        this.setNumRecords(numRecords);
        this.writeFileHeader(ff);
    }

    private void setNumRecords(int numRecords) {
        this.numRecords = numRecords;
        byte[] intArray = Utils.intToLittleEndian(numRecords);
        this.fileHeader[4] = intArray[0];
        this.fileHeader[5] = intArray[1];
        this.fileHeader[6] = intArray[2];
        this.fileHeader[7] = intArray[3];
    }

    private void setNumberOfFields(int numFields) throws tinySQLException {
        this.numFields = numFields;
        this.adjustHeaderLength();
    }

    private void adjustHeaderLength() {
        this.headerLength = this.type == 48 ? 33 + this.numFields * 32 + 263 : 33 + this.numFields * 32;
        byte[] hlLE = Utils.shortToLittleEndian((short)this.headerLength);
        this.fileHeader[8] = hlLE[0];
        this.fileHeader[9] = hlLE[1];
    }

    private void setRecordLength(int recordLength) {
        this.recordLength = recordLength;
        if (recordLength < 1) {
            this.fileHeader[10] = 0;
            this.fileHeader[11] = 0;
        } else {
            byte[] rlLE = Utils.shortToLittleEndian((short)recordLength);
            this.fileHeader[10] = rlLE[0];
            this.fileHeader[11] = rlLE[1];
        }
    }

    private void setReserved() throws tinySQLException {
        byte[] reserved = new byte[20];
        int i = 0;
        while (i < reserved.length) {
            this.fileHeader[12 + i] = reserved[i];
            ++i;
        }
    }

    public void setColDefinitions(Vector v) throws tinySQLException {
        if (v.size() != this.numFields) {
            throw new tinySQLException("the specified vector has not enough columndefs");
        }
        try {
            int position = 1;
            int i = 0;
            while (i < v.size()) {
                tsColumn col = (tsColumn)v.elementAt(i);
                this.setColdef(i, col);
                col.setBytePosition(position);
                col.setTablePosition(i);
                position += this.calculateSize(col);
                ++i;
            }
            this.coldefsSorted = new Vector(v);
            this.setRecordLength(position);
        }
        catch (Exception e) {
            throw new tinySQLException(e);
        }
    }

    private int calculateSize(tsColumn col) {
        if (col.getType() == 2005 || col.getType() == 2004) {
            return 10;
        }
        if (col.getType() == 91) {
            return 8;
        }
        if (col.getType() == 93) {
            return 8;
        }
        if (col.getType() == 4) {
            return 4;
        }
        return col.getSize();
    }

    private void setColdef(int pos, tsColumn coldef) throws UnsupportedEncodingException, tinySQLException {
        int arrayPos = pos * 32;
        if (coldef.getPhysicalName().length() > 10) {
            throw new tinySQLException("IllegalName: Name must have a length of 10 or lesser.");
        }
        byte[] colName = Utils.forceToSize(coldef.getPhysicalName(), 11, (byte)0, this.encoding);
        int i = 0;
        while (i < colName.length) {
            this.colHeader[arrayPos + 0 + i] = colName[i];
            ++i;
        }
        int type = 32;
        int coldeftype = coldef.getType();
        switch (coldeftype) {
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                type = 67;
                break;
            }
            case 2004: 
            case 2005: {
                if (this.supportsMemos()) {
                    type = 77;
                    break;
                }
                throw new tinySQLException("This table does not support MEMO");
            }
            case -6: {
                throw new tinySQLException("Inavlid type specified: TINYINT");
            }
            case -5: {
                throw new tinySQLException("Inavlid type specified: BIG INTEGER");
            }
            case 5: {
                throw new tinySQLException("Inavlid type specified: SMALL INT");
            }
            case 4: {
                if (this.supportsInteger()) {
                    type = 73;
                    coldef.setSize(4, 0);
                    break;
                }
                throw new tinySQLException("This table does not support INTEGER");
            }
            case 6: {
                throw new tinySQLException("Inavlid type specified: FLOAT");
            }
            case 8: {
                throw new tinySQLException("Inavlid type specified: DOUBLE");
            }
            case 7: {
                throw new tinySQLException("Inavlid type specified: REAL");
            }
            case 2: 
            case 3: {
                type = 78;
                break;
            }
            case -7: {
                if (this.supportsLogical()) {
                    type = 76;
                    coldef.setSize(1, 0);
                    break;
                }
                throw new tinySQLException("This table does not support LOGICAL");
            }
            case 91: {
                type = 68;
                coldef.setSize(8, 0);
                break;
            }
            case 93: {
                if (!this.supportsTimestamp()) {
                    throw new tinySQLException("This table does not support TIMESTAMP");
                }
                type = this.getType() == 48 ? 84 : 64;
                coldef.setSize(8, 4);
                break;
            }
            default: {
                throw new tinySQLException("Inavlid type specified, unable to determine type");
            }
        }
        this.colHeader[arrayPos + 11] = (byte)type;
        this.colHeader[arrayPos + 12 + 0] = 0;
        this.colHeader[arrayPos + 12 + 1] = 0;
        this.colHeader[arrayPos + 12 + 2] = 0;
        this.colHeader[arrayPos + 12 + 3] = 0;
        if (type == 67) {
            byte[] b = Utils.shortToLittleEndian((short)coldef.getSize());
            this.colHeader[arrayPos + 16] = b[0];
            this.colHeader[arrayPos + 17] = b[1];
        } else {
            this.colHeader[arrayPos + 16] = (byte)coldef.getSize();
            this.colHeader[arrayPos + 17] = (byte)coldef.getDecimalPlaces();
        }
        this.colHeader[arrayPos + 18] = this.getFieldFlags(coldef);
        byte[] colReserve = Utils.forceToSize(null, 13, (byte)0, this.encoding);
        int i2 = 0;
        while (i2 < colReserve.length) {
            this.colHeader[arrayPos + 19 + i2] = colReserve[i2];
            ++i2;
        }
    }

    private byte getFieldFlags(tsColumn col) {
        int fieldFlags = 0;
        if (col.isNullable()) {
            fieldFlags = 2;
        }
        if (col.getType() == -2 || col.getType() == 2004 || col.getType() == -3 || col.getType() == 93 || col.getType() == 4 || col.getType() == 8) {
            fieldFlags = (short)(fieldFlags | 4);
        }
        return (byte)fieldFlags;
    }

    private tsColumn extractColdef(int pos) throws UnsupportedEncodingException {
        int arrayPos = pos * 32;
        int strsize = this.seekNull(this.colHeader, arrayPos + 0, 11);
        String name = new String(this.colHeader, arrayPos + 0, strsize, this.encoding);
        char type = (char)this.colHeader[arrayPos + 11];
        int length = Utils.fixByte(this.colHeader[arrayPos + 16]);
        short decimals = Utils.fixByte(this.colHeader[arrayPos + 17]);
        if (type == 'C') {
            length += decimals * 256;
            decimals = 0;
        }
        short colFlags = this.colHeader[arrayPos + 18];
        tsColumn retval = new tsColumn(null, name);
        retval.setType(this.charToSqlType(type));
        retval.setSize(length, decimals);
        this.checkFieldAfterRead(colFlags, retval);
        return retval;
    }

    private void checkFieldAfterRead(short flags, tsColumn col) {
        if ((flags & 2) == 2) {
            col.setNullable(true);
        }
        if ((flags & 4) == 4) {
            if (col.getType() == 1) {
                col.setType(-2);
            } else if (col.getType() == 2005) {
                col.setType(2004);
            } else if (col.getType() == 12) {
                col.setType(2004);
            }
        }
    }

    private int seekNull(byte[] b, int offset, int len) {
        int i = offset;
        while (i < len + offset) {
            byte by = b[i];
            if (by == 0) {
                return i - offset;
            }
            ++i;
        }
        return len;
    }

    protected static String typeToLiteral(int type) {
        if (type == 1) {
            return "CHAR";
        }
        if (type == 2) {
            return "NUMERIC";
        }
        if (type == -7) {
            return "BOOLEAN";
        }
        if (type == 4) {
            return "INTEGER";
        }
        if (type == -2) {
            return "BINARY";
        }
        if (type == 91) {
            return "DATE";
        }
        if (type == 2004) {
            return "BLOB";
        }
        if (type == 2005) {
            return "CLOB";
        }
        if (type == 93) {
            return "TIMESTAMP";
        }
        return "BINARY";
    }

    protected int charToSqlType(char type) {
        if (type == 'C') {
            return 1;
        }
        if (type == 'N') {
            return 2;
        }
        if (type == 'L') {
            return -7;
        }
        if (type == 'M') {
            return 2005;
        }
        if (type == 'D') {
            return 91;
        }
        if (type == 'I') {
            return 4;
        }
        if (type == 'T') {
            return 93;
        }
        if (type == '@') {
            return 93;
        }
        return -2;
    }

    public void copyDBFHeader(DBFHeader header) throws tinySQLException {
        if (this.getRecordLength() != 0) {
            throw new tinySQLException("This function is only valid on empty/new tables");
        }
        byte[] newFileHeader = new byte[32];
        System.arraycopy(header.fileHeader, 0, newFileHeader, 0, 32);
        newFileHeader[1] = this.fileHeader[1];
        newFileHeader[2] = this.fileHeader[2];
        newFileHeader[3] = this.fileHeader[3];
        newFileHeader[8] = this.fileHeader[8];
        newFileHeader[9] = this.fileHeader[9];
        newFileHeader[10] = this.fileHeader[10];
        newFileHeader[11] = this.fileHeader[11];
        byte[] newColHeader = null;
        int normColHeaderLength = this.numFields * 32 + 1;
        if (this.type == 48) {
            newColHeader = new byte[normColHeaderLength + 263];
            System.arraycopy(this.colHeader, 0, newColHeader, 0, this.colHeader.length);
            System.arraycopy(header.colHeader, normColHeaderLength, newColHeader, 0, 263);
        } else {
            newColHeader = new byte[normColHeaderLength];
            System.arraycopy(this.colHeader, 0, newColHeader, 0, this.colHeader.length);
        }
    }

    public boolean supportsMemos() {
        return (this.type & 4) == 4 || (this.type & 0x80) == 128;
    }

    public boolean supportsLogical() {
        return this.type != 2 && this.type != 251;
    }

    public boolean supportsInteger() {
        return this.type == 48 || this.type == 139 || this.type == 99 || this.type == 203 || this.type == 67;
    }

    public boolean supportsTimestamp() {
        return this.type == 48 || this.type == 139 || this.type == 99 || this.type == 203 || this.type == 67;
    }
}

