/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL;

import ORG.as220.tinySQL.Utils;
import ORG.as220.tinySQL.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.filechooser.FileSystemView;

public class Utils {
    public static final byte[] intToLittleEndian(int val) {
        byte[] b = new byte[4];
        int i = 0;
        while (i < 4) {
            b[i] = (byte)(val % 256);
            val /= 256;
            ++i;
        }
        return b;
    }

    public static final byte[] shortToLittleEndian(short val) {
        byte[] b = new byte[2];
        int i = 0;
        while (i < 2) {
            b[i] = (byte)(val % 256);
            val = (short)(val / 256);
            ++i;
        }
        return b;
    }

    public static final double vax_to_long(byte[] b) {
        long lngTmp = 0xFFL & (long)b[0] | (0xFFL & (long)b[1]) << 8 | (0xFFL & (long)b[2]) << 16 | (0xFFL & (long)b[3]) << 24;
        return lngTmp;
    }

    public static final int vax_to_short(byte[] b) {
        return Utils.fixByte(b[0]) + Utils.fixByte(b[1]) * 256;
    }

    public static final short fixByte(byte b) {
        if (b < 0) {
            return (short)(b + 256);
        }
        return b;
    }

    public static final byte[] forceToSize(String str, int size, byte padByte, String encoding) throws UnsupportedEncodingException {
        if (str != null && str.length() == size) {
            return str.getBytes(encoding);
        }
        byte[] result = new byte[size];
        if (str == null) {
            Arrays.fill(result, padByte);
            return result;
        }
        if (str.length() > size) {
            return str.substring(0, size).getBytes(encoding);
        }
        byte[] tmp = str.getBytes(encoding);
        System.arraycopy(tmp, 0, result, 0, tmp.length);
        Arrays.fill(result, tmp.length, result.length, padByte);
        return result;
    }

    public static final char[] forceToSize(String str, int size, char padByte) throws UnsupportedEncodingException {
        if (str != null && str.length() == size) {
            return str.toCharArray();
        }
        char[] result = new char[size];
        if (str == null) {
            Arrays.fill(result, padByte);
            return result;
        }
        if (str.length() > size) {
            return str.substring(0, size).toCharArray();
        }
        str.getChars(0, str.length(), result, 0);
        Arrays.fill(result, str.length(), result.length, padByte);
        return result;
    }

    public static final byte[] forceToSizeLeft(String str, int size, byte padByte, String encoding) throws UnsupportedEncodingException {
        if (str != null && str.length() == size) {
            return str.getBytes(encoding);
        }
        byte[] result = new byte[size];
        if (str == null) {
            Arrays.fill(result, padByte);
            return result;
        }
        if (str.length() > size) {
            return str.substring(0, size).getBytes(encoding);
        }
        byte[] tmp = str.getBytes(encoding);
        int padSize = result.length - tmp.length;
        System.arraycopy(tmp, 0, result, padSize, tmp.length);
        Arrays.fill(result, 0, padSize, padByte);
        return result;
    }

    public static String forceToSizeLeft(String str, int size, char padChar) {
        if (str != null && str.length() == size) {
            return str;
        }
        StringBuffer tmp = str == null ? new StringBuffer(size) : new StringBuffer(str);
        if (tmp.length() > size) {
            tmp.setLength(size);
            return tmp.toString();
        }
        StringBuffer t2 = new StringBuffer(size);
        int arsize = size - tmp.length();
        char[] ar = new char[arsize];
        int i = 0;
        while (i < arsize) {
            ar[i] = padChar;
            ++i;
        }
        t2.append(ar);
        t2.append((Object)tmp);
        return t2.toString();
    }

    public static final void delFile(String fname) throws NullPointerException, IOException {
        File f = new File(fname);
        if (f.exists()) {
            if (!f.delete()) {
                throw new IOException("Could not delete file: " + fname + ".");
            }
        } else {
            Log.debug("File: " + fname + " does not exist. No action taken on delete.");
        }
    }

    public static final void delFile(String dataDir, String fname) throws NullPointerException, IOException {
        File f = new File(dataDir + File.separator + fname);
        if (f.exists() && !f.delete()) {
            throw new IOException("Could not delete file: " + dataDir + "/" + fname + ".");
        }
    }

    public static final boolean renameFile(String oldName, String newName) {
        Log.warn("[Rename] " + oldName + " to " + newName);
        File f_old = new File(oldName);
        File f_new = new File(newName);
        if (!f_old.exists()) {
            Log.warn("File " + oldName + " does not exist");
            return false;
        }
        if (f_new.exists()) {
            Log.warn("File " + newName + " exist");
            return false;
        }
        boolean ret = f_old.renameTo(f_new);
        return ret;
    }

    public static final String stripPathAndExtension(String file) {
        String sep = File.separator;
        int begin = file.lastIndexOf(sep);
        begin = begin < 0 ? 0 : ++begin;
        int end = file.lastIndexOf(".");
        if (end < 0) {
            end = file.length();
        }
        String str = file.substring(begin, end);
        return str;
    }

    public static final Vector getAllFiles(String path, String suffix) {
        class MyDir
        extends FileSystemView {
            MyDir() {
            }

            public File createNewFolder(File containingDir) {
                return null;
            }

            public File[] getRoots() {
                return null;
            }

            public boolean isHiddenFile(File f) {
                return false;
            }

            public boolean isRoot(File f) {
                return false;
            }
        }
        MyDir view = new MyDir();
        Vector<File> vec = new Vector<File>(20);
        File dir = view.createFileObject(path);
        File[] ff = view.getFiles(dir, false);
        String upperSuffix = null;
        if (suffix != null) {
            upperSuffix = suffix.toUpperCase();
        }
        int ii = 0;
        while (ii < ff.length) {
            String file = ff[ii].toString().toUpperCase();
            if (upperSuffix == null || file.endsWith(upperSuffix)) {
                vec.addElement(ff[ii]);
            }
            ++ii;
        }
        return vec;
    }

    public static int printResultSet(ResultSet rs, PrintStream out) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        String[] columnLabels = new String[columnCount];
        int[] columnWidths = new int[columnCount];
        int i = 1;
        while (i <= columnCount) {
            columnLabels[i - 1] = rsmd.getColumnLabel(i);
            columnWidths[i - 1] = Math.max(columnLabels[i - 1].length(), rsmd.getColumnDisplaySize(i));
            ++i;
        }
        StringBuffer logString = new StringBuffer();
        int i2 = 1;
        while (i2 <= columnCount) {
            logString.append(Utils.format(rsmd.getColumnLabel(i2), columnWidths[i2 - 1]) + " ");
            ++i2;
        }
        out.println(logString.toString());
        StringBuffer dashedLine = new StringBuffer();
        int i3 = 1;
        while (i3 <= columnCount) {
            int j = 1;
            while (j <= columnWidths[i3 - 1]) {
                dashedLine.append("-");
                ++j;
            }
            dashedLine.append(" ");
            ++i3;
        }
        out.println(dashedLine.toString());
        int retval = 0;
        while (rs.next()) {
            logString.delete(0, logString.length());
            int i4 = 1;
            while (i4 <= columnCount) {
                String value = rs.getString(i4);
                if (rs.wasNull()) {
                    value = "<null>";
                }
                if (value == null) {
                    value = "<!null>";
                }
                logString.append(Utils.format(value, columnWidths[i4 - 1]) + " ");
                ++i4;
            }
            out.println(logString.toString());
            ++retval;
        }
        return retval;
    }

    public static String format(String s, int width) {
        String formattedString;
        if (s.length() < width) {
            StringBuffer buffer = new StringBuffer(s);
            int i = s.length();
            while (i < width) {
                buffer.append(" ");
                ++i;
            }
            formattedString = buffer.toString();
        } else {
            formattedString = s.substring(0, width);
        }
        return formattedString;
    }
}

