/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL;

import ORG.as220.tinySQL.DBFHeader;
import ORG.as220.tinySQL.Utils;
import ORG.as220.tinySQL.dbfFileTable;
import ORG.as220.tinySQL.sqlparser.AlterTableRenameColumnStatement;
import ORG.as220.tinySQL.sqlparser.ColumnDefinition;
import ORG.as220.tinySQL.sqlparser.CreateTableStatement;
import ORG.as220.tinySQL.sqlparser.DropTableStatement;
import ORG.as220.tinySQL.tinySQL;
import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tinySQLTable;
import ORG.as220.tinySQL.tsColumn;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Properties;
import java.util.Vector;

public class dbfFile
extends tinySQL {
    public static final int INSERT_DEFAULT = 0;
    public static final int INSERT_SIZE = 1;
    public static final int INSERT_SPEED = 2;
    private String dataDir;
    private String encoding;
    private boolean autoEnc;
    private boolean readOnly;
    private Properties p;
    private short tabletype;
    private int deleteMode;
    private int insertMode;

    public dbfFile(String d, Properties p) {
        this.dataDir = d;
        this.setProperties(p);
    }

    public void setProperties(Properties p) {
        if (p == null) {
            throw new NullPointerException();
        }
        this.p = p;
        this.encoding = p.getProperty("encoding", "Cp1252");
        this.autoEnc = p.getProperty("autoenc", "true").equalsIgnoreCase("true");
        this.readOnly = p.getProperty("readonly", "false").equalsIgnoreCase("true");
        this.tabletype = this.getTableType(p.getProperty("tabletype", "db3"));
        String insertMode = p.getProperty("config.insert", "default");
        if (insertMode.equals("speed")) {
            this.insertMode = 2;
        } else {
            this.deleteMode = insertMode.equals("size") ? 1 : 0;
        }
    }

    private short getTableType(String type) {
        if (type.equalsIgnoreCase("db3")) {
            return 3;
        }
        if (type.equalsIgnoreCase("db3memo")) {
            return 131;
        }
        if (type.equalsIgnoreCase("db4memo")) {
            return 139;
        }
        if (type.equalsIgnoreCase("db4sqlsys")) {
            return 99;
        }
        if (type.equalsIgnoreCase("db4sqlmemo")) {
            return 203;
        }
        if (type.equalsIgnoreCase("db4sql")) {
            return 67;
        }
        if (type.equalsIgnoreCase("db2")) {
            return 2;
        }
        if (type.equalsIgnoreCase("foxbase")) {
            return 251;
        }
        if (type.equalsIgnoreCase("foxpro2")) {
            return 245;
        }
        if (type.equalsIgnoreCase("visualfoxpro")) {
            return 48;
        }
        return 3;
    }

    public void setReadOnly(boolean b) {
        this.readOnly = b;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean CreateTable(CreateTableStatement statement) throws tinySQLException {
        try {
            if (this.readOnly) {
                throw new tinySQLException("dbfFile is in readonly mode");
            }
            String tableName = statement.getTable();
            Vector coldefs = statement.getColumnDefinitions();
            int numCols = coldefs.size();
            boolean recordLength = true;
            Vector<tsColumn> v = new Vector<tsColumn>();
            int i = 0;
            while (i < numCols) {
                ColumnDefinition coldef = (ColumnDefinition)coldefs.elementAt(i);
                tsColumn col = coldef.getColumn();
                v.add(col);
                ++i;
            }
            this.db_createTable(tableName, v);
            return false;
        }
        catch (IOException ioe) {
            throw new tinySQLException(ioe);
        }
    }

    public boolean AlterTableRenameCol(AlterTableRenameColumnStatement statement) throws tinySQLException {
        if (this.readOnly) {
            throw new tinySQLException("dbfFile is in readonly mode");
        }
        String tableName = statement.getTable().getName();
        String fullpath = this.dataDir + File.separator + tableName + ".DBF";
        this.closeTable(tableName);
        try {
            RandomAccessFile ftbl = new RandomAccessFile(fullpath, "rw");
            DBFHeader dbfHeader = new DBFHeader(this.encoding, true);
            dbfHeader.initializeHeader(ftbl);
            dbfHeader.readColHeader(ftbl);
            Vector coldefs = dbfHeader.getFields();
            Vector v = statement.getColumns();
            int i = 0;
            while (i < v.size()) {
                AlterTableRenameColumnStatement.RenameColumnTuple t = (AlterTableRenameColumnStatement.RenameColumnTuple)v.elementAt(i);
                tsColumn col = t.oldcol;
                col.setPhysicalName(t.newname);
                coldefs.setElementAt(col, col.getTablePosition());
                ++i;
            }
            dbfHeader.setColDefinitions(coldefs);
            dbfHeader.writeFileHeader(ftbl);
            dbfHeader.writeColHeader(ftbl);
            ftbl.close();
        }
        catch (Exception e) {
            throw new tinySQLException(e);
        }
        return false;
    }

    public tinySQLTable openTable(String tableName) throws tinySQLException {
        dbfFileTable table = null;
        table = new dbfFileTable(this.dataDir, tableName, this.encoding, this.readOnly, this.autoEnc);
        return table;
    }

    protected void db_removeTable(String table_name) throws tinySQLException, IOException {
        if (this.readOnly) {
            throw new tinySQLException("dbfFile is in readonly mode");
        }
        Utils.delFile(this.dataDir + File.separator + table_name + ".DBF");
    }

    protected void db_renameTable(String table_name, String newname) throws tinySQLException, IOException {
        String dest;
        if (this.readOnly) {
            throw new tinySQLException("dbfFile is in readonly mode");
        }
        String source = this.dataDir + File.separator + table_name + ".DBF";
        if (!Utils.renameFile(source, dest = this.dataDir + File.separator + newname + ".DBF")) {
            throw new IOException("Renaming of " + table_name + " to " + newname + " failed");
        }
    }

    protected void db_createTable(String table_name, Vector v) throws IOException, tinySQLException {
        if (this.readOnly) {
            throw new tinySQLException("dbfFile is in readonly mode");
        }
        int size = v.size();
        DBFHeader dbfHeader = new DBFHeader(size, this.tabletype, this.encoding);
        dbfHeader.create(this.dataDir, table_name);
        dbfHeader.setColDefinitions(v);
        dbfHeader.close();
    }

    protected void db_copyTableMeta(String orgTable, String newname, Vector v) throws IOException, tinySQLException {
        dbfFileTable table = new dbfFileTable(this.dataDir, orgTable, this.encoding, true, this.autoEnc);
        DBFHeader header = table.getHeader();
        table.close();
        if (this.readOnly) {
            throw new tinySQLException("dbfFile is in readonly mode");
        }
        int size = v.size();
        DBFHeader dbfHeader = new DBFHeader(header, size, this.encoding);
        dbfHeader.create(this.dataDir, newname);
        dbfHeader.setColDefinitions(v);
        dbfHeader.close();
    }

    public void DropTable(DropTableStatement statement) throws tinySQLException {
        if (this.readOnly) {
            throw new tinySQLException("dbfFile is in readonly mode");
        }
        super.DropTable(statement);
    }
}

