/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL;

import ORG.as220.tinySQL.Utils;
import ORG.as220.tinySQL.tinySQLConverter;
import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tsColumn;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class dbfFileConverter
extends tinySQLConverter {
    private String encoding;
    private DecimalFormat numberFormat;
    private TimeZone _defaultZone;
    private static final int DBASE_BASE_DATE = 2440588;
    private static final long DAY_DIV = 86400000L;

    public dbfFileConverter(String encoding) throws UnsupportedEncodingException {
        new String("").getBytes(encoding);
        this.encoding = encoding;
        DecimalFormatSymbols syms = new DecimalFormatSymbols();
        syms.setDecimalSeparator('.');
        this.numberFormat = new DecimalFormat();
        this.numberFormat.setGroupingSize(0);
        this.numberFormat.setDecimalFormatSymbols(syms);
    }

    public Object convertBooleanToNative(tsColumn coldef, Boolean b) throws tinySQLException {
        try {
            if (b.booleanValue()) {
                return Utils.forceToSize("T", 1, (byte)0, this.encoding);
            }
            return Utils.forceToSize("F", 1, (byte)0, this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new tinySQLException("Encoding not supported");
        }
    }

    public Object convertDateToNative(tsColumn coldef, java.sql.Date d) throws tinySQLException {
        try {
            GregorianCalendar cal = new GregorianCalendar();
            cal.clear();
            cal.setTime(d);
            int year = cal.get(1);
            int mon = cal.get(2);
            int day = cal.get(5);
            StringBuffer b = new StringBuffer(8);
            b.append(Utils.forceToSizeLeft(String.valueOf(year), 4, '0'));
            b.append(Utils.forceToSizeLeft(String.valueOf(mon), 2, '0'));
            b.append(Utils.forceToSizeLeft(String.valueOf(day), 2, '0'));
            return b.toString().getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new tinySQLException("Encoding not supported");
        }
    }

    public Object convertTimeToNative(tsColumn coldef, Time t) throws tinySQLException {
        throw new tinySQLException("Conversion not supported");
    }

    public Object convertNullToNative(tsColumn coldef) throws tinySQLException {
        try {
            if (coldef.isNullable()) {
                return Utils.forceToSize("", coldef.getSize(), (byte)0, this.encoding);
            }
            return Utils.forceToSize("", coldef.getSize(), (byte)32, this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new tinySQLException("Encoding not supported");
        }
    }

    public Object convertNumberToNative(tsColumn col, Number n) throws tinySQLException {
        int size = col.getSize();
        int dec = col.getDecimalPlaces();
        String s = null;
        DecimalFormat decimalFormat = this.numberFormat;
        synchronized (decimalFormat) {
            if (col.getType() == 2 || col.getType() == 3) {
                this.numberFormat.setMaximumIntegerDigits(size - dec);
                this.numberFormat.setMinimumIntegerDigits(dec);
                this.numberFormat.setMaximumFractionDigits(dec);
                this.numberFormat.setMinimumFractionDigits(dec);
                s = this.numberFormat.format(n);
            } else if (col.getType() == -5 || col.getType() == 4 || col.getType() == 5 || col.getType() == -6) {
                this.numberFormat.setMaximumIntegerDigits(size);
                this.numberFormat.setMinimumIntegerDigits(0);
                this.numberFormat.setMaximumFractionDigits(0);
                this.numberFormat.setMinimumFractionDigits(0);
                s = this.numberFormat.format(n);
            } else if (col.getType() == 7 || col.getType() == 6 || col.getType() == 8) {
                this.numberFormat.setMaximumIntegerDigits(size);
                this.numberFormat.setMinimumIntegerDigits(0);
                this.numberFormat.setMaximumFractionDigits(size);
                this.numberFormat.setMinimumFractionDigits(0);
                s = this.numberFormat.format(n);
            }
        }
        if (s == null) {
            Object o = super.convertNumberToNative(col, n);
            s = o == null ? "" : o.toString();
        }
        String s2 = this.leftPadString(s, size);
        try {
            return Utils.forceToSize(s2, size, (byte)32, this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new tinySQLException("Encoding not supported");
        }
    }

    private String leftPadString(String s, int size) throws tinySQLException {
        int pad = size - s.length();
        if (pad > 0) {
            StringBuffer b = new StringBuffer();
            int i = 0;
            while (i < pad) {
                b.append(" ");
                ++i;
            }
            b.append(s);
            b.toString();
        }
        return s;
    }

    public Object convertStringToNative(tsColumn col, String s) throws tinySQLException {
        try {
            int size = col.getSize();
            return Utils.forceToSize(s, size, (byte)32, this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new tinySQLException("Encoding not supported");
        }
    }

    public Object convertNativeToNull(tsColumn col) throws tinySQLException {
        return null;
    }

    public Boolean convertNativeToBoolean(tsColumn coldef, Object o) throws tinySQLException {
        if (o instanceof byte[]) {
            byte[] b = (byte[])o;
            if (b.length == 1 && (b[0] == 84 || b[0] == 116 || b[0] == 89 || b[0] == 121)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return super.convertNativeToBoolean(coldef, o);
    }

    public java.sql.Date convertNativeToDate(tsColumn coldef, Object o) throws tinySQLException {
        byte[] b;
        if (o instanceof byte[] && (b = (byte[])o).length == 8) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.clear();
            int y = this.toNumber(b[0]) * 1000 + this.toNumber(b[1]) * 100 + this.toNumber(b[2]) * 10 + this.toNumber(b[3]);
            int m = this.toNumber(b[4]) * 10 + this.toNumber(b[5]);
            int d = this.toNumber(b[6]) * 10 + this.toNumber(b[7]);
            cal.set(y, m, d);
            return new java.sql.Date(cal.getTime().getTime());
        }
        java.sql.Date d = super.convertNativeToDate(coldef, o);
        if (d == null) {
            throw new tinySQLException("Converter returned null");
        }
        return d;
    }

    private int toNumber(byte b) {
        return b - 48;
    }

    public Time convertNativeToTime(tsColumn coldef, Object o) throws tinySQLException {
        throw new tinySQLException("Conversion not supported");
    }

    public Object convertJDBCToNative(tsColumn col, Object o) throws tinySQLException {
        byte[] b;
        if (o instanceof byte[] && (b = (byte[])o).length == col.getSize()) {
            return b;
        }
        return super.convertJDBCToNative(col, o);
    }

    public String convertNativeToString(tsColumn col, Object o) throws tinySQLException {
        if (o instanceof byte[]) {
            byte[] b = (byte[])o;
            try {
                String s = new String(b, 0, this.seekEnd(b), this.encoding);
                return s.trim();
            }
            catch (UnsupportedEncodingException e) {
                throw new tinySQLException("Encoding not supported");
            }
        }
        return super.convertNativeToString(col, o);
    }

    private int seekEnd(byte[] b) {
        if (b.length == 0) {
            return 0;
        }
        int counter = b.length - 1;
        while (b[counter] != 32 && counter > 0) {
            --counter;
        }
        if (counter == 0) {
            return b.length;
        }
        return counter + 1;
    }

    public BigDecimal convertNativeToNumber(tsColumn col, Object o) throws tinySQLException {
        if (o instanceof byte[]) {
            byte[] b = (byte[])o;
            if (col.getType() == 4) {
                if (b.length != 4) {
                    throw new tinySQLException("An integer is defined as a 4 bytes value");
                }
                return new BigDecimal(Utils.vax_to_long(b));
            }
            if (col.getType() == 8) {
                if (b.length != 8) {
                    throw new tinySQLException("An double is defined as a 8 bytes value");
                }
                throw new tinySQLException("Doubles are not yet supported.");
            }
            try {
                String s = new String(b, 0, b.length, this.encoding).trim();
                if (s.length() == 0) {
                    return new BigDecimal(0.0);
                }
                return new BigDecimal(s);
            }
            catch (UnsupportedEncodingException ue) {
                throw new tinySQLException("Encoding not supported");
            }
            catch (Exception e) {
                throw new tinySQLException("Parsing failed");
            }
        }
        return super.convertNativeToNumber(col, o);
    }

    public Integer convertNativeToInteger(tsColumn coldef, Object o) throws tinySQLException {
        byte[] b;
        if (o instanceof byte[] && (b = (byte[])o).length == 4) {
            return new Integer((int)Utils.vax_to_long(b));
        }
        return super.convertNativeToInteger(coldef, o);
    }

    public Object convertIntegerToNative(tsColumn coldef, Integer o) throws tinySQLException {
        return Utils.intToLittleEndian(o);
    }

    public Timestamp convertNativeToTimestamp(tsColumn coldef, Object o) throws tinySQLException {
        if (o instanceof byte[]) {
            byte[] b = (byte[])o;
            if (b.length == 8) {
                byte[] bd = new byte[4];
                byte[] bm = new byte[4];
                System.arraycopy(b, 0, bd, 0, 4);
                System.arraycopy(b, 4, bm, 0, 4);
                long daytime = dbfFileConverter.calcToTime((int)Utils.vax_to_long(bd));
                long mintime = (long)Utils.vax_to_long(bm);
                if (mintime != 0L) {
                    ++mintime;
                }
                Timestamp ts = new Timestamp(daytime + mintime - (long)this.getTimeZone().getRawOffset());
                return ts;
            }
            throw new tinySQLException("This native data does not represent a timestamp");
        }
        return super.convertNativeToTimestamp(coldef, o);
    }

    public Object convertTimestampToNative(tsColumn coldef, Timestamp o) throws tinySQLException {
        long time = ((Date)o).getTime() + (long)this.getTimeZone().getRawOffset();
        int days = dbfFileConverter.calcFromTime(time);
        int mins = (int)(time % 86400000L);
        byte[] b = new byte[8];
        byte[] bd = Utils.intToLittleEndian(days);
        byte[] bm = Utils.intToLittleEndian(mins);
        System.arraycopy(bd, 0, b, 0, 4);
        System.arraycopy(bm, 0, b, 4, 4);
        return b;
    }

    private TimeZone getTimeZone() {
        if (this._defaultZone == null) {
            this._defaultZone = Calendar.getInstance().getTimeZone();
        }
        return this._defaultZone;
    }

    private static long calcToTime(int fpdate) {
        long time1 = (long)(fpdate - 2440588) * 86400000L;
        return time1;
    }

    private static int calcFromTime(long time) {
        long calctime = time;
        int days = (int)(calctime / 86400000L);
        return days + 2440588;
    }
}

