/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL;

import ORG.as220.tinySQL.DBFHeader;
import ORG.as220.tinySQL.dbfFileConverter;
import ORG.as220.tinySQL.dbfFileRow;
import ORG.as220.tinySQL.tinySQLConverter;
import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tinySQLTable;
import ORG.as220.tinySQL.tsColumn;
import ORG.as220.tinySQL.tsRawRow;
import ORG.as220.tinySQL.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;

public class dbfFileTable
extends tinySQLTable {
    private boolean readonly;
    private String fullpath;
    private DBFHeader dbfHeader;
    private RandomAccessFile ftbl;
    public static final String DBF_EXTENSION = ".DBF";
    private static final int IS_DELETED_INDEX = 0;
    private static final char RECORD_IS_DELETED = '*';
    private static final char RECORD_IS_NOT_DELETED = ' ';
    private dbfFileConverter converter;
    private dbfFileRow prototype;
    private int _rowCount;
    private int _headerLength = -1;
    private int _recordLength = -1;
    private byte[] defaultInsertRow = null;
    private static final int ROW_UNREAD = 0;
    private static final int ROW_DELETED = -1;
    private static final int ROW_NOT_DELETED = 1;
    private byte[] deletedRows;
    private int insertMode;

    public dbfFileTable(String dDir, String table_name, String encoding, boolean readonly, boolean automode) throws tinySQLException {
        super(new File(table_name).getName());
        this.readonly = readonly;
        this.fullpath = table_name.toUpperCase().endsWith(DBF_EXTENSION) ? dDir + File.separator + table_name : dDir + File.separator + table_name + DBF_EXTENSION;
        this.open_dbf(encoding, automode);
    }

    public boolean close() throws tinySQLException {
        try {
            this.ftbl.getFD().sync();
            this.ftbl.close();
        }
        catch (IOException e) {
            throw new tinySQLException(e);
        }
        return true;
    }

    public tsColumn getColumnDefinition(int col) {
        tsColumn coldef = this.dbfHeader.getColumnDefinition(col);
        if (coldef == null) {
            return null;
        }
        return coldef;
    }

    public tinySQLConverter getConverter() throws tinySQLException {
        if (this.converter == null) {
            try {
                this.converter = new dbfFileConverter(this.getHeader().getEncoding());
            }
            catch (Exception e) {
                throw new tinySQLException(e);
            }
        }
        return this.converter;
    }

    public tsRawRow getInsertRow() throws tinySQLException {
        if (this.prototype == null) {
            Vector v = this.getHeader().getFields();
            this.prototype = new dbfFileRow(v, this.getConverter());
        }
        dbfFileRow retval = new dbfFileRow(this.prototype);
        byte[] data = this.createInsertRow();
        retval.setData(data);
        return retval;
    }

    private byte[] createInsertRow() throws tinySQLException {
        if (this.defaultInsertRow == null) {
            tinySQLConverter converter = this.getConverter();
            byte[] data = new byte[this.dbfHeader.getRecordLength()];
            data[0] = 32;
            int i = 0;
            while (i < this.getColumnCount()) {
                tsColumn col = this.getColumnDefinition(i);
                Object o = col.getDefaultValue();
                byte[] b = (byte[])converter.convertJDBCToNative(col, null);
                System.arraycopy(b, 0, data, col.getBytePosition(), b.length);
                ++i;
            }
            this.defaultInsertRow = data;
        }
        return this.defaultInsertRow;
    }

    public void updateRow(int row, tsRawRow values) throws tinySQLException {
        if (this.readonly) {
            throw new tinySQLException("Database is readonly");
        }
        try {
            dbfFileRow datarow = (dbfFileRow)values;
            this.writeRow(row, datarow.getData());
        }
        catch (IOException ioe) {
            throw new tinySQLException(ioe);
        }
    }

    private void writeRow(int currentRecordNumber, byte[] currentUpdateRow) throws IOException {
        this.ftbl.seek(this.calcRowPos(currentRecordNumber));
        this.ftbl.write(currentUpdateRow);
        this.dbfHeader.writeFileHeader(this.ftbl);
    }

    public int insertRow(tsRawRow values) throws tinySQLException {
        if (this.readonly) {
            throw new tinySQLException("Database is readonly");
        }
        int insertRow = 0;
        try {
            dbfFileRow row = (dbfFileRow)values;
            insertRow = this.getNextInsertRow();
            this.ftbl.seek(this.calcRowPos(insertRow));
            this.ftbl.write(row.getData());
            Log.debug("Insert row written on position : " + insertRow);
            if (insertRow == this.getRowCount()) {
                this.setRowCount(insertRow + 1);
            }
        }
        catch (Exception e) {
            throw new tinySQLException(e);
        }
        return insertRow;
    }

    private int findDeletedRow() {
        int i = 0;
        while (i < this.deletedRows.length) {
            if (this.deletedRows[i] == -1) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getNextInsertRow() throws tinySQLException {
        if (this.insertMode == 2) {
            return this.getRowCount();
        }
        int delrow = this.findDeletedRow();
        if (delrow != -1) {
            return delrow;
        }
        if (this.insertMode == 0) {
            return this.getRowCount();
        }
        int i = 0;
        while (i < this.deletedRows.length) {
            boolean del;
            if (this.deletedRows[i] == -1) {
                return i;
            }
            if (this.deletedRows[i] == 0 && (del = this.isDeleted(i))) {
                return i;
            }
            ++i;
        }
        return this.getRowCount();
    }

    /*
     * WARNING - void declaration
     */
    private byte[] _readRow(int pos) throws tinySQLException {
        if (pos < 0) {
            throw new IllegalArgumentException("Position is negative");
        }
        try {
            void e;
            byte[] b = new byte[this.dbfHeader.getRecordLength()];
            this.ftbl.seek(this.calcRowPos(pos));
            this.ftbl.readFully(b);
            return e;
        }
        catch (Exception e) {
            throw new tinySQLException(e);
        }
    }

    public tsRawRow getRow(int row) throws tinySQLException {
        byte[] b;
        if (this.prototype == null) {
            Vector v = this.getHeader().getFields();
            this.prototype = new dbfFileRow(v, this.getConverter());
        }
        this.deletedRows[row] = this.isDeleted(b = this._readRow(row)) ? -1 : 1;
        dbfFileRow myrow = new dbfFileRow(this.prototype);
        myrow.setData(b);
        return myrow;
    }

    public void deleteRow(int row) throws tinySQLException {
        if (row >= this.getRowCount()) {
            throw new tinySQLException("Row is >= rowcount");
        }
        try {
            this.deletedRows[row] = -1;
            this.ftbl.seek(this.calcRowPos(row));
            this.ftbl.writeChar(42);
        }
        catch (IOException ioe) {
            throw new tinySQLException("Unable to delete record " + row);
        }
    }

    private int calcRowPos(int rcdn) {
        return this._headerLength + rcdn * this._recordLength;
    }

    public boolean isDeleted(int row) throws tinySQLException {
        if (this.deletedRows[row] == 0) {
            this.getRow(row);
        }
        return this.deletedRows[row] == -1;
    }

    private boolean isDeleted(byte[] row) throws tinySQLException {
        char c = (char)row[0];
        return c == '*';
    }

    public int getRowCount() {
        return this._rowCount;
    }

    public int getColumnCount() {
        return this.getHeader().getNumberOfFields();
    }

    public int getRecordLength() {
        return this._recordLength;
    }

    private void open_dbf(String encoding, boolean automode) throws tinySQLException {
        try {
            File f = new File(this.fullpath);
            if (!f.exists() || !f.canRead()) {
                throw new tinySQLException("Unable to open datafile (" + this.fullpath + "), file does not exist or can't be read." + f.getAbsolutePath());
            }
            if (f.canWrite() && !this.readonly) {
                this.ftbl = new RandomAccessFile(f, "rw");
            } else {
                this.readonly = true;
                this.ftbl = new RandomAccessFile(f, "r");
            }
            this.dbfHeader = new DBFHeader(encoding, automode);
            this.dbfHeader.initializeHeader(this.ftbl);
            this.dbfHeader.readColHeader(this.ftbl);
        }
        catch (Exception e) {
            try {
                this.ftbl.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw new tinySQLException(e);
        }
        this.setRowCount(this.dbfHeader.getNumberOfRecords());
        this._headerLength = this.dbfHeader.getHeaderLength();
        this._recordLength = this.dbfHeader.getRecordLength();
    }

    private void setRowCount(int rc) throws tinySQLException {
        this._rowCount = rc;
        byte[] _deletedRows = new byte[rc];
        if (this.deletedRows != null) {
            System.arraycopy(this.deletedRows, 0, _deletedRows, 0, Math.min(this.deletedRows.length, _deletedRows.length));
        }
        this.deletedRows = _deletedRows;
        try {
            if (this.dbfHeader.getNumberOfRecords() != rc) {
                this.dbfHeader.updateNumberOfRecords(rc, this.ftbl);
            }
        }
        catch (IOException ioe) {
            throw new tinySQLException(ioe);
        }
    }

    public DBFHeader getHeader() {
        return this.dbfHeader;
    }

    public boolean isReadOnly() {
        return this.readonly;
    }
}

