/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL.parser;

import ORG.as220.tinySQL.parser.ParseException;
import ORG.as220.tinySQL.parser.SimpleCharStream;
import ORG.as220.tinySQL.parser.TinySQLParserConstants;
import ORG.as220.tinySQL.parser.TinySQLParserTokenManager;
import ORG.as220.tinySQL.parser.Token;
import ORG.as220.tinySQL.sqlparser.AlterCreateTableStatement;
import ORG.as220.tinySQL.sqlparser.AlterTableAddColumnStatement;
import ORG.as220.tinySQL.sqlparser.AlterTableDropColumnStatement;
import ORG.as220.tinySQL.sqlparser.AlterTableRenameColumnStatement;
import ORG.as220.tinySQL.sqlparser.ColumnDefinition;
import ORG.as220.tinySQL.sqlparser.ColumnValue;
import ORG.as220.tinySQL.sqlparser.CompactTableStatement;
import ORG.as220.tinySQL.sqlparser.CreateTableStatement;
import ORG.as220.tinySQL.sqlparser.DeleteStatement;
import ORG.as220.tinySQL.sqlparser.DropTableStatement;
import ORG.as220.tinySQL.sqlparser.EmptyStatement;
import ORG.as220.tinySQL.sqlparser.Expression;
import ORG.as220.tinySQL.sqlparser.InsertStatement;
import ORG.as220.tinySQL.sqlparser.JokerColumnValue;
import ORG.as220.tinySQL.sqlparser.LValue;
import ORG.as220.tinySQL.sqlparser.Operator;
import ORG.as220.tinySQL.sqlparser.ParameterValue;
import ORG.as220.tinySQL.sqlparser.SQLStatement;
import ORG.as220.tinySQL.sqlparser.SelectStatement;
import ORG.as220.tinySQL.sqlparser.StaticValue;
import ORG.as220.tinySQL.sqlparser.UpdateStatement;
import ORG.as220.tinySQL.sqlparser.WhereClause;
import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tinySQLStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.Vector;

public class TinySQLParser
implements TinySQLParserConstants {
    public TinySQLParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_gen;
    private final int[] jj_la1 = new int[43];
    private final int[] jj_la1_0 = new int[]{-520093696, 131073, 0x800000, 0, 0, 0, 0x800000, 0x140100, 4096, 0x140100, 0x2000000, 0, 0, 0, 0x400000, 0x140100, 0x400000, 4096, 0, 4096, 262144, 262144, 4096, 4096, 4096, 4096, 0, 0, 4096, 0, 0, 0, 0, 4096, 0, 0, 0x200000, 0x40000000, 0x10000000, 0x10000000, 0x10000000, 0, 4096};
    private final int[] jj_la1_1 = new int[]{0x110104, 0, 2, 32, 0x400000, 16384, 2, 4096, 0, 4096, 0, 0, 0, 0, 8192, 4096, 8192, 0, 0x400000, 0, 196608, 131072, 0, 0, 0, 0, 0x400000, 128, 0, -8388608, 6144, 6144, 0x52000000, 0, -1392508928, 0x800000, 32772, 262144, 0, 0, 0, 524288, 0};
    private final int[] jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, -134184960, 0, -134184960, 0, 0x18000000, -1073709056, 0x38000000, 134209536, 0x38000000, 134209536, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8191, 0, 0, 0, 0, 1551, 6640, 0, 0, 0, 0, 0, 0, 0};
    private final int[] jj_la1_3 = new int[]{0, 0, 0, 0, 0, 0, 0, 161, 0, 161, 0, 0, 0, 0, 0, 161, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public static BigDecimal createBigDecimal(String numeric_literal) {
        try {
            return new BigDecimal(numeric_literal);
        }
        catch (Exception e) {
            return new BigDecimal(0.0);
        }
    }

    public static String stripQuote(String s) {
        if (s.length() < 2) {
            return s;
        }
        return s.substring(1, s.length() - 1);
    }

    public final SQLStatement getStatement(tinySQLStatement statement) throws ParseException, tinySQLException {
        SQLStatement currentStatement = null;
        switch (this.jj_nt.kind) {
            case 48: {
                currentStatement = this.Select(statement);
                break;
            }
            case 52: {
                currentStatement = this.Update(statement);
                break;
            }
            case 40: {
                currentStatement = this.Insert(statement);
                break;
            }
            case 31: {
                currentStatement = this.Delete(statement);
                break;
            }
            case 34: {
                currentStatement = this.DropTable(statement);
                break;
            }
            case 24: {
                currentStatement = this.AlterTable(statement);
                break;
            }
            case 30: {
                currentStatement = this.CreateTable(statement);
                break;
            }
            case 29: {
                currentStatement = this.CompactTable(statement);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_nt.kind) {
            case 17: {
                this.jj_consume_token(17);
                break;
            }
            case 0: {
                this.jj_consume_token(0);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (currentStatement == null) {
            currentStatement = new EmptyStatement(statement);
        }
        return currentStatement;
    }

    public final SQLStatement Select(tinySQLStatement statement) throws ParseException, tinySQLException {
        Object a;
        int i;
        SelectStatement select = new SelectStatement(statement);
        int mod = select.getModifier();
        Vector columnList = null;
        Vector tables = null;
        LValue whereC = null;
        LValue order = null;
        this.jj_consume_token(48);
        switch (this.jj_nt.kind) {
            case 23: 
            case 33: {
                mod = this.getSelectMod();
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
            }
        }
        columnList = this.getSelectColumns();
        switch (this.jj_nt.kind) {
            case 37: {
                tables = this.getSelectTables();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 54: {
                whereC = this.getWhereClauseExpression();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 46: {
                order = this.getOrderBy();
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        select.setModifier(mod);
        if (tables != null) {
            i = 0;
            while (i < tables.size()) {
                a = (AliasedString)tables.elementAt(i);
                select.addTable(((AliasedString)a).item, ((AliasedString)a).alias);
                ++i;
            }
        }
        i = 0;
        while (i < columnList.size()) {
            a = (AliasedItem)columnList.elementAt(i);
            select.addColumn(((AliasedItem)a).item, ((AliasedItem)a).alias);
            ++i;
        }
        if (whereC != null) {
            WhereClause w = new WhereClause(select);
            w.setExpression(whereC);
            select.setWhereClause(w);
        }
        return select;
    }

    public final int getSelectMod() throws ParseException {
        switch (this.jj_nt.kind) {
            case 33: {
                this.jj_consume_token(33);
                return 2;
            }
            case 23: {
                this.jj_consume_token(23);
                return 1;
            }
        }
        this.jj_la1[6] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Vector getSelectColumns() throws ParseException {
        Vector<AliasedItem> retval = null;
        LValue column = null;
        String alias = null;
        switch (this.jj_nt.kind) {
            case 8: 
            case 18: 
            case 20: 
            case 44: 
            case 91: 
            case 92: 
            case 93: 
            case 96: 
            case 101: 
            case 103: {
                column = this.getExpression(0);
                alias = this.getAlias(column.getName());
                break;
            }
            case 79: 
            case 94: 
            case 95: {
                alias = this.getJokerName();
                column = new JokerColumnValue(alias);
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        retval = new Vector<AliasedItem>();
        retval.add(new AliasedItem(column, alias));
        block11: while (true) {
            switch (this.jj_nt.kind) {
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block11;
                }
            }
            this.jj_consume_token(12);
            switch (this.jj_nt.kind) {
                case 8: 
                case 18: 
                case 20: 
                case 44: 
                case 91: 
                case 92: 
                case 93: 
                case 96: 
                case 101: 
                case 103: {
                    column = this.getExpression(0);
                    alias = this.getAlias(column.getName());
                    break;
                }
                case 79: 
                case 94: 
                case 95: {
                    alias = this.getJokerName();
                    column = new JokerColumnValue(alias);
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            retval.add(new AliasedItem(column, alias));
        }
        return retval;
    }

    public final String getAlias(String colname) throws ParseException {
        Object alias_token = null;
        String alias = colname;
        switch (this.jj_nt.kind) {
            case 25: {
                this.jj_consume_token(25);
                alias = this.getString();
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
            }
        }
        return alias;
    }

    public final String getName() throws ParseException {
        Token retval = null;
        String name = null;
        switch (this.jj_nt.kind) {
            case 91: {
                retval = this.jj_consume_token(91);
                name = retval.image;
                break;
            }
            case 92: {
                retval = this.jj_consume_token(92);
                name = TinySQLParser.stripQuote(retval.image);
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return name;
    }

    public final String getJokerName() throws ParseException {
        String name = null;
        Token retval = null;
        switch (this.jj_nt.kind) {
            case 94: {
                retval = this.jj_consume_token(94);
                name = retval.image;
                break;
            }
            case 95: {
                retval = this.jj_consume_token(95);
                name = TinySQLParser.stripQuote(retval.image);
                break;
            }
            case 79: {
                retval = this.jj_consume_token(79);
                name = retval.image;
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return name;
    }

    public final String getString() throws ParseException {
        Token retval = null;
        String val = null;
        switch (this.jj_nt.kind) {
            case 91: {
                retval = this.jj_consume_token(91);
                val = retval.image;
                break;
            }
            case 92: {
                retval = this.jj_consume_token(92);
                val = TinySQLParser.stripQuote(retval.image);
                break;
            }
            case 93: {
                retval = this.jj_consume_token(93);
                val = TinySQLParser.stripQuote(retval.image);
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return retval.image;
    }

    public final LValue getExpression(int level) throws ParseException {
        LValue retval = null;
        Object tail_value = null;
        Object op = null;
        Expression ex = null;
        Object value = null;
        if (level == -1) {
            level = -2;
        }
        retval = this.getLValue(level + 1);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 22: 
                case 45: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: {
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    break block3;
                }
            }
            ex = this.startTail(retval, ex);
        }
        if (ex != null) {
            return ex;
        }
        if (level == 0 && retval instanceof Expression) {
            ex = (Expression)retval;
        }
        return retval;
    }

    public final Expression startTail(LValue retval, Expression ex) throws ParseException {
        LValue val = null;
        Operator op = null;
        op = this.getOperator();
        val = this.getLValue(-1);
        if (ex == null) {
            ex = retval instanceof Expression ? (Expression)retval : new Expression(retval);
        }
        ex.add(op, val);
        return ex;
    }

    public final LValue getLValue(int level) throws ParseException {
        Token value = null;
        LValue retval = null;
        switch (this.jj_nt.kind) {
            case 91: {
                value = this.jj_consume_token(91);
                retval = new ColumnValue(value.image);
                break;
            }
            case 92: {
                value = this.jj_consume_token(92);
                retval = new ColumnValue(TinySQLParser.stripQuote(value.image));
                break;
            }
            case 93: {
                value = this.jj_consume_token(93);
                retval = new StaticValue(TinySQLParser.stripQuote(value.image));
                break;
            }
            case 103: {
                value = this.jj_consume_token(103);
                retval = new StaticValue(TinySQLParser.createBigDecimal(value.image));
                break;
            }
            case 96: {
                value = this.jj_consume_token(96);
                retval = new StaticValue(TinySQLParser.createBigDecimal(value.image));
                break;
            }
            case 101: {
                value = this.jj_consume_token(101);
                retval = new StaticValue(TinySQLParser.createBigDecimal(value.image));
                break;
            }
            case 8: {
                value = this.jj_consume_token(8);
                retval = new StaticValue(TinySQLParser.createBigDecimal(value.image));
                break;
            }
            case 20: {
                value = this.jj_consume_token(20);
                retval = new ParameterValue();
                break;
            }
            case 44: {
                value = this.jj_consume_token(44);
                retval = new StaticValue(null);
                break;
            }
            case 18: {
                this.jj_consume_token(18);
                retval = this.getExpression(level);
                this.jj_consume_token(19);
                if (level == -1) break;
                retval = new Expression(retval);
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return retval;
    }

    public final Operator getOperator() throws ParseException {
        Operator op = null;
        switch (this.jj_nt.kind) {
            case 77: {
                this.jj_consume_token(77);
                op = Operator.ADD;
                break;
            }
            case 78: {
                this.jj_consume_token(78);
                op = Operator.SUB;
                break;
            }
            case 79: {
                this.jj_consume_token(79);
                op = Operator.MULT;
                break;
            }
            case 80: {
                this.jj_consume_token(80);
                op = Operator.DIV;
                break;
            }
            case 82: {
                this.jj_consume_token(82);
                op = Operator.EQUAL;
                break;
            }
            case 81: {
                this.jj_consume_token(81);
                op = Operator.EQUAL;
                break;
            }
            case 83: {
                this.jj_consume_token(83);
                op = Operator.NEQUAL;
                break;
            }
            case 84: {
                this.jj_consume_token(84);
                op = Operator.LEQUAL;
                break;
            }
            case 85: {
                this.jj_consume_token(85);
                op = Operator.GEQUAL;
                break;
            }
            case 86: {
                this.jj_consume_token(86);
                op = Operator.LESSER;
                break;
            }
            case 87: {
                this.jj_consume_token(87);
                op = Operator.GREATER;
                break;
            }
            case 22: {
                this.jj_consume_token(22);
                op = Operator.AND;
                break;
            }
            case 45: {
                this.jj_consume_token(45);
                op = Operator.OR;
                break;
            }
            case 88: {
                this.jj_consume_token(88);
                op = Operator.BETWEEN;
                break;
            }
            case 89: {
                this.jj_consume_token(89);
                op = Operator.NBETWEEN;
                break;
            }
            case 90: {
                this.jj_consume_token(90);
                op = Operator.LIKE;
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return op;
    }

    public final Vector getSelectTables() throws ParseException {
        Vector<AliasedString> v = null;
        String table = null;
        String alias = null;
        this.jj_consume_token(37);
        table = this.getName();
        alias = this.getAlias(table);
        v = new Vector<AliasedString>();
        v.add(new AliasedString(table, alias));
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(12);
            table = this.getName();
            alias = this.getAlias(table);
            v.add(new AliasedString(table, alias));
        }
        return v;
    }

    public final LValue getWhereClauseExpression() throws ParseException {
        LValue lval = null;
        this.jj_consume_token(54);
        lval = this.getExpression(0);
        return lval;
    }

    public final LValue getOrderBy() throws ParseException {
        LValue lval = null;
        this.jj_consume_token(46);
        this.jj_consume_token(27);
        lval = this.getExpression(0);
        return lval;
    }

    public final SQLStatement Update(tinySQLStatement statement) throws ParseException, tinySQLException {
        String table = null;
        Vector cols = new Vector();
        Vector vals = new Vector();
        LValue whereC = null;
        this.jj_consume_token(52);
        table = this.getName();
        this.updateSetColsVals(cols, vals);
        switch (this.jj_nt.kind) {
            case 54: {
                whereC = this.getWhereClauseExpression();
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
            }
        }
        UpdateStatement upd = new UpdateStatement(statement);
        upd.setTable(table);
        int i = 0;
        while (i < cols.size()) {
            upd.addColumn((String)cols.elementAt(i));
            ++i;
        }
        if (whereC != null) {
            WhereClause w = new WhereClause(upd);
            w.setExpression(whereC);
            upd.setWhereClause(w);
        }
        upd.setValues(vals);
        return upd;
    }

    public final void updateSetColsVals(Vector cols, Vector retvals) throws ParseException {
        String name = null;
        LValue expr = null;
        this.jj_consume_token(49);
        name = this.getName();
        this.jj_consume_token(81);
        expr = this.getExpression(0);
        cols.add(name);
        retvals.add(expr);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(12);
            name = this.getName();
            this.jj_consume_token(81);
            expr = this.getExpression(0);
            cols.add(name);
            retvals.add(expr);
        }
    }

    public final SQLStatement Insert(tinySQLStatement statement) throws ParseException, tinySQLException {
        String table = null;
        Vector cols = new Vector();
        Vector vals = new Vector();
        SQLStatement select = null;
        this.jj_consume_token(40);
        this.jj_consume_token(41);
        table = this.getName();
        switch (this.jj_nt.kind) {
            case 48: {
                select = this.Select(statement);
                break;
            }
            case 18: 
            case 49: {
                this.insertColsVals(cols, vals);
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        InsertStatement ins = new InsertStatement(statement);
        ins.setTable(table);
        if (select == null) {
            int i = 0;
            while (i < cols.size()) {
                ins.addColumn((String)cols.elementAt(i));
                ++i;
            }
            int i2 = 0;
            while (i2 < vals.size()) {
                ins.addValues((Vector)vals.elementAt(i2));
                ++i2;
            }
        } else {
            ins.addSelect((SelectStatement)select);
        }
        return ins;
    }

    public final void insertColsVals(Vector cols, Vector vals) throws ParseException {
        switch (this.jj_nt.kind) {
            case 49: {
                this.insertSetColsVals(cols, vals);
                break;
            }
            case 18: {
                this.insertValuesColsVals(cols, vals);
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void insertSetColsVals(Vector cols, Vector vals) throws ParseException {
        String name = null;
        LValue expr = null;
        Vector<LValue> retvals = new Vector<LValue>();
        vals.addElement(retvals);
        this.jj_consume_token(49);
        name = this.getName();
        this.jj_consume_token(81);
        expr = this.getExpression(0);
        cols.add(name);
        retvals.add(expr);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[22] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(12);
            name = this.getName();
            this.jj_consume_token(81);
            expr = this.getExpression(0);
            cols.add(name);
            retvals.add(expr);
        }
    }

    public final void insertValuesColsVals(Vector cols, Vector vals) throws ParseException {
        String name = null;
        Vector valrow = null;
        this.jj_consume_token(18);
        name = this.getName();
        cols.add(name);
        block6: while (true) {
            switch (this.jj_nt.kind) {
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[23] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(12);
            name = this.getName();
            cols.add(name);
        }
        this.jj_consume_token(19);
        this.jj_consume_token(53);
        valrow = this.getInsertValuesVal();
        vals.add(valrow);
        block7: while (true) {
            switch (this.jj_nt.kind) {
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[24] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(12);
            valrow = this.getInsertValuesVal();
            vals.add(valrow);
        }
    }

    public final Vector getInsertValuesVal() throws ParseException {
        Vector<LValue> vals = new Vector<LValue>();
        LValue expr = null;
        this.jj_consume_token(18);
        expr = this.getExpression(0);
        vals.add(expr);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[25] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(12);
            expr = this.getExpression(0);
            vals.add(expr);
        }
        this.jj_consume_token(19);
        return vals;
    }

    public final SQLStatement Delete(tinySQLStatement statement) throws ParseException, tinySQLException {
        String table = null;
        LValue w = null;
        this.jj_consume_token(31);
        this.jj_consume_token(37);
        table = this.getName();
        switch (this.jj_nt.kind) {
            case 54: {
                w = this.getWhereClauseExpression();
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
            }
        }
        DeleteStatement del = new DeleteStatement(statement);
        del.setTable(table);
        if (w != null) {
            WhereClause where = new WhereClause(del);
            where.setExpression(w);
            del.setWhereClause(where);
        }
        return del;
    }

    public final boolean ifExists() throws ParseException {
        this.jj_consume_token(39);
        this.jj_consume_token(36);
        return true;
    }

    public final boolean ifNotExists() throws ParseException {
        this.jj_consume_token(39);
        this.jj_consume_token(43);
        this.jj_consume_token(36);
        return true;
    }

    public final SQLStatement DropTable(tinySQLStatement statement) throws ParseException, tinySQLException {
        String table = null;
        boolean ifex = false;
        this.jj_consume_token(34);
        this.jj_consume_token(50);
        switch (this.jj_nt.kind) {
            case 39: {
                ifex = this.ifExists();
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
            }
        }
        table = this.getName();
        DropTableStatement stmt = new DropTableStatement(statement);
        stmt.setTable(table, ifex);
        return stmt;
    }

    public final SQLStatement CompactTable(tinySQLStatement statement) throws ParseException, tinySQLException {
        String table = null;
        this.jj_consume_token(29);
        this.jj_consume_token(50);
        table = this.getName();
        CompactTableStatement stmt = new CompactTableStatement(statement);
        stmt.setTable(table);
        return stmt;
    }

    public final SQLStatement CreateTable(tinySQLStatement statement) throws ParseException, tinySQLException {
        String table = null;
        Vector coldefs = null;
        this.jj_consume_token(30);
        this.jj_consume_token(50);
        table = this.getName();
        coldefs = this.getColumnDefinitions();
        CreateTableStatement stmt = new CreateTableStatement(statement);
        stmt.setTable(table);
        int size = coldefs.size();
        int i = 0;
        while (i < size) {
            stmt.addColumnDefinition((ColumnDefinition)coldefs.elementAt(i));
            ++i;
        }
        return stmt;
    }

    public final Vector getColumnDefinitions() throws ParseException, tinySQLException {
        Vector<ColumnDefinition> retval = new Vector<ColumnDefinition>();
        ColumnDefinition coldef = null;
        this.jj_consume_token(18);
        coldef = this.getColumnDefinition();
        retval.add(coldef);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[28] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(12);
            coldef = this.getColumnDefinition();
            retval.add(coldef);
        }
        this.jj_consume_token(19);
        return retval;
    }

    public final ColumnDefinition getColumnDefinition() throws ParseException, tinySQLException {
        ColumnDefinition coldef = null;
        String name = null;
        name = this.getName();
        coldef = new ColumnDefinition(name);
        switch (this.jj_nt.kind) {
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 73: 
            case 74: {
                this.getSimpleType(coldef);
                break;
            }
            case 55: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 76: {
                this.getCharType(coldef);
                break;
            }
            case 57: 
            case 60: 
            case 62: {
                this.getNumericType(coldef);
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block5 : switch (this.jj_nt.kind) {
            case 43: 
            case 44: {
                switch (this.jj_nt.kind) {
                    case 44: {
                        this.jj_consume_token(44);
                        coldef.setNullable(true);
                        break block5;
                    }
                    case 43: {
                        this.jj_consume_token(43);
                        this.jj_consume_token(44);
                        coldef.setNullable(false);
                        break block5;
                    }
                }
                this.jj_la1[30] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
            }
        }
        return coldef;
    }

    public final void getNumericType(ColumnDefinition coldef) throws ParseException, tinySQLException {
        int type;
        Token scale = null;
        Token size = null;
        switch (this.jj_nt.kind) {
            case 57: {
                this.jj_consume_token(57);
                type = 2;
                break;
            }
            case 62: {
                this.jj_consume_token(62);
                type = 3;
                break;
            }
            case 60: {
                this.jj_consume_token(60);
                type = 7;
                break;
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(18);
        size = this.jj_consume_token(8);
        switch (this.jj_nt.kind) {
            case 12: {
                this.jj_consume_token(12);
                scale = this.jj_consume_token(8);
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
            }
        }
        this.jj_consume_token(19);
        coldef.setType(type);
        int isize = Integer.parseInt(size.image);
        if (scale != null) {
            int iscale = Integer.parseInt(scale.image);
            coldef.setSize(isize, iscale);
        } else {
            coldef.setSize(isize, 0);
        }
    }

    public final void getSimpleType(ColumnDefinition coldef) throws ParseException, tinySQLException {
        int type;
        Object scale = null;
        Object size = null;
        switch (this.jj_nt.kind) {
            case 56: {
                this.jj_consume_token(56);
                type = 4;
                break;
            }
            case 65: {
                this.jj_consume_token(65);
                type = -5;
                break;
            }
            case 67: {
                this.jj_consume_token(67);
                type = -6;
                break;
            }
            case 66: {
                this.jj_consume_token(66);
                type = 5;
                break;
            }
            case 64: {
                this.jj_consume_token(64);
                type = 7;
                break;
            }
            case 63: {
                this.jj_consume_token(63);
                type = 8;
                break;
            }
            case 58: {
                this.jj_consume_token(58);
                type = 91;
                break;
            }
            case 73: {
                this.jj_consume_token(73);
                type = 92;
                break;
            }
            case 74: {
                this.jj_consume_token(74);
                type = 93;
                break;
            }
            case 61: {
                this.jj_consume_token(61);
                type = -7;
                break;
            }
            case 59: {
                this.jj_consume_token(59);
                type = -7;
                break;
            }
            default: {
                this.jj_la1[34] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        coldef.setType(type);
    }

    public final void getCharType(ColumnDefinition coldef) throws ParseException, tinySQLException {
        Token size = null;
        int type = 0;
        switch (this.jj_nt.kind) {
            case 55: {
                this.jj_consume_token(55);
                type = 1;
                break;
            }
            case 68: {
                this.jj_consume_token(68);
                type = 12;
                break;
            }
            case 69: {
                this.jj_consume_token(69);
                type = -1;
                break;
            }
            case 70: {
                this.jj_consume_token(70);
                type = -2;
                break;
            }
            case 71: {
                this.jj_consume_token(71);
                type = -3;
                break;
            }
            case 72: {
                this.jj_consume_token(72);
                type = -4;
                break;
            }
            case 76: {
                this.jj_consume_token(76);
                type = 2005;
                break;
            }
            case 75: {
                this.jj_consume_token(75);
                type = 2004;
                break;
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(18);
        size = this.jj_consume_token(8);
        this.jj_consume_token(19);
        coldef.setType(type);
        coldef.setSize(Integer.parseInt(size.image));
    }

    public final SQLStatement AlterTable(tinySQLStatement statement) throws ParseException, tinySQLException {
        SQLStatement stmt;
        String name = null;
        this.jj_consume_token(24);
        block0 : switch (this.jj_nt.kind) {
            case 30: {
                stmt = this.AlterCreateTable(statement);
                break;
            }
            case 50: {
                this.jj_consume_token(50);
                name = this.getName();
                switch (this.jj_nt.kind) {
                    case 21: {
                        stmt = this.AlterTableAddColumn(statement, name);
                        break block0;
                    }
                    case 34: {
                        stmt = this.AlterTableDropColumn(statement, name);
                        break block0;
                    }
                    case 47: {
                        stmt = this.AlterTableRenameColumn(statement, name);
                        break block0;
                    }
                }
                this.jj_la1[36] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return stmt;
    }

    public final SQLStatement AlterTableAddColumn(tinySQLStatement statement, String name) throws ParseException, tinySQLException {
        Vector coldefs = null;
        this.jj_consume_token(21);
        switch (this.jj_nt.kind) {
            case 28: {
                this.jj_consume_token(28);
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
            }
        }
        coldefs = this.getColumnDefinitions();
        AlterTableAddColumnStatement stmt = new AlterTableAddColumnStatement(statement);
        stmt.setTable(name);
        int size = coldefs.size();
        int i = 0;
        while (i < size) {
            stmt.addColumn((ColumnDefinition)coldefs.elementAt(i));
            ++i;
        }
        return stmt;
    }

    public final SQLStatement AlterTableDropColumn(tinySQLStatement statement, String name) throws ParseException, tinySQLException {
        Vector columns = null;
        this.jj_consume_token(34);
        switch (this.jj_nt.kind) {
            case 28: {
                this.jj_consume_token(28);
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
            }
        }
        columns = this.getNames();
        AlterTableDropColumnStatement stmt = new AlterTableDropColumnStatement(statement);
        stmt.setTable(name);
        int size = columns.size();
        int i = 0;
        while (i < size) {
            stmt.addColumn((String)columns.elementAt(i));
            ++i;
        }
        return stmt;
    }

    public final SQLStatement AlterTableRenameColumn(tinySQLStatement statement, String name) throws ParseException, tinySQLException {
        String oldCol = null;
        String newCol = null;
        this.jj_consume_token(47);
        switch (this.jj_nt.kind) {
            case 28: {
                this.jj_consume_token(28);
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
            }
        }
        oldCol = this.getName();
        switch (this.jj_nt.kind) {
            case 51: {
                this.jj_consume_token(51);
                break;
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
            }
        }
        newCol = this.getName();
        AlterTableRenameColumnStatement stmt = new AlterTableRenameColumnStatement(statement);
        stmt.setTable(name);
        stmt.addColumn(oldCol, newCol);
        return stmt;
    }

    public final SQLStatement AlterCreateTable(tinySQLStatement statement) throws ParseException, tinySQLException {
        SQLStatement cstmt = null;
        cstmt = this.CreateTable(statement);
        AlterCreateTableStatement stmt = new AlterCreateTableStatement(statement);
        stmt.setCreateTableStatement((CreateTableStatement)cstmt);
        return stmt;
    }

    public final Vector getNames() throws ParseException {
        Vector<String> cols = new Vector<String>();
        String name = null;
        name = this.getName();
        cols.add(name);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[42] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(12);
            name = this.getName();
            cols.add(name);
        }
        return cols;
    }

    public TinySQLParser(InputStream stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new TinySQLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        int i = 0;
        while (i < 43) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(InputStream stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        int i = 0;
        while (i < 43) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public TinySQLParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new TinySQLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        int i = 0;
        while (i < 43) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        int i = 0;
        while (i < 43) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public TinySQLParser(TinySQLParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        int i = 0;
        while (i < 43) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(TinySQLParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        int i = 0;
        while (i < 43) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.jj_nt = this.token;
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    public final ParseException generateParseException() {
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[104];
        int i = 0;
        while (i < 104) {
            la1tokens[i] = false;
            ++i;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        int i2 = 0;
        while (i2 < 43) {
            if (this.jj_la1[i2] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((this.jj_la1_0[i2] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    if ((this.jj_la1_1[i2] & 1 << j) != 0) {
                        la1tokens[32 + j] = true;
                    }
                    if ((this.jj_la1_2[i2] & 1 << j) != 0) {
                        la1tokens[64 + j] = true;
                    }
                    if ((this.jj_la1_3[i2] & 1 << j) != 0) {
                        la1tokens[96 + j] = true;
                    }
                    ++j;
                }
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < 104) {
            if (la1tokens[i3]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i3;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++i3;
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i4 = 0;
        while (i4 < this.jj_expentries.size()) {
            exptokseq[i4] = (int[])this.jj_expentries.elementAt(i4);
            ++i4;
        }
        return new ParseException(this.token, exptokseq, TinySQLParserConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private class AliasedString {
        public String item;
        public String alias;

        public AliasedString(String item, String alias) {
            this.item = item;
            this.alias = alias;
        }
    }

    private class AliasedItem {
        public LValue item;
        public String alias;

        public AliasedItem(LValue item, String alias) {
            this.item = item;
            this.alias = alias;
        }
    }
}

