/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL.sqlparser;

import ORG.as220.tinySQL.sqlparser.ColumnDefinition;
import ORG.as220.tinySQL.sqlparser.SQLStatement;
import ORG.as220.tinySQL.tinySQL;
import ORG.as220.tinySQL.tinySQLConnection;
import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tinySQLResultSet;
import ORG.as220.tinySQL.tinySQLStatement;
import ORG.as220.tinySQL.tinySQLTableView;
import java.sql.SQLException;
import java.util.Vector;

public class AlterTableAddColumnStatement
implements SQLStatement {
    private tinySQL db;
    private tinySQLTableView table;
    private Vector columns;
    private tinySQLStatement statement;
    private int updateCount;

    public AlterTableAddColumnStatement(tinySQLStatement statement) throws tinySQLException {
        try {
            this.statement = statement;
            tinySQLConnection c = (tinySQLConnection)statement.getConnection();
            this.db = c.getTinySqlHandle();
        }
        catch (SQLException sqle) {
            throw new tinySQLException("Unable to resolve connection", sqle);
        }
        this.columns = new Vector();
    }

    public tinySQLTableView getTable() {
        return this.table;
    }

    public void addColumn(ColumnDefinition coldef) throws tinySQLException {
        if (this.table.findColumn(coldef.getName()) != -1) {
            throw new tinySQLException("A column with that name exists in the table");
        }
        this.columns.add(coldef);
    }

    public Vector getColumns() {
        return new Vector(this.columns);
    }

    public void setTable(String tablename) throws tinySQLException {
        this.table = this.getDatabase().getTable(tablename);
    }

    public tinySQL getDatabase() throws tinySQLException {
        return this.db;
    }

    public boolean execute() throws tinySQLException {
        return this.getDatabase().AlterTableAddCol(this);
    }

    public int getUpdateCount() throws tinySQLException {
        return this.updateCount;
    }

    public void setUpdateCount(int uc) throws tinySQLException {
        this.updateCount = uc;
    }

    public tinySQLResultSet getResultSet() throws tinySQLException {
        return null;
    }

    public boolean getMoreResults() throws tinySQLException {
        return false;
    }

    public Vector getParameters() {
        return new Vector();
    }

    public tinySQLStatement getStatement() {
        return this.statement;
    }
}

