/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL.sqlparser;

import ORG.as220.tinySQL.sqlparser.SQLStatement;
import ORG.as220.tinySQL.tinySQL;
import ORG.as220.tinySQL.tinySQLConnection;
import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tinySQLResultSet;
import ORG.as220.tinySQL.tinySQLStatement;
import ORG.as220.tinySQL.tinySQLTableView;
import ORG.as220.tinySQL.tsColumn;
import java.sql.SQLException;
import java.util.Vector;

public class AlterTableRenameColumnStatement
implements SQLStatement {
    private tinySQL db;
    private tinySQLTableView table;
    private Vector columns;

    public AlterTableRenameColumnStatement(tinySQLStatement statement) throws tinySQLException {
        try {
            tinySQLConnection c = (tinySQLConnection)statement.getConnection();
            this.db = c.getTinySqlHandle();
        }
        catch (SQLException sqle) {
            throw new tinySQLException("Unable to resolve connection", sqle);
        }
        this.columns = new Vector();
    }

    public tinySQLTableView getTable() {
        return this.table;
    }

    public void addColumn(String oldname, String newname) {
        tsColumn col = this.table.getColumnDefinition(this.table.findColumn(oldname));
        RenameColumnTuple t = new RenameColumnTuple();
        t.oldcol = col;
        t.newname = newname;
        this.columns.add(t);
    }

    public Vector getColumns() {
        return new Vector(this.columns);
    }

    public void setTable(String tablename) throws tinySQLException {
        this.table = this.getDatabase().getTable(tablename);
    }

    public tinySQL getDatabase() throws tinySQLException {
        return this.db;
    }

    public boolean execute() throws tinySQLException {
        return this.getDatabase().AlterTableRenameCol(this);
    }

    public int getUpdateCount() throws tinySQLException {
        return -1;
    }

    public tinySQLResultSet getResultSet() throws tinySQLException {
        return null;
    }

    public boolean getMoreResults() throws tinySQLException {
        return false;
    }

    public Vector getParameters() {
        return new Vector();
    }

    public class RenameColumnTuple {
        public tsColumn oldcol;
        public String newname;
    }
}

