/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL.sqlparser;

import ORG.as220.tinySQL.sqlparser.ParserUtils;
import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tsColumn;

public class ColumnDefinition {
    private String name;
    private int type;
    private int size;
    private int decimals;
    private boolean nullable;

    public ColumnDefinition(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setSize(int size) throws tinySQLException {
        if (size <= 0) {
            throw new tinySQLException("Size must be > 0");
        }
        this.size = size;
        this.decimals = 0;
    }

    public void setSize(int size, int decimals) throws tinySQLException {
        if (size <= decimals) {
            throw new tinySQLException("Decimals may not be greater or equal to size");
        }
        if (size <= 0) {
            throw new tinySQLException("Size must be > 0");
        }
        this.size = size;
        this.decimals = decimals;
    }

    public int getSize() {
        return this.size;
    }

    public int getDecimals() {
        return this.decimals;
    }

    public void setNullable(boolean b) {
        this.nullable = b;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public tsColumn getColumn() {
        tsColumn myCol = new tsColumn(this.getName());
        if (this.getSize() > 0) {
            myCol.setSize(this.getSize(), this.getDecimals());
        }
        myCol.setType(this.getType());
        myCol.setNullable(this.isNullable());
        return myCol;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("( ");
        b.append(this.name);
        b.append("; type= ");
        b.append(ParserUtils.typeToLiteral(this.type));
        b.append("; size= ");
        if (this.size == 0) {
            b.append("DEFAULT )");
        } else {
            b.append(this.size);
            b.append("; decimals= ");
            b.append(this.decimals);
            b.append(") ");
        }
        return b.toString();
    }
}

