/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL.sqlparser;

import ORG.as220.tinySQL.sqlparser.LValue;
import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tsRow;
import ORG.as220.tinySQL.util.EmptyEnumeration;
import java.util.Enumeration;

public class ColumnValue
implements LValue {
    private String colname;
    private String table;
    private String column;

    public ColumnValue(String colname) {
        this.colname = colname;
        int idx = colname.indexOf(46);
        if (idx == -1) {
            this.table = null;
            this.column = colname;
        } else {
            this.table = colname.substring(0, idx);
            this.column = colname.substring(idx + 1, colname.length());
        }
    }

    public Object evaluate(tsRow row) throws tinySQLException {
        if (row == null) {
            throw new tinySQLException("there is no row to check");
        }
        int index = row.findColumn(this.colname);
        if (index == -1) {
            throw new tinySQLException("column " + this.colname + " was not found");
        }
        Object o = row.get(index);
        return o;
    }

    public String getName() {
        return this.colname;
    }

    public Enumeration getChildren() {
        return EmptyEnumeration.getEnum();
    }

    public int getChildCount() {
        return 0;
    }

    public String getTable() {
        return this.table;
    }

    public String getColumn() {
        return this.column;
    }

    public String toString() {
        return "[ColumnValue(" + this.colname + ")]";
    }
}

