/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL.sqlparser;

import ORG.as220.tinySQL.sqlparser.ColumnDefinition;
import ORG.as220.tinySQL.sqlparser.SQLStatement;
import ORG.as220.tinySQL.tinySQL;
import ORG.as220.tinySQL.tinySQLConnection;
import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tinySQLResultSet;
import ORG.as220.tinySQL.tinySQLStatement;
import java.sql.SQLException;
import java.util.Vector;

public class CreateTableStatement
implements SQLStatement {
    private tinySQL db;
    private String table;
    private Vector columnDefinitions;

    public CreateTableStatement(tinySQLStatement statement) throws tinySQLException {
        try {
            tinySQLConnection c = (tinySQLConnection)statement.getConnection();
            this.db = c.getTinySqlHandle();
        }
        catch (SQLException sqle) {
            throw new tinySQLException("Unable to resolve connection", sqle);
        }
        this.columnDefinitions = new Vector();
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String tablename) throws tinySQLException {
        this.table = tablename;
    }

    public void addColumnDefinition(ColumnDefinition coldef) throws tinySQLException {
        this.columnDefinitions.add(coldef);
    }

    public Vector getColumnDefinitions() {
        return new Vector(this.columnDefinitions);
    }

    public tinySQL getDatabase() throws tinySQLException {
        return this.db;
    }

    public boolean execute() throws tinySQLException {
        return this.getDatabase().CreateTable(this);
    }

    public int getUpdateCount() throws tinySQLException {
        return 0;
    }

    public tinySQLResultSet getResultSet() throws tinySQLException {
        return null;
    }

    public boolean getMoreResults() throws tinySQLException {
        return false;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("CREATE TABLE ");
        b.append(this.getTable());
        b.append("(");
        int i = 0;
        while (i < this.columnDefinitions.size()) {
            if (i != 0) {
                b.append(", ");
            }
            b.append(this.columnDefinitions.elementAt(i));
            ++i;
        }
        b.append(")");
        return b.toString();
    }

    public Vector getParameters() {
        return new Vector();
    }
}

