/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL.sqlparser;

import ORG.as220.tinySQL.sqlparser.ConditionalStatement;
import ORG.as220.tinySQL.sqlparser.ParameterValue;
import ORG.as220.tinySQL.sqlparser.WhereClause;
import ORG.as220.tinySQL.tinySQL;
import ORG.as220.tinySQL.tinySQLConnection;
import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tinySQLResultSet;
import ORG.as220.tinySQL.tinySQLStatement;
import ORG.as220.tinySQL.tinySQLTableView;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;

public class DeleteStatement
implements ConditionalStatement {
    private tinySQL db;
    private int limit;
    private tinySQLTableView table;
    private WhereClause whereC;
    private int updatecount;

    public DeleteStatement(tinySQLStatement statement) throws tinySQLException {
        try {
            tinySQLConnection c = (tinySQLConnection)statement.getConnection();
            this.db = c.getTinySqlHandle();
            this.whereC = new WhereClause(this);
        }
        catch (SQLException sqle) {
            throw new tinySQLException("Unable to resolve connection", sqle);
        }
    }

    public tinySQLTableView getTable() {
        return this.table;
    }

    public Enumeration getTables() {
        Vector<tinySQLTableView> v = new Vector<tinySQLTableView>();
        v.add(this.table);
        return v.elements();
    }

    public void setTable(String tablename) throws tinySQLException {
        this.table = this.getDatabase().getTable(tablename);
    }

    public void setWhereClause(WhereClause c) throws tinySQLException {
        if (c == null) {
            throw new NullPointerException();
        }
        this.whereC = c;
    }

    public WhereClause getWhereClause() {
        return this.whereC;
    }

    public int getLimit() {
        return -1;
    }

    public tinySQL getDatabase() throws tinySQLException {
        return this.db;
    }

    public boolean execute() throws tinySQLException {
        Vector v = this.getParameters();
        int i = 0;
        while (i < v.size()) {
            ParameterValue pv = (ParameterValue)v.elementAt(i);
            if (pv.isEmpty()) {
                throw new tinySQLException("Parameter " + i + " is not yet set");
            }
            ++i;
        }
        if (this.table != null) {
            this.updatecount = this.getDatabase().DeleteStatement(this);
        }
        System.out.println("On DELETE: UpdateCount was " + this.updatecount);
        return false;
    }

    public int getUpdateCount() throws tinySQLException {
        return this.updatecount;
    }

    public tinySQLResultSet getResultSet() throws tinySQLException {
        return null;
    }

    public boolean getMoreResults() throws tinySQLException {
        return false;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("DELETE FROM ");
        b.append(this.table);
        b.append(" ");
        b.append(this.whereC);
        return b.toString();
    }

    public Vector getParameters() {
        return this.whereC.getParameters();
    }
}

