/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL.sqlparser;

import ORG.as220.tinySQL.sqlparser.LValue;
import ORG.as220.tinySQL.sqlparser.Operator;
import ORG.as220.tinySQL.sqlparser.ParserUtils;
import ORG.as220.tinySQL.sqlparser.StaticValue;
import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tsRow;
import ORG.as220.tinySQL.util.Log;
import java.io.PrintWriter;
import java.sql.DriverManager;
import java.util.Enumeration;
import java.util.Vector;

public class Expression
implements LValue {
    private LValue value;
    private Vector addValues = new Vector();
    private boolean transformed;

    public Expression(LValue value) {
        this.value = value;
    }

    public void add(Operator op, LValue value) {
        Vector v = new Vector();
        ParserUtils.getColumnElements(v, value);
        ParserUtils.getParameterElements(v, value);
        if (!(value instanceof StaticValue)) {
            try {
                if (v.size() == 0) {
                    this.addValues.add(new ValueContainer(op, new StaticValue(value.evaluate(null))));
                    return;
                }
            }
            catch (Exception e) {
                Log.error("Exception in optimize", e);
            }
        }
        this.addValues.add(new ValueContainer(op, value));
    }

    private void insert(LValue lv, Operator op) {
        ValueContainer vc = new ValueContainer(op, this.value);
        this.addValues.add(0, vc);
        this.value = lv;
    }

    public Object evaluate(tsRow rowdata) throws tinySQLException {
        if (!this.transformed) {
            this.transformExpression();
            this.transformed = true;
        }
        Object retval = this.value.evaluate(rowdata);
        int i = 0;
        while (i < this.addValues.size()) {
            ValueContainer valcon = (ValueContainer)this.addValues.get(i);
            retval = valcon.op.evaluate(retval, valcon.value.evaluate(rowdata));
            ++i;
        }
        return retval;
    }

    public boolean isWrapper() {
        return this.addValues.size() == 0;
    }

    public String getName() {
        Log.debug("About to transform: " + this.transformed);
        if (!this.transformed) {
            Log.debug("About to transform");
            this.transformExpression();
            this.transformed = true;
        }
        StringBuffer b = new StringBuffer(this.getValueName(this.value));
        int i = 0;
        while (i < this.addValues.size()) {
            ValueContainer valcon = (ValueContainer)this.addValues.get(i);
            b.append(valcon.op.toString());
            b.append(this.getValueName(valcon.value));
            ++i;
        }
        return b.toString();
    }

    private String getValueName(LValue val) {
        if (val instanceof Expression) {
            return "(" + val.getName() + ")";
        }
        return val.getName();
    }

    public Enumeration getChildren() {
        Vector<LValue> v = new Vector<LValue>();
        v.add(this.value);
        int i = 0;
        while (i < this.addValues.size()) {
            ValueContainer valcon = (ValueContainer)this.addValues.get(i);
            v.add(valcon.value);
            ++i;
        }
        return v.elements();
    }

    public int getChildCount() {
        return this.addValues.size();
    }

    protected void transformExpression() {
        int level = 0;
        int i = 0;
        while (i < this.addValues.size()) {
            ValueContainer vc = (ValueContainer)this.addValues.get(i);
            if (vc.op.getLevel() > level) {
                level = vc.op.getLevel();
            }
            ++i;
        }
        boolean[] levelsUsed = new boolean[level + 1];
        int i2 = 0;
        while (i2 < this.addValues.size()) {
            ValueContainer vc = (ValueContainer)this.addValues.get(i2);
            levelsUsed[vc.op.getLevel()] = true;
            ++i2;
        }
        int levelCount = 0;
        int lastLevel = 0;
        int i3 = level;
        while (i3 > -1) {
            if (levelsUsed[i3]) {
                ++levelCount;
                lastLevel = i3;
            }
            --i3;
        }
        if (levelCount < 2) {
            return;
        }
        int i4 = level;
        while (i4 > lastLevel) {
            if (levelsUsed[i4]) {
                this.transformExpression(i4);
            }
            --i4;
        }
    }

    private void transformExpression(int level) {
        Object lv = null;
        int i = this.addValues.size() - 1;
        while (i > -1) {
            if (this.getOperator(i).getLevel() >= level) {
                this.mergeExpressions(i);
            }
            --i;
        }
    }

    private void mergeExpressions(int pos) {
        ValueContainer vc = (ValueContainer)this.addValues.get(pos);
        LValue rightExpr = this.getLValue(pos + 1);
        if (!(rightExpr instanceof Expression)) {
            rightExpr = new Expression(rightExpr);
        }
        Expression ex = (Expression)rightExpr;
        LValue leftExpr = this.getLValue(pos);
        Operator op = this.getOperator(pos);
        ex.insert(leftExpr, op);
        this.addValues.remove(pos);
        this.setLValue(pos, ex);
    }

    private Operator getOperator(int pos) {
        ValueContainer vc = (ValueContainer)this.addValues.get(pos);
        return vc.op;
    }

    private LValue getLValue(int pos) {
        if (pos == 0) {
            return this.value;
        }
        ValueContainer vc = (ValueContainer)this.addValues.get(pos - 1);
        return vc.value;
    }

    private void setLValue(int pos, LValue lval) {
        if (pos == 0) {
            this.value = lval;
            return;
        }
        ValueContainer vc = (ValueContainer)this.addValues.get(pos - 1);
        vc.value = lval;
    }

    public String toString() {
        return this.getName();
    }

    public static void main(String[] args) {
        DriverManager.setLogWriter(new PrintWriter(System.out));
        Expression ex = new Expression(new StaticValue(new Integer(10)));
        ex.add(Operator.ADD, new StaticValue(new Integer(15)));
        ex.add(Operator.MULT, new StaticValue(new Integer(5)));
        ex.add(Operator.SUB, new StaticValue(new Integer(2)));
        ex.add(Operator.DIV, new StaticValue(new Integer(19)));
        System.out.println(ex);
    }

    private class ValueContainer {
        public Operator op;
        public LValue value;

        public ValueContainer(Operator op, LValue value) {
            this.op = op;
            this.value = value;
        }
    }
}

