/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL.sqlparser;

import ORG.as220.tinySQL.sqlparser.ColumnValue;
import ORG.as220.tinySQL.sqlparser.LValue;
import ORG.as220.tinySQL.sqlparser.ParserUtils;
import ORG.as220.tinySQL.sqlparser.SQLStatement;
import ORG.as220.tinySQL.sqlparser.SelectStatement;
import ORG.as220.tinySQL.tinySQL;
import ORG.as220.tinySQL.tinySQLConnection;
import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tinySQLResultSet;
import ORG.as220.tinySQL.tinySQLStatement;
import ORG.as220.tinySQL.tinySQLTableView;
import ORG.as220.tinySQL.tsColumn;
import ORG.as220.tinySQL.tsResultRow;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;

public class InsertStatement
implements SQLStatement {
    private tinySQL db;
    private tinySQLTableView table;
    private int updatecount;
    private Vector columns;
    private Vector tablesCache;
    private Vector values;
    private SelectStatement subselect;

    public InsertStatement(tinySQLStatement statement) throws tinySQLException {
        try {
            tinySQLConnection c = (tinySQLConnection)statement.getConnection();
            this.db = c.getTinySqlHandle();
        }
        catch (SQLException sqle) {
            throw new tinySQLException("Unable to resolve connection", sqle);
        }
        this.columns = new Vector();
        this.values = new Vector();
    }

    public void addColumn(String colname) throws tinySQLException {
        ColumnValue col = new ColumnValue(colname);
        String tablename = col.getTable();
        if (tablename != null && !this.table.getName().equals(tablename)) {
            throw new tinySQLException("The specified table [" + tablename + "] is not defined in this statement");
        }
        String name = col.getColumn();
        tsColumn tablecol = this.table.getColumnDefinition(this.table.findColumn(name));
        this.columns.add(tablecol);
    }

    public void addValues(Vector v) throws tinySQLException {
        if (v.size() != this.columns.size()) {
            throw new tinySQLException("Columns-Size does not match values-size");
        }
        Vector<tsColumn> sourceCols = new Vector<tsColumn>();
        int i = 0;
        while (i < this.columns.size()) {
            tsColumn target_col = (tsColumn)this.columns.elementAt(i);
            tsColumn source_col = new tsColumn(target_col.getPhysicalName(), (LValue)v.elementAt(i));
            source_col.setAll(target_col);
            sourceCols.addElement(source_col);
            ++i;
        }
        tsResultRow expressed = new tsResultRow(sourceCols);
        this.values.add(expressed);
    }

    public void addSelect(SelectStatement select) throws tinySQLException {
        if (select == null) {
            throw new tinySQLException("Empty selection is not allowed");
        }
        this.subselect = select;
    }

    public boolean hasSubSelect() {
        return this.subselect != null;
    }

    public SelectStatement getSelect() {
        return this.subselect;
    }

    public Vector getColumns() {
        return this.columns;
    }

    public Vector getValues() {
        return this.values;
    }

    public tinySQLTableView getTable() {
        return this.table;
    }

    public Enumeration getTables() {
        if (this.tablesCache == null) {
            this.tablesCache = new Vector(1);
            this.tablesCache.add(this.table);
        }
        return this.tablesCache.elements();
    }

    public void setTable(String tablename) throws tinySQLException {
        this.table = this.getDatabase().getTable(tablename);
    }

    public tinySQL getDatabase() throws tinySQLException {
        return this.db;
    }

    public boolean execute() throws tinySQLException {
        if (this.table != null) {
            this.updatecount = this.getDatabase().InsertStatement(this);
        }
        return false;
    }

    public int getUpdateCount() throws tinySQLException {
        return this.updatecount;
    }

    public tinySQLResultSet getResultSet() throws tinySQLException {
        return null;
    }

    public boolean getMoreResults() throws tinySQLException {
        return false;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("INSERT INTO ");
        b.append(this.table);
        if (this.hasSubSelect()) {
            b.append(" ");
            b.append(this.subselect.toString());
        } else {
            b.append(" (");
            Enumeration columns = this.getColumns().elements();
            while (columns.hasMoreElements()) {
                b.append(columns.nextElement());
                if (!columns.hasMoreElements()) continue;
                b.append(", ");
            }
            b.append(") VALUES (");
            Enumeration valenum = this.getValues().elements();
            while (valenum.hasMoreElements()) {
                tsResultRow row = (tsResultRow)valenum.nextElement();
                b.append(" (");
                b.append(row);
                b.append(") ");
                if (!valenum.hasMoreElements()) continue;
                b.append(", \n");
            }
            b.append(") \n");
        }
        return b.toString();
    }

    public Vector getParameters() {
        Vector v = new Vector();
        Enumeration valenum = this.getValues().elements();
        while (valenum.hasMoreElements()) {
            tsResultRow row = (tsResultRow)valenum.nextElement();
            int i = 0;
            while (i < row.size()) {
                tsColumn col = row.getColumnDefinition(i);
                if (col.getColumnType() == 1) {
                    ParserUtils.getParameterElements(v, col.getExpression());
                }
                ++i;
            }
        }
        return v;
    }
}

