/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL.sqlparser;

import ORG.as220.tinySQL.Utils;
import ORG.as220.tinySQL.sqlparser.ColumnValue;
import ORG.as220.tinySQL.sqlparser.LValue;
import ORG.as220.tinySQL.sqlparser.ParameterValue;
import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tinySQLTableView;
import ORG.as220.tinySQL.tsColumn;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Vector;

public class ParserUtils {
    public static void getColumnElements(Vector v, LValue root) {
        if (root.getChildCount() > 0) {
            Enumeration enumeration = root.getChildren();
            while (enumeration.hasMoreElements()) {
                LValue val = (LValue)enumeration.nextElement();
                ParserUtils.getColumnElements(v, val);
            }
        }
        if (root instanceof ColumnValue) {
            v.add(root);
        }
    }

    public static void getParameterElements(Vector v, LValue root) {
        if (root.getChildCount() > 0) {
            Enumeration enumeration = root.getChildren();
            while (enumeration.hasMoreElements()) {
                LValue val = (LValue)enumeration.nextElement();
                ParserUtils.getParameterElements(v, val);
            }
        }
        if (root instanceof ParameterValue) {
            v.add(root);
        }
    }

    public static Vector resolveTableColumns(LValue column, Vector tables) throws tinySQLException {
        Vector<tsColumn> tableColumns = new Vector<tsColumn>();
        Vector checkColumns = new Vector();
        ParserUtils.getColumnElements(checkColumns, column);
        int size = checkColumns.size();
        int i = 0;
        while (i < size) {
            ColumnValue colElement = (ColumnValue)checkColumns.get(i);
            String name = colElement.getColumn();
            String tablename = colElement.getTable();
            tinySQLTableView table = null;
            if (tablename == null) {
                table = ParserUtils.findTableForColumn(tables.elements(), name);
            } else {
                table = ParserUtils.findTable(tablename, tables);
                if (table == null) {
                    throw new tinySQLException("There is no table called " + table);
                }
            }
            tsColumn columnDefinition = new tsColumn(table, name);
            tsColumn tablecoldef = table.getColumnDefinition(table.findColumn(name));
            if (tablecoldef == null) {
                throw new NullPointerException("Table: " + table.getName() + " Column " + name);
            }
            columnDefinition.setAll(tablecoldef);
            if (tableColumns.indexOf(columnDefinition) == -1) {
                tableColumns.add(columnDefinition);
            }
            ++i;
        }
        return tableColumns;
    }

    public static tinySQLTableView findTableForColumn(Enumeration tables, String col_name) throws tinySQLException {
        while (tables.hasMoreElements()) {
            tinySQLTableView tableDecl = (tinySQLTableView)tables.nextElement();
            if (tableDecl.findColumn(col_name) == -1) continue;
            return tableDecl;
        }
        throw new tinySQLException("Column " + col_name + " not found.");
    }

    public static tinySQLTableView findTable(String name, Vector tables) {
        int size = tables.size();
        int i = 0;
        while (i < size) {
            tinySQLTableView vTable = (tinySQLTableView)tables.get(i);
            if (name.equals(vTable.getName()) || name.equals(vTable.getAlias())) {
                return vTable;
            }
            ++i;
        }
        return null;
    }

    public static Vector buildVector(Enumeration enumeration) {
        Vector retval = new Vector();
        while (enumeration.hasMoreElements()) {
            retval.add(enumeration.nextElement());
        }
        return retval;
    }

    public static String convertToString(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Time) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.clear();
            cal.setTime((Date)o);
            int hour = cal.get(11);
            int min = cal.get(12);
            int sec = cal.get(13);
            StringBuffer b = new StringBuffer(10);
            b.append(Utils.forceToSizeLeft(String.valueOf(hour), 2, '0'));
            b.append('-');
            b.append(Utils.forceToSizeLeft(String.valueOf(min), 2, '0'));
            b.append('-');
            b.append(Utils.forceToSizeLeft(String.valueOf(sec), 2, '0'));
            return b.toString();
        }
        if (o instanceof Date) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.clear();
            cal.setTime((Date)o);
            int year = cal.get(1);
            int mon = cal.get(2);
            int day = cal.get(5);
            StringBuffer b = new StringBuffer(10);
            b.append(Utils.forceToSizeLeft(String.valueOf(year), 4, '0'));
            b.append('-');
            b.append(Utils.forceToSizeLeft(String.valueOf(mon + 1), 2, '0'));
            b.append('-');
            b.append(Utils.forceToSizeLeft(String.valueOf(day), 2, '0'));
            return b.toString();
        }
        if (o instanceof java.util.Date) {
            java.util.Date d = (java.util.Date)o;
            GregorianCalendar cal = new GregorianCalendar();
            cal.clear();
            cal.setTime(d);
            int hour = cal.get(11);
            int min = cal.get(12);
            int sec = cal.get(13);
            int year = cal.get(1);
            int mon = cal.get(2);
            int day = cal.get(5);
            StringBuffer b = new StringBuffer(20);
            b.append(Utils.forceToSizeLeft(String.valueOf(year), 4, '0'));
            b.append('-');
            b.append(Utils.forceToSizeLeft(String.valueOf(mon + 1), 2, '0'));
            b.append('-');
            b.append(Utils.forceToSizeLeft(String.valueOf(day), 2, '0'));
            b.append(' ');
            b.append(Utils.forceToSizeLeft(String.valueOf(hour), 2, '0'));
            b.append(':');
            b.append(Utils.forceToSizeLeft(String.valueOf(min), 2, '0'));
            b.append(':');
            b.append(Utils.forceToSizeLeft(String.valueOf(sec), 2, '0'));
            return b.toString();
        }
        if (o instanceof byte[]) {
            return new String((byte[])o);
        }
        if (o instanceof char[]) {
            return new String((char[])o);
        }
        return o.toString();
    }

    public static Boolean convertToBoolean(Object o) {
        String s;
        if (o == null) {
            return null;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String && (s = (String)o).trim().toLowerCase().equals("true")) {
            return Boolean.TRUE;
        }
        if (o.equals(Boolean.TRUE)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static BigDecimal convertToNumber(Object o) {
        if (o == null) {
            return new BigDecimal(0.0);
        }
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        if (o instanceof Number) {
            return new BigDecimal(((Number)o).doubleValue());
        }
        if (o instanceof java.util.Date) {
            return new BigDecimal((double)((java.util.Date)o).getTime());
        }
        String s = ParserUtils.convertToString(o);
        try {
            return new BigDecimal(s.trim());
        }
        catch (Exception exception) {
            return new BigDecimal(0.0);
        }
    }

    public static Date convertToDate(Object o) {
        if (o == null) {
            return new Date(0L);
        }
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof Number) {
            return new Date(((Number)o).longValue());
        }
        if (o instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)o;
            return new Date(date.getTime());
        }
        if (o instanceof String) {
            try {
                String s = (String)o;
                if (s.length() == 10) {
                    int y = ParserUtils.toNumber(s.charAt(0)) * 1000 + ParserUtils.toNumber(s.charAt(1)) * 100 + ParserUtils.toNumber(s.charAt(2)) * 10 + ParserUtils.toNumber(s.charAt(3));
                    int m = ParserUtils.toNumber(s.charAt(5)) * 10 + ParserUtils.toNumber(s.charAt(6));
                    int d = ParserUtils.toNumber(s.charAt(8)) * 10 + ParserUtils.toNumber(s.charAt(9));
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.clear();
                    cal.set(y, m, d);
                    return new Date(cal.getTime().getTime());
                }
                return Date.valueOf(s);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        throw new ClassCastException(o.getClass().getName());
    }

    private static int toNumber(char b) {
        return b - 48;
    }

    public static Time convertToTime(Object o) {
        if (o == null) {
            return new Time(0L);
        }
        if (o instanceof Time) {
            return (Time)o;
        }
        if (o instanceof Number) {
            return new Time(((Number)o).longValue());
        }
        if (o instanceof java.util.Date) {
            return new Time(((java.util.Date)o).getTime());
        }
        if (o instanceof String) {
            String s = (String)o;
            if (s.length() != 8) {
                try {
                    return Time.valueOf(s);
                }
                catch (Exception e) {
                }
            } else {
                int h = ParserUtils.toNumber(s.charAt(0)) * 10 + ParserUtils.toNumber(s.charAt(1));
                int m = ParserUtils.toNumber(s.charAt(3)) * 10 + ParserUtils.toNumber(s.charAt(4));
                int se = ParserUtils.toNumber(s.charAt(6)) * 10 + ParserUtils.toNumber(s.charAt(7));
                GregorianCalendar cal = new GregorianCalendar();
                cal.clear();
                cal.set(0, 0, 0, h, m, se);
                return new Time(cal.getTime().getTime());
            }
        }
        return null;
    }

    public static Timestamp convertToTimestamp(Object o) {
        if (o == null) {
            return new Timestamp(0L);
        }
        System.out.println(o.getClass());
        if (o instanceof Timestamp) {
            return (Timestamp)o;
        }
        if (o instanceof Number) {
            return new Timestamp(((Number)o).longValue());
        }
        if (o instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)o).getTime());
        }
        if (o instanceof String) {
            try {
                return Timestamp.valueOf((String)o);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String typeToLiteral(int type) {
        if (type == 1) {
            return "CHAR";
        }
        if (type == 2) {
            return "NUMERIC";
        }
        if (type == -7) {
            return "BIT";
        }
        if (type == 4) {
            return "INTEGER";
        }
        if (type == -2) {
            return "BINARY";
        }
        if (type == 91) {
            return "DATE";
        }
        if (type == 92) {
            return "TIME";
        }
        if (type == 93) {
            return "TIMESTAMP";
        }
        return "BINARY";
    }
}

