/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL.sqlparser;

import ORG.as220.tinySQL.sqlparser.SQLStatement;
import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tinySQLStatement;
import java.sql.BatchUpdateException;
import java.util.Vector;

public class SQLStatementBatch {
    private Vector statements = new Vector();
    private tinySQLStatement parent;

    public SQLStatementBatch(tinySQLStatement parent) {
        this.parent = parent;
    }

    public tinySQLStatement getParent() {
        return this.parent;
    }

    public void add(SQLStatement statement) {
        this.statements.addElement(statement);
    }

    public void clear() {
        this.statements.clear();
    }

    public int[] executeAll() throws tinySQLException, BatchUpdateException {
        int size = this.statements.size();
        int[] results = new int[size];
        int i = 0;
        while (i < size) {
            SQLStatement stmt = (SQLStatement)this.statements.elementAt(i);
            if (stmt.execute()) {
                throw new BatchUpdateException("Statement tries to return ResultSet", results);
            }
            results[i] = stmt.getUpdateCount();
            ++i;
        }
        return results;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        int size = this.statements.size();
        int i = 0;
        while (i < size) {
            SQLStatement stmt = (SQLStatement)this.statements.elementAt(i);
            b.append("Statement: ");
            b.append(stmt.toString());
            b.append("\n");
            ++i;
        }
        return b.toString();
    }
}

