/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL.sqlparser;

import ORG.as220.tinySQL.sqlparser.ColumnValue;
import ORG.as220.tinySQL.sqlparser.ConditionalStatement;
import ORG.as220.tinySQL.sqlparser.JokerColumnValue;
import ORG.as220.tinySQL.sqlparser.LValue;
import ORG.as220.tinySQL.sqlparser.OrderByClause;
import ORG.as220.tinySQL.sqlparser.ParameterValue;
import ORG.as220.tinySQL.sqlparser.ParserUtils;
import ORG.as220.tinySQL.sqlparser.WhereClause;
import ORG.as220.tinySQL.tinySQL;
import ORG.as220.tinySQL.tinySQLConnection;
import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tinySQLResultSet;
import ORG.as220.tinySQL.tinySQLStatement;
import ORG.as220.tinySQL.tinySQLTableView;
import ORG.as220.tinySQL.tsColumn;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;

public class SelectStatement
implements ConditionalStatement {
    public static final int MOD_NONE = 0;
    public static final int MOD_ALL = 1;
    public static final int MOD_DISTINCT = 2;
    private WhereClause whereC;
    private OrderByClause orderC;
    private Vector resultColumns;
    private Vector tableColumns;
    private Vector tables;
    private tinySQLStatement statement;
    private tinySQLResultSet myResult;
    private int mod = 0;

    public SelectStatement(tinySQLStatement statement) {
        this.statement = statement;
        this.resultColumns = new Vector();
        this.tableColumns = new Vector();
        this.tables = new Vector();
        this.whereC = new WhereClause(this);
        this.orderC = new OrderByClause(this);
    }

    public void addTable(String tablename, String alias) throws tinySQLException {
        tinySQLTableView dbtable = this.getDatabase().getTable(tablename);
        dbtable.setAlias(alias);
        this.tables.add(dbtable);
    }

    public void addColumn(LValue column, String alias) throws tinySQLException {
        if (column instanceof JokerColumnValue) {
            this.resolveJokers((JokerColumnValue)column);
            return;
        }
        tinySQL db = this.getDatabase();
        this.tableColumns.addAll(ParserUtils.resolveTableColumns(column, this.tables));
        if (column instanceof ColumnValue) {
            ColumnValue colVal = (ColumnValue)column;
            tinySQLTableView table = null;
            String tablename = colVal.getTable();
            table = tablename == null ? ParserUtils.findTableForColumn(this.tables.elements(), colVal.getColumn()) : ParserUtils.findTable(colVal.getTable(), this.tables);
            tsColumn columnDefinition = new tsColumn(table, colVal.getColumn(), alias);
            columnDefinition.setAll(table.getColumnDefinition(table.findColumn(colVal.getColumn())));
            this.resultColumns.add(columnDefinition);
        } else {
            tsColumn columnDefinition = new tsColumn(alias, column);
            this.resultColumns.add(columnDefinition);
        }
    }

    private void resolveJokers(JokerColumnValue column) throws tinySQLException {
        String tablename = column.getTable();
        if (tablename == null) {
            Enumeration tables = this.getTables();
            while (tables.hasMoreElements()) {
                tinySQLTableView table = (tinySQLTableView)tables.nextElement();
                this.addAllTableColumns(table);
            }
        } else {
            tinySQLTableView table = ParserUtils.findTable(tablename, this.tables);
            if (table == null) {
                throw new tinySQLException("There is no such table: " + tablename);
            }
            this.addAllTableColumns(table);
        }
    }

    private void addAllTableColumns(tinySQLTableView table) {
        int size = table.getColumnCount();
        int i = 0;
        while (i < size) {
            tsColumn coldef = table.getColumnDefinition(i);
            this.tableColumns.add(coldef);
            this.resultColumns.add(coldef);
            ++i;
        }
    }

    public int getModifier() {
        return this.mod;
    }

    public void setModifier(int mod) {
        if (mod != 0 && mod != 1 && mod != 2) {
            throw new IllegalArgumentException("Not a valid modification");
        }
        this.mod = mod;
    }

    public Enumeration getTables() {
        return this.tables.elements();
    }

    public Vector getTableColumns() {
        Vector v = new Vector(this.tableColumns);
        v.addAll(this.whereC.getColumns());
        v.addAll(this.orderC.getColumns());
        return v;
    }

    public Vector getResultColumns() {
        return new Vector(this.resultColumns);
    }

    public void setWhereClause(WhereClause c) throws tinySQLException {
        if (c == null) {
            throw new NullPointerException();
        }
        this.whereC = c;
    }

    public WhereClause getWhereClause() {
        return this.whereC;
    }

    public void setOrderByClause(OrderByClause c) throws tinySQLException {
        if (c == null) {
            throw new NullPointerException();
        }
        this.orderC = c;
    }

    public OrderByClause getOrderByClause() {
        return this.orderC;
    }

    public tinySQL getDatabase() throws tinySQLException {
        try {
            tinySQLConnection c = (tinySQLConnection)this.statement.getConnection();
            return c.getTinySqlHandle();
        }
        catch (SQLException sqle) {
            throw new tinySQLException("Unable to resolve connection", sqle);
        }
    }

    public tinySQLStatement getStatement() {
        return this.statement;
    }

    public boolean execute() throws tinySQLException {
        tinySQL database = this.getDatabase();
        Vector v = this.getParameters();
        int i = 0;
        while (i < v.size()) {
            ParameterValue pv = (ParameterValue)v.get(i);
            if (pv.isEmpty()) {
                throw new tinySQLException("Parameter " + i + " is not yet set");
            }
            ++i;
        }
        this.myResult = new tinySQLResultSet(database.SelectStatement(this), this.getStatement());
        return true;
    }

    public int getUpdateCount() {
        return -1;
    }

    public tinySQLResultSet getResultSet() {
        tinySQLResultSet retval = this.myResult;
        this.myResult = null;
        return retval;
    }

    public boolean getMoreResults() {
        return false;
    }

    public Vector getParameters() {
        Vector v = new Vector();
        Enumeration valenum = this.getResultColumns().elements();
        while (valenum.hasMoreElements()) {
            tsColumn col = (tsColumn)valenum.nextElement();
            if (col.getColumnType() != 1) continue;
            LValue colVal = col.getExpression();
            ParserUtils.getParameterElements(v, colVal);
        }
        v.addAll(this.whereC.getParameters());
        return v;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("SELECT ");
        if (this.getModifier() == 1) {
            b.append("ALL ");
        } else if (this.getModifier() == 2) {
            b.append("DISTINCT ");
        }
        b.append("<!-- TABLECOLUMNS: USED TABLES FOR ALL EXPRESSIONS IN THIS QUERY \n");
        Enumeration enumeration = this.getTableColumns().elements();
        while (enumeration.hasMoreElements()) {
            b.append(enumeration.nextElement());
            if (!enumeration.hasMoreElements()) continue;
            b.append(", \n");
        }
        b.append("\n --> \n");
        b.append("<!-- RESULTCOLUMNS: COLUMNS WHICH WILL BE DISPLAYED \n");
        enumeration = this.getResultColumns().elements();
        while (enumeration.hasMoreElements()) {
            b.append(enumeration.nextElement());
            if (!enumeration.hasMoreElements()) continue;
            b.append(", \n");
        }
        b.append("\n --> \n");
        enumeration = this.getTables();
        if (enumeration.hasMoreElements()) {
            b.append(" FROM ");
        }
        while (enumeration.hasMoreElements()) {
            b.append(enumeration.nextElement());
            if (!enumeration.hasMoreElements()) continue;
            b.append(", ");
        }
        b.append(" " + this.whereC.toString());
        return b.toString();
    }
}

