/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL.sqlparser;

import ORG.as220.tinySQL.sqlparser.ColumnValue;
import ORG.as220.tinySQL.sqlparser.ConditionalStatement;
import ORG.as220.tinySQL.sqlparser.LValue;
import ORG.as220.tinySQL.sqlparser.ParameterValue;
import ORG.as220.tinySQL.sqlparser.ParserUtils;
import ORG.as220.tinySQL.sqlparser.WhereClause;
import ORG.as220.tinySQL.tinySQL;
import ORG.as220.tinySQL.tinySQLConnection;
import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tinySQLResultSet;
import ORG.as220.tinySQL.tinySQLStatement;
import ORG.as220.tinySQL.tinySQLTableView;
import ORG.as220.tinySQL.tsColumn;
import ORG.as220.tinySQL.tsResultRow;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;

public class UpdateStatement
implements ConditionalStatement {
    private tinySQL db;
    private WhereClause whereC;
    private tinySQLTableView table;
    private Vector columns;
    private tsResultRow values;
    private int updateCount;

    public UpdateStatement(tinySQLStatement statement) throws tinySQLException {
        try {
            tinySQLConnection c = (tinySQLConnection)statement.getConnection();
            this.db = c.getTinySqlHandle();
            this.whereC = new WhereClause(this);
        }
        catch (SQLException sqle) {
            throw new tinySQLException("Unable to resolve connection", sqle);
        }
        this.columns = new Vector();
    }

    public void addColumn(String colname) throws tinySQLException {
        ColumnValue col = new ColumnValue(colname);
        String tablename = col.getTable();
        if (tablename != null && !this.table.getName().equals(tablename)) {
            throw new tinySQLException("The specified table [" + tablename + "] is not defined in this statement");
        }
        String name = col.getColumn();
        tsColumn tablecol = this.table.getColumnDefinition(this.table.findColumn(name));
        this.columns.add(tablecol);
    }

    public Vector getColumns() {
        Vector v = new Vector(this.columns);
        v.addAll(this.whereC.getColumns());
        return v;
    }

    public void setValues(Vector v) throws tinySQLException {
        if (v.size() != this.columns.size()) {
            throw new tinySQLException("Columns-Size does not match values-size");
        }
        Vector<tsColumn> sourceCols = new Vector<tsColumn>();
        int i = 0;
        while (i < this.columns.size()) {
            tsColumn target_col = (tsColumn)this.columns.get(i);
            tsColumn source_col = new tsColumn(target_col.getPhysicalName(), (LValue)v.get(i));
            source_col.setAll(target_col);
            sourceCols.add(source_col);
            ++i;
        }
        this.values = new tsResultRow(sourceCols);
    }

    public tsResultRow getValues() {
        return this.values;
    }

    public tinySQLTableView getTable() {
        return this.table;
    }

    public Enumeration getTables() {
        Vector<tinySQLTableView> v = new Vector<tinySQLTableView>();
        v.add(this.table);
        return v.elements();
    }

    public void setTable(String tablename) throws tinySQLException {
        this.table = this.getDatabase().getTable(tablename);
    }

    public void setWhereClause(WhereClause c) throws tinySQLException {
        if (c == null) {
            throw new NullPointerException();
        }
        this.whereC = c;
    }

    public WhereClause getWhereClause() {
        return this.whereC;
    }

    public tinySQL getDatabase() throws tinySQLException {
        return this.db;
    }

    public boolean execute() throws tinySQLException {
        Vector v = this.getParameters();
        int i = 0;
        while (i < v.size()) {
            ParameterValue pv = (ParameterValue)v.get(i);
            if (pv.isEmpty()) {
                throw new tinySQLException("Parameter " + i + " is not yet set");
            }
            ++i;
        }
        if (this.table != null) {
            this.updateCount = this.getDatabase().UpdateStatement(this);
        }
        return false;
    }

    public int getUpdateCount() throws tinySQLException {
        return this.updateCount;
    }

    public tinySQLResultSet getResultSet() throws tinySQLException {
        return null;
    }

    public boolean getMoreResults() throws tinySQLException {
        return false;
    }

    public Vector getParameters() {
        Vector v = new Vector();
        tsResultRow row = this.getValues();
        int i = 0;
        while (i < row.size()) {
            tsColumn col = row.getColumnDefinition(i);
            if (col.getColumnType() == 1) {
                ParserUtils.getParameterElements(v, col.getExpression());
            }
            ++i;
        }
        v.addAll(this.whereC.getParameters());
        return v;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("UPDATE ");
        b.append(this.table);
        b.append(" SET ");
        tsResultRow row = this.getValues();
        int i = 0;
        while (i < row.size()) {
            if (i != 0) {
                b.append(", ");
            }
            tsColumn col = row.getColumnDefinition(i);
            b.append(col);
            b.append(" = ");
            try {
                b.append(row.get(i));
            }
            catch (Exception e) {
                b.append("<!EXCEPTION>");
            }
            ++i;
        }
        b.append("");
        return b.toString();
    }
}

