/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL.sqlparser;

import ORG.as220.tinySQL.sqlparser.ConditionalStatement;
import ORG.as220.tinySQL.sqlparser.LValue;
import ORG.as220.tinySQL.sqlparser.ParserUtils;
import ORG.as220.tinySQL.sqlparser.StaticValue;
import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tsColumn;
import ORG.as220.tinySQL.tsRow;
import java.util.Vector;

public class WhereClause {
    private LValue expression = new StaticValue(Boolean.TRUE);
    private Vector tableColumns = new Vector();
    private ConditionalStatement parent;
    private boolean lastReturnValue;
    private boolean evaluatedOnce;
    private Object[] cache;
    private int[] cachePos;

    public WhereClause(ConditionalStatement parent) {
        this.parent = parent;
    }

    public void setExpression(LValue ex) throws tinySQLException {
        if (ex == null) {
            throw new NullPointerException();
        }
        Vector cols = ParserUtils.resolveTableColumns(ex, ParserUtils.buildVector(this.parent.getTables()));
        this.tableColumns = new Vector(cols);
        this.expression = ex;
        this.cache = null;
    }

    public LValue getExpression() {
        return this.expression;
    }

    public boolean isMatch(tsRow matchRow) throws tinySQLException {
        boolean reevaluate = false;
        if (this.tableColumns.size() > 0) {
            int size;
            if (this.cache == null) {
                this.cache = new Object[this.tableColumns.size()];
                this.cachePos = new int[this.tableColumns.size()];
                size = this.cache.length;
                int i = 0;
                while (i < size) {
                    int idx;
                    tsColumn col = (tsColumn)this.tableColumns.elementAt(i);
                    this.cachePos[i] = idx = matchRow.findColumn(col.getPhysicalName());
                    this.cache[i] = matchRow.get(idx);
                    ++i;
                }
                reevaluate = true;
            } else {
                size = this.cache.length;
                int i = 0;
                while (i < size) {
                    int idx = this.cachePos[i];
                    Object myObject = this.cache[i];
                    Object rowObject = matchRow.get(i);
                    if (rowObject != null) {
                        if (myObject != null) {
                            if (rowObject != myObject && !rowObject.equals(myObject)) {
                                this.cache[i] = rowObject;
                                reevaluate = true;
                            }
                        } else {
                            this.cache[i] = rowObject;
                            reevaluate = true;
                        }
                    }
                    ++i;
                }
            }
        } else if (!this.evaluatedOnce) {
            reevaluate = true;
        }
        if (reevaluate) {
            this.evaluatedOnce = true;
            Boolean b = ParserUtils.convertToBoolean(this.expression.evaluate(matchRow));
            this.lastReturnValue = b;
        }
        return this.lastReturnValue;
    }

    public String toString() {
        return "WHERE " + this.expression.getName();
    }

    public Vector getColumns() {
        return new Vector(this.tableColumns);
    }

    public Vector getParameters() {
        Vector v = new Vector();
        ParserUtils.getParameterElements(v, this.getExpression());
        return v;
    }
}

