/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL;

import ORG.as220.tinySQL.Utils;
import ORG.as220.tinySQL.sqlparser.ColumnDefinition;
import ORG.as220.tinySQL.sqlparser.CreateTableStatement;
import ORG.as220.tinySQL.textFileQuoting;
import ORG.as220.tinySQL.textFileTable;
import ORG.as220.tinySQL.tinySQL;
import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tinySQLTable;
import ORG.as220.tinySQL.tsColumn;
import ORG.as220.tinySQL.util.Log;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class textFile
extends tinySQL {
    public static final int DELETE_DEFAULT = -1;
    public static final int DELETE_NONE = 1;
    public static final int DELETE_PACK = 2;
    public static final int INSERT_DEFAULT = 0;
    public static final int INSERT_SIZE = 1;
    public static final int INSERT_SPEED = 2;
    private String dataDir;
    private Hashtable tables;
    private String encoding;
    private boolean readOnly;
    private Properties p;
    private byte[] delpref;
    private byte[] delpost;
    private byte[] colpref;
    private byte[] colpost;
    private byte[] rowpref;
    private byte[] rowpost;
    private byte[] tablepref;
    private byte[] tablepost;
    private String defext;
    private String tableext;
    private String quoting;
    private textFileQuoting quotingEngine;
    private int deleteMode;
    private int insertMode;
    private boolean ignoreLastColumnPostfix;
    private boolean ignoreFirstColumnPrefix;
    static /* synthetic */ Class class$ORG$as220$tinySQL$textFileQuoting;

    public textFile(String datadir, Properties p) throws tinySQLException {
        this.dataDir = datadir;
        this.setProperties(p);
    }

    public void setProperties(Properties p) throws tinySQLException {
        this.p = p;
        this.encoding = p.getProperty("encoding", "Cp1252");
        this.readOnly = p.getProperty("readonly", "false").equalsIgnoreCase("true");
        this.defext = p.getProperty("definition-extension", ".def");
        this.tableext = p.getProperty("table-extension", "");
        this.quoting = p.getProperty("qouting.engine", (class$ORG$as220$tinySQL$textFileQuoting == null ? (class$ORG$as220$tinySQL$textFileQuoting = textFile.class$("ORG.as220.tinySQL.textFileQuoting")) : class$ORG$as220$tinySQL$textFileQuoting).getName());
        this.quotingEngine = this.loadTextFileQuoting(this.quoting);
        String delpref = p.getProperty("delete.prefix", "");
        String delpost = p.getProperty("delete.postfix", "");
        String colpref = p.getProperty("column.prefix", "");
        String colpost = p.getProperty("column.postfix", "");
        String rowpref = p.getProperty("row.prefix", "");
        String rowpost = p.getProperty("row.postfix", "\n");
        String tablepref = p.getProperty("table.prefix", "");
        String tablepost = p.getProperty("table.postfix", "");
        String deleteMode = p.getProperty("config.delete", "default").trim();
        String insertMode = p.getProperty("config.insert", "default").trim();
        String ignoreFirstColumnPrefix = p.getProperty("ignore.first.column.prefix", "false");
        String ignoreLastColumnPostfix = p.getProperty("ignore.first.column.postfix", "false");
        this.ignoreFirstColumnPrefix = ignoreFirstColumnPrefix.trim().equalsIgnoreCase("true");
        this.ignoreLastColumnPostfix = ignoreLastColumnPostfix.trim().equalsIgnoreCase("true");
        this.deleteMode = deleteMode.equals("none") ? 1 : (deleteMode.equals("pack") ? 2 : -1);
        this.insertMode = insertMode.equals("speed") ? 2 : (insertMode.equals("size") ? 1 : 0);
        try {
            this.delpref = delpref.getBytes(this.encoding);
            this.delpost = delpost.getBytes(this.encoding);
            this.colpref = colpref.getBytes(this.encoding);
            this.colpost = colpost.getBytes(this.encoding);
            this.rowpref = rowpref.getBytes(this.encoding);
            this.rowpost = rowpost.getBytes(this.encoding);
            this.tablepref = tablepref.getBytes(this.encoding);
            this.tablepost = tablepost.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException use) {
            throw new tinySQLException(use);
        }
    }

    private textFileQuoting loadTextFileQuoting(String classname) throws tinySQLException {
        try {
            Class<?> c = Class.forName(classname);
            textFileQuoting o = (textFileQuoting)c.newInstance();
            o.setDatabase(this);
            o.init();
            return o;
        }
        catch (Exception e) {
            throw new tinySQLException("QuotingEngine not found: " + classname);
        }
    }

    public Properties getProperties() {
        return this.p;
    }

    public textFileQuoting getQuoting() {
        return this.quotingEngine;
    }

    public boolean isIgnoringFirstColumnPrefix() {
        return this.ignoreFirstColumnPrefix;
    }

    public boolean isIgnoringLastColumnPostfix() {
        return this.ignoreLastColumnPostfix;
    }

    public int getDeleteMode() {
        Log.debug("Default DeleteMode : " + this.deleteMode);
        return this.deleteMode;
    }

    public int getInsertMode() {
        return this.insertMode;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean CreateTable(CreateTableStatement stmt) throws tinySQLException {
        if (this.isReadOnly()) {
            throw new tinySQLException("Database is readonly");
        }
        try {
            String table_name = stmt.getTable();
            Vector coldefs = stmt.getColumnDefinitions();
            int numCols = coldefs.size();
            boolean recordLength = true;
            Vector<tsColumn> v = new Vector<tsColumn>();
            int i = 0;
            while (i < numCols) {
                ColumnDefinition coldef = (ColumnDefinition)coldefs.elementAt(i);
                tsColumn col = coldef.getColumn();
                v.add(col);
                ++i;
            }
            this.mkDataDirectory();
            this.db_createTable(table_name, v);
        }
        catch (IOException ioe) {
            throw new tinySQLException("Create Table failed", ioe);
        }
        return false;
    }

    public String getTableExtension() {
        return this.tableext;
    }

    public String getDefinitionExtension() {
        return this.defext;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public byte[] getDelPostfix() {
        return this.delpost;
    }

    public byte[] getDelPrefix() {
        return this.delpref;
    }

    public byte[] getColumnPostfix() {
        return this.colpost;
    }

    public byte[] getColumnPrefix() {
        return this.colpref;
    }

    public byte[] getRowPostfix() {
        return this.rowpost;
    }

    public byte[] getRowPrefix() {
        return this.rowpref;
    }

    public byte[] getTablePostfix() {
        return this.tablepost;
    }

    public byte[] getTablePrefix() {
        return this.tablepref;
    }

    protected void db_removeTable(String table_name) throws IOException {
        Utils.delFile(this.dataDir + File.separator + table_name + this.getTableExtension());
        Utils.delFile(this.dataDir + File.separator + table_name + this.getDefinitionExtension());
    }

    protected void db_renameTable(String table_name, String newname) throws IOException {
        String source = this.dataDir + File.separator + table_name;
        String dest = this.dataDir + File.separator + newname;
        if (!Utils.renameFile(source + this.getTableExtension(), dest + this.getTableExtension()) || !Utils.renameFile(source + this.getDefinitionExtension(), dest + this.getDefinitionExtension())) {
            throw new IOException("Renaming of table " + table_name + " to " + newname + " failed");
        }
    }

    protected void db_createTable(String table_name, Vector v) throws IOException, tinySQLException {
        BufferedOutputStream fdef = new BufferedOutputStream(new FileOutputStream(this.dataDir + File.separator + table_name + this.getDefinitionExtension()));
        DataOutputStream def = new DataOutputStream(fdef);
        if (this.deleteMode == -1) {
            def.writeBytes("CHAR|_DELETED|1\n");
        }
        int i = 0;
        while (i < v.size()) {
            String stype;
            tsColumn col = (tsColumn)v.elementAt(i);
            int type = col.getType();
            switch (type) {
                case 4: {
                    stype = "NUMERIC";
                    col.setSize(10, 0);
                    break;
                }
                case 2: {
                    stype = "NUMERIC";
                    break;
                }
                case 1: {
                    stype = "CHAR";
                    break;
                }
                case 91: {
                    stype = "DATE";
                    col.setSize(10, 0);
                    break;
                }
                default: {
                    throw new tinySQLException("Unsupported text file type: " + type);
                }
            }
            def.writeBytes(stype + "|");
            def.writeBytes(col.getPhysicalName() + "|");
            def.writeBytes(col.getSize() + "\n");
            ++i;
        }
        def.flush();
        fdef.close();
        fdef = new BufferedOutputStream(new FileOutputStream(this.dataDir + File.separator + table_name + this.getTableExtension()));
        fdef.write(this.getTablePrefix());
        fdef.write(this.getTablePostfix());
        fdef.close();
    }

    public tinySQLTable openTable(String table_name) throws tinySQLException {
        Log.debug("TextFile-Engine: Opening table " + table_name);
        return new textFileTable(this.dataDir, table_name, this);
    }

    private void mkDataDirectory() throws NullPointerException {
        File dd = new File(this.dataDir);
        if (!dd.exists()) {
            dd.mkdir();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

