/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL;

import ORG.as220.tinySQL.textFileQuoting;
import ORG.as220.tinySQL.tinySQLException;

public class textFileCSVQuoting
extends textFileQuoting {
    private String separator;

    public void init() {
        this.separator = this.getDatabase().getProperties().getProperty("quoting.csv.separator", ",");
    }

    public String doQuoting(String jdbcString, int collength) throws tinySQLException {
        if (jdbcString.length() > collength) {
            throw new tinySQLException("Quoting limit exceeded for native string");
        }
        boolean quoting = this.isQuotingNeeded(jdbcString);
        if (quoting) {
            StringBuffer retval = new StringBuffer();
            retval.append("\"");
            this.applyQuote(retval, jdbcString);
            retval.append("\"");
            if (retval.length() > collength) {
                throw new tinySQLException("Quoting limit exceeded for quoted string");
            }
            return retval.toString();
        }
        return jdbcString;
    }

    public String undoQuoting(String nativeString) throws tinySQLException {
        boolean quoting = this.isQuotingNeeded(nativeString);
        if (quoting) {
            int start;
            StringBuffer b = new StringBuffer(nativeString.length());
            int length = nativeString.length() - 1;
            int pos = start = 1;
            while (pos != -1) {
                pos = nativeString.indexOf(92, start);
                if (pos == -1) {
                    b.append(nativeString.substring(start, length));
                    continue;
                }
                b.append(nativeString.substring(start, pos));
                if (pos + 1 == length) {
                    pos = -1;
                    continue;
                }
                char nextChar = nativeString.charAt(pos + 1);
                b.append(nextChar);
                start = pos + 2;
            }
            return b.toString();
        }
        return nativeString;
    }

    private boolean isQuotingNeeded(String str) {
        if (str.indexOf(this.separator) != -1) {
            return true;
        }
        if (str.indexOf(10) != -1) {
            return true;
        }
        return str.indexOf(34, 1) != -1;
    }

    private void applyQuote(StringBuffer b, String jdbcString) {
        int length = jdbcString.length();
        int i = 0;
        while (i < length) {
            char c = jdbcString.charAt(i);
            if (c == '\"') {
                b.append("\\\"");
            } else if (c == '\\') {
                b.append("\\\\");
            } else {
                b.append(c);
            }
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        textFileCSVQuoting quoting = new textFileCSVQuoting();
        quoting.separator = ",";
        quoting.doTest("\"Scary, isn't it?\", she said.");
        quoting.doTest("Not really!");
        quoting.doTest("It won't work, but who cares?");
        quoting.doTest("Not really! \" yo\" ");
    }

    private void doTest(String test) throws Exception {
        String quoted = this.doQuoting(test, 100);
        String back = this.undoQuoting(quoted);
        System.out.println("Test : " + test);
        System.out.println("Quot : " + quoted);
        System.out.println("UnQu : " + back);
    }
}

