/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL;

import ORG.as220.tinySQL.Utils;
import ORG.as220.tinySQL.textFileQuoting;
import ORG.as220.tinySQL.tinySQLConverter;
import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tsColumn;
import ORG.as220.tinySQL.util.Log;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.GregorianCalendar;

public class textFileConverter
extends tinySQLConverter {
    private String encoding;
    private DecimalFormat numberFormat;
    private textFileQuoting quoting;

    public textFileConverter(String encoding, textFileQuoting quoting) throws UnsupportedEncodingException {
        new String("").getBytes(encoding);
        this.encoding = encoding;
        if (quoting == null) {
            throw new NullPointerException("Quoting is null");
        }
        this.quoting = quoting;
        DecimalFormatSymbols syms = new DecimalFormatSymbols();
        syms.setDecimalSeparator('.');
        this.numberFormat = new DecimalFormat();
        this.numberFormat.setGroupingSize(0);
        this.numberFormat.setDecimalFormatSymbols(syms);
    }

    public Object convertBooleanToNative(tsColumn coldef, Boolean b) throws tinySQLException {
        try {
            if (b.booleanValue()) {
                return Utils.forceToSize("T", 1, (byte)0, this.encoding);
            }
            return Utils.forceToSize("F", 1, (byte)0, this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new tinySQLException("Encoding not supported");
        }
    }

    public Object convertDateToNative(tsColumn coldef, Date d) throws tinySQLException {
        try {
            GregorianCalendar cal = new GregorianCalendar();
            cal.clear();
            cal.setTime(d);
            int year = cal.get(1);
            int mon = cal.get(2);
            int day = cal.get(5);
            Log.debug("Converting. DATE: " + d);
            StringBuffer b = new StringBuffer(10);
            b.append(Utils.forceToSizeLeft(String.valueOf(year), 4, '0'));
            b.append('-');
            b.append(Utils.forceToSizeLeft(String.valueOf(mon), 2, '0'));
            b.append('-');
            b.append(Utils.forceToSizeLeft(String.valueOf(day), 2, '0'));
            System.out.println("Quoting: " + this.quoting);
            return this.quoting.doQuoting(b.toString(), coldef.getSize()).getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new tinySQLException("Encoding not supported");
        }
    }

    public Object convertTimeToNative(tsColumn coldef, Time t) throws tinySQLException {
        throw new tinySQLException("Conversion not supported");
    }

    public Object convertNullToNative(tsColumn coldef) throws tinySQLException {
        try {
            if (coldef.isNullable()) {
                return Utils.forceToSize("", coldef.getSize(), (byte)0, this.encoding);
            }
            return Utils.forceToSize("", coldef.getSize(), (byte)32, this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new tinySQLException("Encoding not supported");
        }
    }

    public Object convertNumberToNative(tsColumn col, Number n) throws tinySQLException {
        int size = col.getSize();
        int dec = col.getDecimalPlaces();
        String s = null;
        DecimalFormat decimalFormat = this.numberFormat;
        synchronized (decimalFormat) {
            if (col.getType() == 2 || col.getType() == 3) {
                this.numberFormat.setMaximumIntegerDigits(size - dec);
                this.numberFormat.setMinimumIntegerDigits(dec);
                this.numberFormat.setMaximumFractionDigits(dec);
                this.numberFormat.setMinimumFractionDigits(dec);
                s = this.numberFormat.format(n);
            } else if (col.getType() == -5 || col.getType() == 4 || col.getType() == 5 || col.getType() == -6) {
                this.numberFormat.setMaximumIntegerDigits(size);
                this.numberFormat.setMinimumIntegerDigits(0);
                this.numberFormat.setMaximumFractionDigits(0);
                this.numberFormat.setMinimumFractionDigits(0);
                s = this.numberFormat.format(n);
            } else if (col.getType() == 7 || col.getType() == 6 || col.getType() == 8) {
                this.numberFormat.setMaximumIntegerDigits(size);
                this.numberFormat.setMinimumIntegerDigits(0);
                this.numberFormat.setMaximumFractionDigits(size);
                this.numberFormat.setMinimumFractionDigits(0);
                s = this.numberFormat.format(n);
            }
        }
        if (s == null) {
            Object o = super.convertNumberToNative(col, n);
            s = o == null ? "" : o.toString();
        }
        String s2 = this.leftPadString(s, size);
        try {
            return Utils.forceToSize(this.quoting.doQuoting(s2, size), size, (byte)32, this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new tinySQLException("Encoding not supported");
        }
    }

    private String leftPadString(String s, int size) throws tinySQLException {
        int pad = size - s.length();
        if (pad > 0) {
            StringBuffer b = new StringBuffer(pad);
            int i = 0;
            while (i < pad) {
                b.append(' ');
                ++i;
            }
            b.append(s);
            b.toString();
        }
        return s;
    }

    public Object convertStringToNative(tsColumn col, String s) throws tinySQLException {
        try {
            int size = col.getSize();
            return Utils.forceToSize(this.quoting.doQuoting(s, size), size, (byte)32, this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new tinySQLException("Encoding not supported");
        }
    }

    public Object convertNativeToNull(tsColumn col) throws tinySQLException {
        return null;
    }

    public Boolean convertNativeToBoolean(tsColumn coldef, Object o) throws tinySQLException {
        if (o instanceof byte[]) {
            byte[] b = (byte[])o;
            if (b.length == 1 && (b[0] == 84 || b[0] == 116 || b[0] == 89 || b[0] == 121)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return super.convertNativeToBoolean(coldef, o);
    }

    public Date convertNativeToDate(tsColumn coldef, Object o) throws tinySQLException {
        byte[] b;
        if (o instanceof byte[] && (b = (byte[])o).length == 10) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.clear();
            int y = this.toNumber(b[0]) * 1000 + this.toNumber(b[1]) * 100 + this.toNumber(b[2]) * 10 + this.toNumber(b[3]);
            int m = this.toNumber(b[5]) * 10 + this.toNumber(b[6]);
            int d = this.toNumber(b[8]) * 10 + this.toNumber(b[9]);
            cal.set(y, m, d);
            return new Date(cal.getTime().getTime());
        }
        return super.convertNativeToDate(coldef, o);
    }

    private int toNumber(byte b) {
        return b - 48;
    }

    public Time convertNativeToTime(tsColumn coldef, Object o) throws tinySQLException {
        throw new tinySQLException("Conversion not supported");
    }

    public Object convertJDBCToNative(tsColumn col, Object o) throws tinySQLException {
        byte[] b;
        if (o instanceof byte[] && (b = (byte[])o).length == col.getSize()) {
            return b;
        }
        return super.convertJDBCToNative(col, o);
    }

    public String convertNativeToString(tsColumn col, Object o) throws tinySQLException {
        if (o instanceof byte[]) {
            byte[] b = (byte[])o;
            try {
                String s = new String(b, 0, this.seekEnd(b), this.encoding);
                return this.quoting.undoQuoting(s.trim());
            }
            catch (UnsupportedEncodingException e) {
                throw new tinySQLException("Encoding not supported");
            }
        }
        return super.convertNativeToString(col, o);
    }

    private int seekEnd(byte[] b) {
        if (b.length == 0) {
            return 0;
        }
        int counter = b.length - 1;
        while (b[counter] != 32 && counter > 0) {
            --counter;
        }
        if (counter == 0) {
            return b.length;
        }
        return counter + 1;
    }

    public BigDecimal convertNativeToNumber(tsColumn col, Object o) throws tinySQLException {
        if (o instanceof byte[]) {
            byte[] b = (byte[])o;
            try {
                String s = new String(b, 0, b.length, this.encoding).trim();
                if (s.length() == 0) {
                    return new BigDecimal(0.0);
                }
                return new BigDecimal(this.quoting.undoQuoting(s));
            }
            catch (UnsupportedEncodingException ue) {
                throw new tinySQLException("Encoding not supported");
            }
            catch (Exception e) {
                throw new tinySQLException("Parsing failed");
            }
        }
        return super.convertNativeToNumber(col, o);
    }
}

