/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL;

import ORG.as220.tinySQL.textFile;
import ORG.as220.tinySQL.textFileConverter;
import ORG.as220.tinySQL.textFileRow;
import ORG.as220.tinySQL.tinySQLConnection;
import ORG.as220.tinySQL.tinySQLConverter;
import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tinySQLTable;
import ORG.as220.tinySQL.tinySQLTableView;
import ORG.as220.tinySQL.tsColumn;
import ORG.as220.tinySQL.tsRawRow;
import ORG.as220.tinySQL.util.Log;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.StreamTokenizer;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;

public class textFileTable
extends tinySQLTable {
    private String dataDir;
    private textFileConverter converter;
    private Vector column_info;
    private RandomAccessFile ftbl;
    private static final int COLUMN_SIZE = 0;
    private static final int COLUMN_TYPE = 1;
    private static final int COLUMN_POS = 2;
    private int _record_length;
    private int _rowCount = -1;
    private String encoding;
    private byte[] delpref;
    private byte[] delpost;
    private byte[] colpref;
    private byte[] colpost;
    private byte[] rowpref;
    private byte[] rowpost;
    private byte[] tablepref;
    private byte[] tablepost;
    private static final byte[] NOT_DELETED = new byte[]{78};
    private static final byte[] IS_DELETED = new byte[]{89};
    private String defext;
    private String tableext;
    private static final int ROW_UNREAD = 0;
    private static final int ROW_DELETED = -1;
    private static final int ROW_NOT_DELETED = 1;
    private byte[] deletedRows;
    private textFile databaseEngine;
    private int deleteMode;
    private int insertMode;
    private boolean readonly;
    private boolean ignoreFirst;
    private boolean ignoreLast;
    private textFileRow prototype;
    private boolean compressTableCalled = false;

    public textFileTable(String dDir, String table_name, textFile engine) throws tinySQLException {
        super(table_name);
        this.encoding = engine.getEncoding();
        this.readonly = engine.isReadOnly();
        this.databaseEngine = engine;
        this.ignoreFirst = engine.isIgnoringFirstColumnPrefix();
        this.ignoreLast = engine.isIgnoringLastColumnPostfix();
        this.defext = engine.getDefinitionExtension();
        this.tableext = engine.getTableExtension();
        this.dataDir = dDir;
        this.delpref = engine.getDelPrefix();
        this.delpost = engine.getDelPostfix();
        this.rowpref = engine.getRowPrefix();
        this.rowpost = engine.getRowPostfix();
        this.colpref = engine.getColumnPrefix();
        this.colpost = engine.getColumnPostfix();
        this.tablepref = engine.getTablePrefix();
        this.tablepost = engine.getTablePostfix();
        this.insertMode = engine.getInsertMode();
        this.deleteMode = engine.getDeleteMode();
        try {
            this.ftbl = this.readonly ? new RandomAccessFile(this.dataDir + "/" + table_name + this.tableext, "r") : new RandomAccessFile(this.dataDir + "/" + table_name + this.tableext, "rw");
        }
        catch (Exception e) {
            throw new tinySQLException("Could not open the table " + this.getName() + " [" + table_name + this.tableext + "].");
        }
        try {
            this.readColumnInfo();
        }
        catch (tinySQLException e) {
            try {
                this.ftbl.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw e;
        }
        this.prototype = this.createInsertRowPrototype();
    }

    public void setRecordLength(int rl) {
        this._record_length = rl;
    }

    public void setRowCount(int rc) {
        this._rowCount = rc;
        byte[] _deletedRows = new byte[rc];
        if (this.deletedRows != null) {
            System.arraycopy(this.deletedRows, 0, _deletedRows, 0, Math.min(this.deletedRows.length, _deletedRows.length));
        }
        this.deletedRows = _deletedRows;
    }

    public tinySQLConverter getConverter() throws tinySQLException {
        if (this.converter == null) {
            try {
                this.converter = new textFileConverter(this.encoding, this.databaseEngine.getQuoting());
            }
            catch (Exception e) {
                throw new tinySQLException(e);
            }
        }
        return this.converter;
    }

    public boolean close() throws tinySQLException {
        if (!this.compressTableCalled) {
            Log.info("About to close table " + this.getName());
            Enumeration e = this.getViews();
            while (e.hasMoreElements()) {
                tinySQLTableView view = (tinySQLTableView)e.nextElement();
                view.close();
            }
        }
        if (this.deleteMode == 2 && !this.compressTableCalled) {
            this.compressTableCalled = true;
            if (this.findDeletedRow() != -1) {
                tinySQLConnection c = this.databaseEngine.getConnection();
                Log.info("COMPACT TABLE " + this.getName() + " before close");
                try {
                    Statement stmt = c.createStatement();
                    stmt.executeUpdate("COMPACT TABLE " + this.getName());
                    stmt.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return false;
            }
        }
        Log.info("Closing table " + this.getName());
        try {
            this.ftbl.close();
        }
        catch (IOException ioe) {
            throw new tinySQLException(ioe);
        }
        return true;
    }

    private int findDeletedRow() {
        int i = 0;
        while (i < this.deletedRows.length) {
            if (this.deletedRows[i] == -1) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getNextInsertRow() throws tinySQLException {
        if (this.insertMode == 2) {
            return this.getRowCount();
        }
        int delrow = this.findDeletedRow();
        Log.debug("FindDeletedRow returned : " + delrow);
        if (delrow != -1) {
            return delrow;
        }
        if (this.insertMode == 0) {
            Log.debug("RowCount: " + this.getRowCount());
            return this.getRowCount();
        }
        int i = 0;
        while (i < this.deletedRows.length) {
            boolean del;
            if (this.deletedRows[i] == -1) {
                return i;
            }
            if (this.deletedRows[i] == 0 && (del = this.isDeleted(i))) {
                return i;
            }
            ++i;
        }
        return this.getRowCount();
    }

    public tsColumn getColumnDefinition(int column) {
        tsColumn info = null;
        info = this.deleteMode == -1 ? (tsColumn)this.column_info.get(column + 1) : (tsColumn)this.column_info.get(column);
        if (info == null) {
            return null;
        }
        return info;
    }

    public tsRawRow getInsertRow() {
        textFileRow row = new textFileRow(this.prototype);
        row.setData(this.prototype.getData());
        return row;
    }

    public textFileRow createInsertRowPrototype() throws tinySQLException {
        textFileRow row = new textFileRow(this.column_info, this.getConverter());
        byte[] data = new byte[this.getRecordLength()];
        Arrays.fill(data, (byte)32);
        int currentPos = this.setRawData(this.rowpref, data, 0);
        if (this.deleteMode == -1) {
            currentPos = this.setRawData(this.delpref, data, currentPos);
            currentPos = this.setRawData(NOT_DELETED, data, currentPos);
            currentPos = this.setRawData(this.delpost, data, currentPos);
        }
        int colcount = this.getColumnCount();
        int i = 0;
        while (i < colcount) {
            if (!this.ignoreFirst || i != 0) {
                currentPos = this.setRawData(this.colpref, data, currentPos);
            }
            currentPos += this.getColumnDefinition(i).getSize();
            if (!this.ignoreLast || i != colcount - 1) {
                currentPos = this.setRawData(this.colpost, data, currentPos);
            }
            ++i;
        }
        System.out.println("___" + currentPos);
        currentPos = this.setRawData(this.rowpost, data, currentPos);
        row.setData(data);
        return row;
    }

    private int setRawData(byte[] insert, byte[] data, int pos) {
        if (insert.length == 0) {
            return pos;
        }
        System.arraycopy(insert, 0, data, pos, insert.length);
        return pos + insert.length;
    }

    public synchronized void updateRow(int row, tsRawRow v) throws tinySQLException {
        if (this.readonly) {
            throw new tinySQLException("Database is readonly");
        }
        if (v instanceof textFileRow) {
            try {
                textFileRow nativeRow = (textFileRow)v;
                byte[] ovalue = nativeRow.getData();
                this.ftbl.seek(this.calcRowPosition(row));
                this.ftbl.write(ovalue);
            }
            catch (IOException ioe) {
                throw new tinySQLException(ioe);
            }
        } else {
            throw new tinySQLException("updateRow expects a native data row");
        }
    }

    public int insertRow(tsRawRow values) throws tinySQLException {
        if (this.readonly) {
            throw new tinySQLException("Database is readonly");
        }
        int insertRow = 0;
        RandomAccessFile randomAccessFile = this.ftbl;
        synchronized (randomAccessFile) {
            try {
                textFileRow nativeRow = (textFileRow)values;
                insertRow = this.getNextInsertRow();
                Log.debug("Insering in row : " + insertRow + " -> " + this.getRowCount());
                this.ftbl.seek(this.calcRowPosition(insertRow));
                this.ftbl.write(nativeRow.getData());
                this.ftbl.write(this.tablepost);
                if (insertRow == this.getRowCount()) {
                    this.setRowCount(insertRow + 1);
                }
            }
            catch (Exception e) {
                throw new tinySQLException(e);
            }
        }
        return insertRow;
    }

    public int getRowCount() {
        return this._rowCount;
    }

    public int getColumnCount() {
        if (this.deleteMode == -1) {
            return this.column_info.size() - 1;
        }
        return this.column_info.size();
    }

    public tsRawRow getRow(int row) throws tinySQLException {
        byte[] line = new byte[this.getRecordLength()];
        RandomAccessFile randomAccessFile = this.ftbl;
        synchronized (randomAccessFile) {
            try {
                this.ftbl.seek(this.calcRowPosition(row));
                this.ftbl.readFully(line);
            }
            catch (IOException ioe) {
                Log.error("Failed to read record[" + this.calcRowPosition(row) + ":" + line.length + ": " + row + "]", ioe);
                throw new tinySQLException(ioe);
            }
        }
        this.deletedRows[row] = line.length > 0 ? (this.isDeleted(line, row) ? -1 : 1) : 1;
        textFileRow tsrow = new textFileRow(this.column_info, this.getConverter());
        tsrow.setData(line);
        return tsrow;
    }

    private Object getColumn(int column, String line) throws tinySQLException {
        tsColumn info = (tsColumn)this.column_info.elementAt(column);
        String datatype = textFileTable.typeToLiteral(info.getType());
        int size = info.getSize();
        int pos = info.getBytePosition();
        String result = line.substring(pos, pos + size);
        tinySQLConverter con = this.getConverter();
        return con.convertNativeToJDBC(info, result);
    }

    public void deleteRow(int row) throws tinySQLException {
        if (this.readonly) {
            throw new tinySQLException("Database is readonly");
        }
        if (row >= this.getRowCount()) {
            throw new tinySQLException("No such record");
        }
        Log.debug("DeleteMode : " + this.deleteMode + " DELETE ROW " + row);
        if (this.deleteMode == 1) {
            throw new tinySQLException("Deletion of records has been disabled");
        }
        this.deletedRows[row] = -1;
        if (this.deleteMode == -1) {
            RandomAccessFile randomAccessFile = this.ftbl;
            synchronized (randomAccessFile) {
                try {
                    this.ftbl.seek(this.calcRowPosition(row) + this.rowpref.length + this.delpref.length);
                    this.ftbl.write(IS_DELETED);
                }
                catch (IOException ioe) {
                    Log.error("Failed to read record: " + row, ioe);
                }
            }
        }
    }

    protected int calcRowPosition(int row) {
        return row * this.getRecordLength() + this.tablepref.length;
    }

    public boolean isDeleted(int row) throws tinySQLException {
        if (this.deleteMode == 1) {
            return false;
        }
        if (this.deletedRows[row] == 0) {
            this.getRow(row);
        }
        return this.deletedRows[row] == -1;
    }

    private boolean isDeleted(byte[] b, int row) {
        if (this.deleteMode == 1) {
            return false;
        }
        if (this.deleteMode == 2) {
            if (this.deletedRows[row] == -1) {
                return true;
            }
            if (this.deletedRows[row] == 1) {
                return false;
            }
        }
        return b[this.rowpref.length + this.delpref.length] == 89;
    }

    protected void readColumnInfo() throws tinySQLException {
        boolean fdef_open = false;
        FileInputStream fdef = null;
        try {
            this.column_info = new Vector();
            fdef = new FileInputStream(this.dataDir + "/" + this.getName() + this.defext);
            fdef_open = true;
            BufferedReader r = new BufferedReader(new InputStreamReader(fdef));
            StreamTokenizer def = new StreamTokenizer(r);
            def.whitespaceChars(124, 124);
            def.wordChars(48, 122);
            def.eolIsSignificant(false);
            def.parseNumbers();
            int tablePos = 0;
            int record_length = this.rowpref.length;
            while (def.nextToken() != -1) {
                int datatype = 1;
                if (def.sval.equals("NUMERIC")) {
                    datatype = 2;
                } else if (def.sval.equals("DATE")) {
                    datatype = 91;
                }
                def.nextToken();
                String column = def.sval;
                def.nextToken();
                int size = (int)def.nval;
                record_length = this.addColumnDefinition(column, datatype, size, record_length, tablePos);
                Log.debug("RecordLength [" + tablePos + "] : " + record_length);
                ++tablePos;
            }
            fdef.close();
            fdef_open = false;
            record_length += this.rowpost.length;
            if (this.ignoreLast) {
                record_length -= this.colpost.length;
            }
            System.out.println("RecordLength: " + record_length);
            this.setRecordLength(record_length);
            long datalength = this.ftbl.length() - (long)this.tablepref.length - (long)this.tablepost.length;
            if (datalength < 0L) {
                throw new tinySQLException("TableError negative data size: " + datalength);
            }
            this.setRowCount((int)(datalength / (long)record_length));
        }
        catch (Exception e) {
            try {
                if (fdef_open) {
                    fdef.close();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw new tinySQLException(e);
        }
    }

    private int addColumnDefinition(String column, int datatype, int size, int record_length, int tablePos) {
        int retval = 0;
        if (this.deleteMode == -1 && column.equals("_DELETED")) {
            tsColumn info = new tsColumn(null, column);
            info.setBytePosition(record_length + this.delpref.length);
            info.setType(datatype);
            info.setSize(size);
            info.setTablePosition(tablePos);
            this.column_info.add(info);
            retval = size + record_length + this.delpref.length + this.delpost.length;
            return retval;
        }
        tsColumn info = new tsColumn(null, column);
        int columnPosition = record_length + this.colpref.length;
        if (this.ignoreFirst && (this.deleteMode == -1 && tablePos == 1 || tablePos == 0)) {
            columnPosition = record_length;
        }
        info.setBytePosition(columnPosition);
        info.setType(datatype);
        info.setSize(size);
        info.setTablePosition(tablePos);
        this.column_info.add(info);
        retval = size + columnPosition + this.colpost.length;
        return retval;
    }

    protected static String typeToLiteral(int type) {
        if (type == 1) {
            return "CHAR";
        }
        if (type == 2) {
            return "NUMERIC";
        }
        if (type == -7) {
            return "BOOLEAN";
        }
        if (type == 4) {
            return "NUMERIC";
        }
        if (type == -2) {
            return "BINARY";
        }
        if (type == 91) {
            return "DATE";
        }
        return "CHAR";
    }

    public int getRecordLength() {
        return this._record_length;
    }
}

