/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL;

import ORG.as220.tinySQL.parser.ParseException;
import ORG.as220.tinySQL.parser.TinySQLParser;
import ORG.as220.tinySQL.sqlparser.AlterCreateTableStatement;
import ORG.as220.tinySQL.sqlparser.AlterTableAddColumnStatement;
import ORG.as220.tinySQL.sqlparser.AlterTableDropColumnStatement;
import ORG.as220.tinySQL.sqlparser.AlterTableRenameColumnStatement;
import ORG.as220.tinySQL.sqlparser.ColumnDefinition;
import ORG.as220.tinySQL.sqlparser.ColumnValue;
import ORG.as220.tinySQL.sqlparser.CompactTableStatement;
import ORG.as220.tinySQL.sqlparser.CreateTableStatement;
import ORG.as220.tinySQL.sqlparser.DeleteStatement;
import ORG.as220.tinySQL.sqlparser.DropTableStatement;
import ORG.as220.tinySQL.sqlparser.InsertStatement;
import ORG.as220.tinySQL.sqlparser.SQLStatement;
import ORG.as220.tinySQL.sqlparser.SelectStatement;
import ORG.as220.tinySQL.sqlparser.UpdateStatement;
import ORG.as220.tinySQL.sqlparser.WhereClause;
import ORG.as220.tinySQL.tinySQLConnection;
import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tinySQLResultSet;
import ORG.as220.tinySQL.tinySQLStatement;
import ORG.as220.tinySQL.tinySQLTable;
import ORG.as220.tinySQL.tinySQLTableView;
import ORG.as220.tinySQL.tsColumn;
import ORG.as220.tinySQL.tsPhysicalRow;
import ORG.as220.tinySQL.tsResultRow;
import ORG.as220.tinySQL.tsResultSet;
import ORG.as220.tinySQL.tsRow;
import ORG.as220.tinySQL.tsWeakPhysicalRow;
import ORG.as220.tinySQL.util.Log;
import java.io.IOException;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public abstract class tinySQL {
    private Hashtable tables = new Hashtable();
    private tinySQLConnection connection;

    public tinySQLConnection getConnection() {
        return this.connection;
    }

    public void setConnection(tinySQLConnection c) {
        this.connection = c;
    }

    public SQLStatement parse(tinySQLStatement s, String sql) throws tinySQLException {
        StringReader reader = new StringReader(sql);
        TinySQLParser parser = new TinySQLParser(reader);
        SQLStatement stmt = null;
        try {
            stmt = parser.getStatement(s);
        }
        catch (ParseException pe) {
            throw new tinySQLException("Parse error: " + pe);
        }
        catch (Exception pe) {
            throw new tinySQLException("Error while generating statement: " + pe, pe);
        }
        return stmt;
    }

    public tsResultSet SelectStatement(SelectStatement select) throws tinySQLException {
        Enumeration tableEnum = select.getTables();
        Vector<tinySQLTableView> tables = new Vector<tinySQLTableView>();
        while (tableEnum.hasMoreElements()) {
            tinySQLTableView table = (tinySQLTableView)tableEnum.nextElement();
            tables.add(table);
        }
        Vector tableColumnVector = select.getTableColumns();
        WhereClause whereC = select.getWhereClause();
        tinySQLStatement stmt = select.getStatement();
        Hashtable<tinySQLTableView, Vector<tsColumn>> tableColumns = new Hashtable<tinySQLTableView, Vector<tsColumn>>();
        int size = tableColumnVector.size();
        int i = 0;
        while (i < size) {
            tsColumn column = (tsColumn)tableColumnVector.elementAt(i);
            tinySQLTableView table = column.getTable();
            Vector<tsColumn> v = (Vector<tsColumn>)tableColumns.get(table);
            if (v == null) {
                v = new Vector<tsColumn>();
            }
            v.add(column);
            tableColumns.put(table, v);
            ++i;
        }
        tsWeakPhysicalRow row = new tsWeakPhysicalRow(tableColumnVector);
        tsResultSet jrs = new tsResultSet(row, select.getResultColumns(), tableColumns, whereC, this);
        try {
            jrs.setFetchSize(stmt.getFetchSize());
            jrs.setType(stmt.getResultSetType());
        }
        catch (SQLException sqle) {
            Log.warn("Caught SQLException while setting Fetchsize and ResultSetType");
            Log.warn("   This event not expected to occur and will be ignored.");
            sqle.printStackTrace();
        }
        return jrs;
    }

    public int continueQuery(tsResultSet res) throws tinySQLException {
        Vector tables = res.getTables();
        if (tables.size() == 0) {
            Log.info("No Tables in select, signaling end-of-file");
            return -1;
        }
        Hashtable tableColumns = res.getColumns();
        int level = res.getLevel();
        tsPhysicalRow record = res.createPhysicalRow();
        tinySQLTableView currentTable = null;
        Stack<tinySQLTableView> state = new Stack<tinySQLTableView>();
        int i = 0;
        while (i <= level) {
            currentTable = (tinySQLTableView)tables.elementAt(i);
            Vector columns = (Vector)tableColumns.get(currentTable);
            if (!currentTable.isBeforeFirst()) {
                this.addColumnsToRow(columns, record, currentTable);
            }
            state.push(currentTable);
            ++i;
        }
        while (level > -1) {
            boolean addOK;
            boolean levelFound = false;
            currentTable = (tinySQLTableView)state.peek();
            boolean found = false;
            boolean eof = false;
            boolean haveRecord = false;
            if (currentTable.nextNonDeleted()) {
                Vector columns = (Vector)tableColumns.get(currentTable);
                this.addColumnsToRow(columns, record, currentTable);
                eof = false;
                if (level + 1 < tables.size()) {
                    state.push((tinySQLTableView)tables.elementAt(++level));
                } else {
                    haveRecord = true;
                }
            } else {
                --level;
                eof = true;
                currentTable.beforeFirst();
                state.pop();
            }
            if (!haveRecord || !res.getWhereClause().isMatch(record) || (addOK = res.addPhysicalRow(new tsPhysicalRow(record)))) continue;
            return level;
        }
        return level;
    }

    protected void addColumnsToRow(Vector columns, tsPhysicalRow record, tinySQLTableView jtbl) throws tinySQLException {
        int size = columns.size();
        int ii = 0;
        while (ii < size) {
            tsColumn col = (tsColumn)columns.elementAt(ii);
            Object o = jtbl.getColumn(col.getTablePosition());
            int incol = col.getResultPosition();
            record.put(incol, o);
            ++ii;
        }
    }

    public int DeleteStatement(DeleteStatement stmt) throws tinySQLException {
        int updateCount = 0;
        tinySQLTableView jtbl = stmt.getTable();
        WhereClause w = stmt.getWhereClause();
        tsPhysicalRow rec = new tsPhysicalRow(stmt.getWhereClause().getColumns());
        jtbl.beforeFirst();
        while (jtbl.nextNonDeleted()) {
            rec.refresh();
            if (!w.isMatch(rec)) continue;
            jtbl.deleteRow();
            ++updateCount;
        }
        jtbl.close();
        return updateCount;
    }

    public int UpdateStatement(UpdateStatement upd) throws tinySQLException {
        tinySQLTableView jtbl = upd.getTable();
        WhereClause w = upd.getWhereClause();
        int updateCount = 0;
        Vector names = upd.getColumns();
        tsPhysicalRow rec = new tsPhysicalRow(names);
        tsResultRow resrow = upd.getValues();
        jtbl.beforeFirst();
        while (jtbl.nextNonDeleted()) {
            rec.refresh();
            if (!w.isMatch(rec)) continue;
            resrow.setParent(rec);
            jtbl.updateRow(resrow);
            ++updateCount;
        }
        jtbl.close();
        return updateCount;
    }

    public int InsertStatement(InsertStatement ins) throws tinySQLException {
        int updateCount = 0;
        tinySQLTableView jtbl = ins.getTable();
        try {
            block10: {
                try {
                    if (ins.hasSubSelect()) {
                        Vector cols = ins.getColumns();
                        int size = cols.size();
                        SelectStatement stmt = ins.getSelect();
                        if (!stmt.execute()) {
                            throw new tinySQLException("Select did not return a statement");
                        }
                        tinySQLResultSet res = stmt.getResultSet();
                        tsPhysicalRow insertRow = new tsPhysicalRow(cols);
                        String[] name = new String[insertRow.size()];
                        int i = 0;
                        while (i < name.length) {
                            name[i] = insertRow.getColumnDefinition(i).getPhysicalName();
                            ++i;
                        }
                        while (res.next()) {
                            int i2 = 0;
                            while (i2 < size) {
                                insertRow.put(i2, res.getObject(name[i2]));
                                ++i2;
                            }
                            jtbl.insertRow(insertRow);
                            ++updateCount;
                        }
                        res.close();
                        break block10;
                    }
                    Vector values = ins.getValues();
                    int i = 0;
                    while (i < values.size()) {
                        tsRow row = (tsRow)values.elementAt(i);
                        jtbl.insertRow(row);
                        ++updateCount;
                        ++i;
                    }
                }
                catch (SQLException e) {
                    throw new tinySQLException("Insert failed", e);
                }
            }
            Object var13_16 = null;
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            jtbl.close();
            throw throwable;
        }
        jtbl.close();
        return updateCount;
    }

    protected abstract void db_createTable(String var1, Vector var2) throws IOException, tinySQLException;

    protected void db_copyTableMeta(String orgTable, String newname, Vector v) throws IOException, tinySQLException {
        this.db_createTable(newname, v);
    }

    protected abstract void db_removeTable(String var1) throws IOException, tinySQLException;

    protected abstract void db_renameTable(String var1, String var2) throws IOException, tinySQLException;

    public abstract boolean CreateTable(CreateTableStatement var1) throws tinySQLException;

    public boolean AlterTableAddCol(AlterTableAddColumnStatement stmt) throws tinySQLException {
        tinySQLTableView table = stmt.getTable();
        String tableName = table.getName();
        this.closeTable(tableName);
        String orgTableName = tableName + "_tmp_ATAC_ORG";
        String newTableName = tableName + "_tmp_ATAC";
        try {
            this.db_removeTable(orgTableName);
            this.db_removeTable(newTableName);
            tinySQLTable oldFile = this.openTable(tableName);
            Vector<tsColumn> coldef_list = new Vector<tsColumn>();
            int size = oldFile.getColumnCount();
            int i = 0;
            while (i < size) {
                coldef_list.addElement(oldFile.getColumnDefinition(i));
                ++i;
            }
            Vector v = stmt.getColumns();
            Vector<tsColumn> n_coldef_list = new Vector<tsColumn>(coldef_list);
            int jj = 0;
            while (jj < v.size()) {
                ColumnDefinition coldef = (ColumnDefinition)v.elementAt(jj);
                tsColumn col = coldef.getColumn();
                n_coldef_list.add(col);
                ++jj;
            }
            oldFile.close();
            this.db_copyTableMeta(tableName, newTableName, n_coldef_list);
            InsertStatement insert = new InsertStatement(stmt.getStatement());
            insert.setTable(newTableName);
            SelectStatement select = new SelectStatement(stmt.getStatement());
            select.addTable(tableName, tableName);
            size = coldef_list.size();
            int i2 = 0;
            while (i2 < size) {
                tsColumn column = (tsColumn)coldef_list.elementAt(i2);
                String name = column.getFQName();
                select.addColumn(new ColumnValue(name), name);
                insert.addColumn(name);
                ++i2;
            }
            insert.addSelect(select);
            boolean b = insert.execute();
            if (b) {
                throw new tinySQLException("Insert .. select returned a resultSet?!");
            }
            stmt.setUpdateCount(insert.getUpdateCount());
            this.closeTable(tableName);
            this.closeTable(newTableName);
            this.db_renameTable(tableName, orgTableName);
            this.db_renameTable(newTableName, tableName);
            this.db_removeTable(orgTableName);
        }
        catch (Exception e) {
            throw new tinySQLException(e);
        }
        return false;
    }

    public boolean AlterCreateTable(AlterCreateTableStatement stmt) throws tinySQLException {
        try {
            CreateTableStatement cstmt = stmt.getCreateTableStatement();
            String tablename = cstmt.getTable();
            String newTableName = tablename + "_tmp_ACT";
            String orgTableName = tablename + "_tmp_ACT_ORG";
            cstmt.setTable(newTableName);
            cstmt.execute();
            tinySQLTable oldTable = this.openTable(tablename);
            tinySQLTable newTable = this.openTable(newTableName);
            Vector<String> newnames = new Vector<String>();
            int i = 0;
            while (i < newTable.getColumnCount()) {
                newnames.add(newTable.getColumnDefinition(i).getPhysicalName());
                ++i;
            }
            Vector<String> names = new Vector<String>();
            int i2 = 0;
            while (i2 < oldTable.getColumnCount()) {
                String name = oldTable.getColumnDefinition(i2).getPhysicalName();
                if (newnames.indexOf(name) != -1) {
                    names.add(name);
                }
                ++i2;
            }
            oldTable.close();
            newTable.close();
            InsertStatement insert = new InsertStatement(stmt.getStatement());
            insert.setTable(newTableName);
            SelectStatement select = new SelectStatement(stmt.getStatement());
            select.addTable(tablename, tablename);
            int size = names.size();
            int i3 = 0;
            while (i3 < size) {
                String name = (String)names.elementAt(i3);
                select.addColumn(new ColumnValue(name), name);
                insert.addColumn(name);
                ++i3;
            }
            insert.addSelect(select);
            boolean b = insert.execute();
            if (b) {
                throw new tinySQLException("Insert .. select returned a resultSet?!");
            }
            stmt.setUpdateCount(insert.getUpdateCount());
            this.closeTable(tablename);
            this.closeTable(newTableName);
            this.db_renameTable(tablename, orgTableName);
            this.db_renameTable(newTableName, tablename);
            this.db_removeTable(orgTableName);
        }
        catch (Exception e) {
            throw new tinySQLException(e);
        }
        return false;
    }

    public boolean AlterTableDropCol(AlterTableDropColumnStatement stmt) throws tinySQLException {
        tinySQLTableView table = stmt.getTable();
        String tableName = table.getName();
        this.closeTable(tableName);
        String orgTableName = tableName + "_tmp_ATAC_ORG";
        String newTableName = tableName + "_tmp_ATAC";
        try {
            this.db_removeTable(orgTableName);
            this.db_removeTable(newTableName);
            tinySQLTable oldFile = this.openTable(tableName);
            Vector<tsColumn> coldef_list = new Vector<tsColumn>();
            int size = oldFile.getColumnCount();
            int i = 0;
            while (i < size) {
                coldef_list.addElement(oldFile.getColumnDefinition(i));
                ++i;
            }
            Vector v = stmt.getColumns();
            int jj = 0;
            while (jj < v.size()) {
                tsColumn col = (tsColumn)v.elementAt(jj);
                int ix = this.findColumn(col, coldef_list);
                if (ix == -1) {
                    Log.warn("ALTER TABLE " + tableName + ": There is no such column: " + col);
                } else {
                    coldef_list.removeElementAt(ix);
                }
                ++jj;
            }
            oldFile.close();
            this.db_copyTableMeta(tableName, newTableName, coldef_list);
            InsertStatement insert = new InsertStatement(stmt.getStatement());
            insert.setTable(newTableName);
            SelectStatement select = new SelectStatement(stmt.getStatement());
            select.addTable(tableName, tableName);
            size = coldef_list.size();
            int i2 = 0;
            while (i2 < size) {
                tsColumn column = (tsColumn)coldef_list.elementAt(i2);
                String name = column.getFQName();
                select.addColumn(new ColumnValue(name), name);
                insert.addColumn(name);
                ++i2;
            }
            insert.addSelect(select);
            boolean b = insert.execute();
            if (b) {
                throw new tinySQLException("Insert .. select returned a resultSet?!");
            }
            stmt.setUpdateCount(insert.getUpdateCount());
            this.closeTable(tableName);
            this.closeTable(newTableName);
            this.db_renameTable(tableName, orgTableName);
            this.db_renameTable(newTableName, tableName);
            this.db_removeTable(orgTableName);
        }
        catch (Exception e) {
            throw new tinySQLException(e);
        }
        return false;
    }

    public int findColumn(tsColumn col, Vector v) {
        int size = v.size();
        int i = 0;
        while (i < size) {
            tsColumn vcol = (tsColumn)v.elementAt(i);
            if (col.isValidName(vcol.getPhysicalName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean AlterTableRenameCol(AlterTableRenameColumnStatement stmt) throws tinySQLException {
        throw new tinySQLException("ALTER TABLE RENAME is not supported by this implementation");
    }

    public void DropTable(DropTableStatement statement) throws tinySQLException {
        tinySQLTableView fname = statement.getTable();
        try {
            String name = fname.getName();
            this.closeTable(name);
            this.db_removeTable(name);
        }
        catch (Exception e) {
            throw new tinySQLException(e);
        }
    }

    public abstract tinySQLTable openTable(String var1) throws tinySQLException;

    public void closeTable(String table_name) throws tinySQLException {
        tinySQLTable table = (tinySQLTable)this.tables.get(table_name);
        if (table != null) {
            if (table.close()) {
                this.tables.remove(table_name);
            }
            Log.debug("TinySQL: Table " + table_name + " closed.");
        }
    }

    public void close() {
        Enumeration enumeration = this.tables.keys();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            try {
                this.closeTable(name);
            }
            catch (tinySQLException e) {
                Log.warn("Table " + name + " was not closed cleanly");
            }
        }
    }

    public tinySQLTableView getTable(String table_name) throws tinySQLException {
        tinySQLTable table = (tinySQLTable)this.tables.get(table_name);
        if (table == null) {
            table = this.openTable(table_name);
            this.tables.put(table_name, table);
            Log.debug("TinySQL: Table " + table_name + " opened.");
        }
        tinySQLTableView view = new tinySQLTableView(table);
        return view;
    }

    public void CompactTable(CompactTableStatement stmt) throws tinySQLException {
        tinySQLTableView table = stmt.getTable();
        String tableName = table.getName();
        String orgTableName = tableName + "_tmp_CPT_ORG";
        String newTableName = tableName + "_tmp_CPT";
        try {
            this.db_removeTable(orgTableName);
            this.db_removeTable(newTableName);
            tinySQLTableView oldFile = this.getTable(tableName);
            Vector<tsColumn> coldef_list = new Vector<tsColumn>();
            int size = oldFile.getColumnCount();
            int i = 0;
            while (i < size) {
                coldef_list.addElement(oldFile.getColumnDefinition(i));
                ++i;
            }
            this.db_copyTableMeta(tableName, newTableName, coldef_list);
            InsertStatement insert = new InsertStatement(stmt.getStatement());
            insert.setTable(newTableName);
            SelectStatement select = new SelectStatement(stmt.getStatement());
            select.addTable(tableName, tableName);
            size = coldef_list.size();
            int i2 = 0;
            while (i2 < size) {
                tsColumn column = (tsColumn)coldef_list.elementAt(i2);
                String name = column.getPhysicalName();
                select.addColumn(new ColumnValue(name), name);
                insert.addColumn(name);
                ++i2;
            }
            insert.addSelect(select);
            boolean b = insert.execute();
            if (b) {
                throw new tinySQLException("Insert .. select returned a resultSet?!");
            }
            this.closeTable(tableName);
            this.closeTable(newTableName);
            this.db_renameTable(tableName, orgTableName);
            this.db_renameTable(newTableName, tableName);
            this.db_removeTable(orgTableName);
        }
        catch (Exception e) {
            throw new tinySQLException(e);
        }
    }
}

