/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL;

import ORG.as220.tinySQL.sqlparser.SQLStatement;
import ORG.as220.tinySQL.tinySQL;
import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tinySQLPreparedStatement;
import ORG.as220.tinySQL.tinySQLStatement;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;

public abstract class tinySQLConnection
implements Connection {
    private tinySQL tsql = null;
    private Driver driver;
    private String url;
    private String user;
    private String catalog;
    private int isolation;
    private Properties properties;

    public tinySQLConnection(String user, String u, Driver d, Properties p) throws SQLException {
        this.url = u;
        this.user = user;
        this.driver = d;
        this.properties = p;
        this.tsql = this.createDatabaseEngine();
        this.tsql.setConnection(this);
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public Statement createStatement() throws SQLException {
        return new tinySQLStatement(this);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new tinySQLPreparedStatement(this, sql, this.getCatalog());
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLException("tinySQL does not support stored procedures.");
    }

    public String nativeSQL(String sql) throws SQLException {
        return sql;
    }

    public void setAutoCommit(boolean b) throws SQLException {
    }

    public void commit() throws SQLException {
    }

    public void rollback() throws SQLException {
        throw new SQLException("tinySQL does not support rollbacks.");
    }

    public void close() throws SQLException {
        this.tsql.close();
        this.tsql = null;
    }

    public boolean isClosed() throws SQLException {
        return this.tsql == null;
    }

    public tinySQL getTinySqlHandle() {
        return this.tsql;
    }

    public abstract DatabaseMetaData getMetaData() throws SQLException;

    public void setReadOnly(boolean b) throws SQLException {
        throw new SQLException("tinySQL does not have a read-only mode by default.");
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public void setCatalog(String str) throws SQLException {
        this.catalog = str;
    }

    public String getCatalog() throws SQLException {
        return this.catalog;
    }

    public void setTransactionIsolation(int x) throws SQLException {
        this.isolation = x;
    }

    public int getTransactionIsolation() throws SQLException {
        return this.isolation;
    }

    public void disableAutoClose() throws SQLException {
        this.setAutoClose(false);
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public boolean executeStatement(SQLStatement statement) throws SQLException {
        boolean result = statement.execute();
        return result;
    }

    public boolean getAutoCommit() {
        return true;
    }

    public void setAutoClose(boolean l) {
    }

    public boolean getAutoClose() {
        return false;
    }

    public abstract tinySQL createDatabaseEngine() throws tinySQLException;

    public tinySQL getDatabaseEngine() {
        return this.tsql;
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLException("tinySQL does not support createStatement with concurrency.");
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLException("tinySQL does not support preparedStatement with concurrency.");
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLException("tinySQL does not support prepareCall with concurrency.");
    }

    public Map getTypeMap() throws SQLException {
        throw new SQLException("tinySQL does not support getTypeMap.");
    }

    public void setTypeMap(Map map) throws SQLException {
        throw new SQLException("tinySQL does not support setTypeMap.");
    }

    public Properties getProperties() {
        return this.properties;
    }
}

