/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL;

import ORG.as220.tinySQL.sqlparser.ParserUtils;
import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tsColumn;
import ORG.as220.tinySQL.util.Log;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class tinySQLConverter {
    public String convertNativeToString(tsColumn coldef, Object o) throws tinySQLException {
        return ParserUtils.convertToString(o);
    }

    public Boolean convertNativeToBoolean(tsColumn coldef, Object o) throws tinySQLException {
        return ParserUtils.convertToBoolean(o);
    }

    public BigDecimal convertNativeToNumber(tsColumn coldef, Object o) throws tinySQLException {
        return ParserUtils.convertToNumber(o);
    }

    public Integer convertNativeToInteger(tsColumn coldef, Object o) throws tinySQLException {
        BigDecimal bd = this.convertNativeToNumber(coldef, o);
        return new Integer(bd.intValue());
    }

    public BigInteger convertNativeToBigInteger(tsColumn coldef, Object o) throws tinySQLException {
        BigDecimal bd = this.convertNativeToNumber(coldef, o);
        return bd.toBigInteger();
    }

    public Short convertNativeToShort(tsColumn coldef, Object o) throws tinySQLException {
        BigDecimal bd = this.convertNativeToNumber(coldef, o);
        return new Short(bd.shortValue());
    }

    public Byte convertNativeToByte(tsColumn coldef, Object o) throws tinySQLException {
        BigDecimal bd = this.convertNativeToNumber(coldef, o);
        return new Byte(bd.byteValue());
    }

    public Double convertNativeToDouble(tsColumn coldef, Object o) throws tinySQLException {
        BigDecimal bd = this.convertNativeToNumber(coldef, o);
        return new Double(bd.doubleValue());
    }

    public Float convertNativeToFloat(tsColumn coldef, Object o) throws tinySQLException {
        BigDecimal bd = this.convertNativeToNumber(coldef, o);
        return new Float(bd.floatValue());
    }

    public Date convertNativeToDate(tsColumn coldef, Object o) throws tinySQLException {
        return ParserUtils.convertToDate(o);
    }

    public Time convertNativeToTime(tsColumn coldef, Object o) throws tinySQLException {
        return ParserUtils.convertToTime(o);
    }

    public Timestamp convertNativeToTimestamp(tsColumn coldef, Object o) throws tinySQLException {
        return ParserUtils.convertToTimestamp(o);
    }

    public Object convertNativeToNull(tsColumn coldef) throws tinySQLException {
        return null;
    }

    public Object convertNativeToJDBC(tsColumn coldef, Object o) throws tinySQLException {
        int type = coldef.getType();
        if (o == null) {
            return this.convertNativeToNull(coldef);
        }
        try {
            switch (type) {
                case -7: {
                    return this.convertNativeToBoolean(coldef, o);
                }
                case -6: {
                    return this.convertNativeToByte(coldef, o);
                }
                case 5: {
                    return this.convertNativeToShort(coldef, o);
                }
                case 4: {
                    return this.convertNativeToInteger(coldef, o);
                }
                case -5: {
                    return this.convertNativeToBigInteger(coldef, o);
                }
                case 6: {
                    return this.convertNativeToFloat(coldef, o);
                }
                case 7: {
                    return this.convertNativeToDouble(coldef, o);
                }
                case 8: {
                    return this.convertNativeToDouble(coldef, o);
                }
                case 2: {
                    return this.convertNativeToNumber(coldef, o);
                }
                case 3: {
                    return this.convertNativeToNumber(coldef, o);
                }
                case 1: {
                    return this.convertNativeToString(coldef, o);
                }
                case 12: {
                    return this.convertNativeToString(coldef, o);
                }
                case -1: {
                    return this.convertNativeToString(coldef, o);
                }
                case 91: {
                    return this.convertNativeToDate(coldef, o);
                }
                case 92: {
                    return this.convertNativeToTime(coldef, o);
                }
                case 93: {
                    return this.convertNativeToTimestamp(coldef, o);
                }
            }
            Log.warn("Unknown type, returning object unchanged.");
            return o;
        }
        catch (Exception e) {
            Log.error("Convert Failed for column " + coldef, e);
            return o;
        }
    }

    public Object convertJDBCToNative(tsColumn coldef, Object o) throws tinySQLException {
        int type = coldef.getType();
        if (o == null) {
            return this.convertNullToNative(coldef);
        }
        switch (type) {
            case -7: {
                return this.convertBooleanToNative(coldef, this.convertNativeToBoolean(coldef, o));
            }
            case -6: {
                return this.convertByteToNative(coldef, this.convertNativeToByte(coldef, o));
            }
            case 5: {
                return this.convertShortToNative(coldef, this.convertNativeToShort(coldef, o));
            }
            case 4: {
                return this.convertIntegerToNative(coldef, this.convertNativeToInteger(coldef, o));
            }
            case -5: {
                return this.convertBigIntegerToNative(coldef, this.convertNativeToBigInteger(coldef, o));
            }
            case 6: {
                return this.convertFloatToNative(coldef, this.convertNativeToFloat(coldef, o));
            }
            case 7: {
                return this.convertDoubleToNative(coldef, this.convertNativeToDouble(coldef, o));
            }
            case 8: {
                return this.convertDoubleToNative(coldef, this.convertNativeToDouble(coldef, o));
            }
            case 2: {
                return this.convertNumberToNative(coldef, this.convertNativeToNumber(coldef, o));
            }
            case 3: {
                return this.convertNumberToNative(coldef, this.convertNativeToNumber(coldef, o));
            }
            case 1: {
                return this.convertStringToNative(coldef, this.convertNativeToString(coldef, o));
            }
            case 12: {
                return this.convertStringToNative(coldef, this.convertNativeToString(coldef, o));
            }
            case -1: {
                return this.convertStringToNative(coldef, this.convertNativeToString(coldef, o));
            }
            case 91: {
                return this.convertDateToNative(coldef, this.convertNativeToDate(coldef, o));
            }
            case 92: {
                return this.convertTimeToNative(coldef, this.convertNativeToTime(coldef, o));
            }
            case 93: {
                return this.convertTimestampToNative(coldef, this.convertNativeToTimestamp(coldef, o));
            }
        }
        return o;
    }

    public Object convertNullToNative(tsColumn coldef) throws tinySQLException {
        return null;
    }

    public Object convertNumberToNative(tsColumn coldef, Number o) throws tinySQLException {
        return o;
    }

    public Object convertBigIntegerToNative(tsColumn coldef, BigInteger o) throws tinySQLException {
        return this.convertNumberToNative(coldef, o);
    }

    public Object convertIntegerToNative(tsColumn coldef, Integer o) throws tinySQLException {
        return this.convertNumberToNative(coldef, o);
    }

    public Object convertShortToNative(tsColumn coldef, Short o) throws tinySQLException {
        return this.convertNumberToNative(coldef, o);
    }

    public Object convertByteToNative(tsColumn coldef, Byte o) throws tinySQLException {
        return this.convertNumberToNative(coldef, o);
    }

    public Object convertFloatToNative(tsColumn coldef, Float o) throws tinySQLException {
        return this.convertNumberToNative(coldef, o);
    }

    public Object convertDoubleToNative(tsColumn coldef, Double o) throws tinySQLException {
        return this.convertNumberToNative(coldef, o);
    }

    public Object convertStringToNative(tsColumn coldef, String o) throws tinySQLException {
        return o;
    }

    public Object convertDateToNative(tsColumn coldef, Date o) throws tinySQLException {
        return o;
    }

    public Object convertTimestampToNative(tsColumn coldef, Timestamp o) throws tinySQLException {
        return o;
    }

    public Object convertTimeToNative(tsColumn coldef, Time o) throws tinySQLException {
        return o;
    }

    public Object convertBooleanToNative(tsColumn coldef, Boolean o) throws tinySQLException {
        return o;
    }
}

