/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL;

import ORG.as220.tinySQL.sqlparser.ParameterValue;
import ORG.as220.tinySQL.sqlparser.ParserUtils;
import ORG.as220.tinySQL.tinySQL;
import ORG.as220.tinySQL.tinySQLConnection;
import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tinySQLResultSet;
import ORG.as220.tinySQL.tinySQLStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Vector;

public class tinySQLPreparedStatement
extends tinySQLStatement
implements PreparedStatement {
    private tinySQL sql;
    private Vector parameters;
    private int iParameterCount;
    public static final String PARAM_NOT_FOUND = "SQL bind parameter not found.";

    public tinySQLPreparedStatement(Connection con_, String stSQL_, String stCatalog_) throws tinySQLException {
        super((tinySQLConnection)con_);
        tinySQLConnection c = (tinySQLConnection)con_;
        this.sql = c.getDatabaseEngine();
        this.setStatement(this.sql.parse(this, stSQL_));
        this.parameters = this.getStatement().getParameters();
    }

    private void checkValuesFilled() throws SQLException {
        StringBuffer sbMsg = new StringBuffer();
        ParameterValue sp = null;
        int i = 0;
        while (i < this.parameters.size()) {
            sp = (ParameterValue)this.parameters.elementAt(i);
            if (sp.isEmpty()) {
                sbMsg.append("No value specified for parameter [ " + i + " ].\n");
            }
            ++i;
        }
        if (sbMsg.length() > 0) {
            throw new SQLException(sbMsg.toString());
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        boolean result = this.execute();
        if (result) {
            tinySQLResultSet res = this.getStatement().getResultSet();
            ResultSetMetaData rsmd = res.getMetaData();
            res.close();
            return rsmd;
        }
        throw new tinySQLException("Statement did not create a result set");
    }

    public boolean execute() throws tinySQLException {
        boolean result = this.getStatement().execute();
        return result;
    }

    public ResultSet executeQuery() throws SQLException {
        boolean result = this.execute();
        if (result) {
            return this.getResultSet();
        }
        throw new tinySQLException("Statement returned an UpdateCount\n" + this.sql);
    }

    public int executeUpdate() throws SQLException {
        boolean result = this.execute();
        if (!result) {
            return this.getUpdateCount();
        }
        throw new tinySQLException("Statement returned a ResultSet");
    }

    public void addBatch() throws SQLException {
        this.checkValuesFilled();
        super.addBatch(this.getStatement());
    }

    public void clearParameters() throws SQLException {
        Enumeration enumeration = this.parameters.elements();
        while (enumeration.hasMoreElements()) {
            ParameterValue val = (ParameterValue)enumeration.nextElement();
            val.clear();
        }
    }

    public void setArray(int iIndex_, Array aValue_) throws SQLException {
        if (aValue_ == null) {
            this.setNull(iIndex_, 2003);
        } else {
            ParameterValue val = (ParameterValue)this.parameters.elementAt(iIndex_ - 1);
            val.setValue(aValue_.getArray());
        }
    }

    public void setAsciiStream(int iIndex_, InputStream isValue_, int iLength_) throws SQLException {
        if (isValue_ == null) {
            this.setNull(iIndex_, 12);
        } else {
            ParameterValue val = (ParameterValue)this.parameters.elementAt(iIndex_ - 1);
            val.setValue(isValue_);
        }
    }

    public void setBigDecimal(int iIndex_, BigDecimal bdValue_) throws SQLException {
        if (bdValue_ == null) {
            this.setNull(iIndex_, 3);
        } else {
            ParameterValue val = (ParameterValue)this.parameters.elementAt(iIndex_ - 1);
            val.setValue(bdValue_);
        }
    }

    public void setBinaryStream(int iIndex_, InputStream isValue_, int iLength_) throws SQLException {
        this.setAsciiStream(iIndex_, isValue_, iLength_);
    }

    public void setBlob(int iIndex_, Blob blobValue_) throws SQLException {
        this.setAsciiStream(iIndex_, blobValue_.getBinaryStream(), -1);
    }

    public void setBoolean(int iIndex_, boolean bValue_) throws SQLException {
        ParameterValue val = (ParameterValue)this.parameters.elementAt(iIndex_ - 1);
        val.setValue(new Boolean(bValue_));
    }

    public void setByte(int iIndex_, byte bValue_) throws SQLException {
        ParameterValue val = (ParameterValue)this.parameters.elementAt(iIndex_ - 1);
        val.setValue(new Byte(bValue_).toString());
    }

    public void setBytes(int iIndex_, byte[] bValue_) throws SQLException {
        ParameterValue val = (ParameterValue)this.parameters.elementAt(iIndex_ - 1);
        val.setValue(bValue_);
    }

    public void setCharacterStream(int iIndex_, Reader rValue_, int iLength_) throws SQLException {
        ParameterValue val = (ParameterValue)this.parameters.elementAt(iIndex_ - 1);
        val.setValue(rValue_);
    }

    public void setClob(int iIndex_, Clob clobValue_) throws SQLException {
        this.setCharacterStream(iIndex_, clobValue_.getCharacterStream(), -1);
    }

    public void setDate(int iIndex_, Date dtValue_) throws SQLException {
        this.setDate(iIndex_, dtValue_, null);
    }

    public void setDate(int iIndex_, Date dtValue_, Calendar cal_) throws SQLException {
        if (dtValue_ == null) {
            this.setNull(iIndex_, 91);
        } else {
            ParameterValue val = (ParameterValue)this.parameters.elementAt(iIndex_ - 1);
            val.setValue(dtValue_);
        }
    }

    public void setDouble(int iIndex_, double dValue_) throws SQLException {
        ParameterValue val = (ParameterValue)this.parameters.elementAt(iIndex_ - 1);
        val.setValue(new Double(dValue_));
    }

    public void setFloat(int iIndex_, float fValue_) throws SQLException {
        ParameterValue val = (ParameterValue)this.parameters.elementAt(iIndex_ - 1);
        val.setValue(new Float(fValue_));
    }

    public void setInt(int iIndex_, int iValue_) throws SQLException {
        ParameterValue val = (ParameterValue)this.parameters.elementAt(iIndex_ - 1);
        val.setValue(new Integer(iValue_));
    }

    public void setLong(int iIndex_, long lValue_) throws SQLException {
        ParameterValue val = (ParameterValue)this.parameters.elementAt(iIndex_ - 1);
        val.setValue(new Long(lValue_));
    }

    public void setNull(int iIndex_, int iSqlType_) throws SQLException {
        ParameterValue val = (ParameterValue)this.parameters.elementAt(iIndex_ - 1);
        val.setValue(null);
    }

    public void setNull(int iIndex_, int iSqlType_, String stTypeName_) throws SQLException {
        ParameterValue val = (ParameterValue)this.parameters.elementAt(iIndex_ - 1);
        val.setValue(null);
    }

    public void setObject(int iIndex_, Object oValue_) throws SQLException {
        ParameterValue val = (ParameterValue)this.parameters.elementAt(iIndex_ - 1);
        val.setValue(oValue_);
    }

    public void setObject(int iIndex_, Object oValue_, int iSqlType_) throws SQLException {
        this.setObject(iIndex_, oValue_, iSqlType_, 0);
    }

    public void setObject(int iIndex_, Object oValue_, int iSqlType_, int iScale_) throws SQLException {
        if (oValue_ == null) {
            this.setNull(iIndex_, 1111);
        } else {
            switch (iSqlType_) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    this.setBigDecimal(iIndex_, ParserUtils.convertToNumber(oValue_));
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    this.setString(iIndex_, ParserUtils.convertToString(oValue_));
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    if (oValue_ instanceof String) {
                        this.setBytes(iIndex_, ((String)oValue_).getBytes());
                        break;
                    }
                    this.setBytes(iIndex_, (byte[])oValue_);
                    break;
                }
                case 91: {
                    this.setDate(iIndex_, ParserUtils.convertToDate(oValue_));
                    break;
                }
                case 93: {
                    this.setTimestamp(iIndex_, ParserUtils.convertToTimestamp(oValue_));
                    break;
                }
                case 92: {
                    this.setTime(iIndex_, ParserUtils.convertToTime(oValue_));
                    break;
                }
                case 1111: {
                    ParameterValue val = (ParameterValue)this.parameters.elementAt(iIndex_ - 1);
                    val.setValue(oValue_);
                    break;
                }
                default: {
                    throw new SQLException("Unknown Types value", "S1000");
                }
            }
        }
    }

    public void setRef(int iIndex_, Ref refValue_) throws SQLException {
        if (refValue_ == null) {
            this.setNull(iIndex_, 2006);
        } else {
            ParameterValue val = (ParameterValue)this.parameters.elementAt(iIndex_ - 1);
            val.setValue(refValue_.getBaseTypeName());
        }
    }

    public void setShort(int iIndex_, short sValue_) throws SQLException {
        ParameterValue val = (ParameterValue)this.parameters.elementAt(iIndex_ - 1);
        val.setValue(new Short(sValue_));
    }

    public void setString(int iIndex_, String stValue_) throws SQLException {
        if (stValue_ == null) {
            this.setNull(iIndex_, 12);
        } else {
            ParameterValue val = (ParameterValue)this.parameters.elementAt(iIndex_ - 1);
            val.setValue(stValue_);
        }
    }

    public void setTime(int iIndex_, Time tmValue_) throws SQLException {
        this.setTime(iIndex_, tmValue_, null);
    }

    public void setTime(int iIndex_, Time tmValue_, Calendar cal_) throws SQLException {
        if (tmValue_ == null) {
            this.setNull(iIndex_, 92);
        } else {
            ParameterValue val = (ParameterValue)this.parameters.elementAt(iIndex_ - 1);
            val.setValue(tmValue_);
        }
    }

    public void setTimestamp(int iIndex_, Timestamp tmsValue_) throws SQLException {
        this.setTimestamp(iIndex_, tmsValue_, null);
    }

    public void setTimestamp(int iIndex_, Timestamp tmsValue_, Calendar cal_) throws SQLException {
        if (tmsValue_ == null) {
            this.setNull(iIndex_, 93);
        } else {
            ParameterValue val = (ParameterValue)this.parameters.elementAt(iIndex_ - 1);
            val.setValue(tmsValue_);
        }
    }

    public void setUnicodeStream(int iIndex_, InputStream isValue_, int iLength_) throws SQLException {
        if (isValue_ == null) {
            this.setNull(iIndex_, 12);
        } else {
            this.setBinaryStream(iIndex_, isValue_, iLength_);
        }
    }
}

