/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL;

import ORG.as220.tinySQL.sqlparser.ParserUtils;
import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tinySQLResultSetMetaData;
import ORG.as220.tinySQL.tinySQLStatement;
import ORG.as220.tinySQL.tsResultRow;
import ORG.as220.tinySQL.tsResultSet;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class tinySQLResultSet
implements ResultSet {
    private tinySQLStatement statement;
    private tsResultSet result;
    private tsResultRow current_row;
    private int current_row_index = -1;
    private tinySQLResultSetMetaData meta;

    public tinySQLResultSet(tsResultSet res, tinySQLStatement statement) {
        this.result = res;
        this.statement = statement;
        if (statement != null) {
            statement.onCreateResultSet(this);
        }
    }

    public synchronized boolean next() throws SQLException {
        try {
            ++this.current_row_index;
            if (this.current_row_index == this.result.getResultSize()) {
                return false;
            }
            this.current_row = this.result.getResultRowAt(this.current_row_index);
            return this.current_row_index != this.result.getResultSize();
        }
        catch (Exception e) {
            throw new tinySQLException(e.getMessage(), e);
        }
    }

    public void close() throws SQLException {
        this.result.close();
        if (this.statement != null) {
            this.statement.onCloseResultSet(this);
        }
    }

    public boolean wasNull() throws SQLException {
        return false;
    }

    public String getString(int column) throws SQLException {
        try {
            Object o = this.getObject(column);
            return ParserUtils.convertToString(o);
        }
        catch (Exception e) {
            throw new tinySQLException("Error in getString ():", e);
        }
    }

    public byte getByte(int column) throws SQLException {
        try {
            Object o = this.getObject(column);
            if (o == null) {
                return 0;
            }
            BigDecimal n = ParserUtils.convertToNumber(o);
            if (n == null) {
                return 0;
            }
            return n.byteValue();
        }
        catch (Exception e) {
            throw new tinySQLException("Unable to convert to byte", e);
        }
    }

    public boolean getBoolean(int column) throws SQLException {
        try {
            Object o = this.getObject(column);
            Boolean b = ParserUtils.convertToBoolean(o);
            return b;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    public short getShort(int column) throws SQLException {
        try {
            Object o = this.getObject(column);
            if (o == null) {
                return 0;
            }
            BigDecimal n = ParserUtils.convertToNumber(o);
            if (n == null) {
                return 0;
            }
            return n.shortValue();
        }
        catch (Exception e) {
            throw new tinySQLException("Unable to convert to short", e);
        }
    }

    public int getInt(int column) throws SQLException {
        try {
            Object o = this.getObject(column);
            if (o == null) {
                return 0;
            }
            BigDecimal n = ParserUtils.convertToNumber(o);
            if (n == null) {
                return 0;
            }
            return ((Number)n).intValue();
        }
        catch (Exception e) {
            throw new tinySQLException("Unable to convert to integer", e);
        }
    }

    public long getLong(int column) throws SQLException {
        try {
            Object o = this.getObject(column);
            if (o == null) {
                return 0L;
            }
            BigDecimal n = ParserUtils.convertToNumber(o);
            if (n == null) {
                return 0L;
            }
            return ((Number)n).longValue();
        }
        catch (Exception e) {
            throw new tinySQLException("Unable to convert to long", e);
        }
    }

    public float getFloat(int column) throws SQLException {
        try {
            Object o = this.getObject(column);
            if (o == null) {
                return 0.0f;
            }
            BigDecimal n = ParserUtils.convertToNumber(o);
            if (n == null) {
                return 0.0f;
            }
            return ((Number)n).floatValue();
        }
        catch (Exception e) {
            throw new tinySQLException("Unable to convert to float", e);
        }
    }

    public double getDouble(int column) throws SQLException {
        try {
            Object o = this.getObject(column);
            if (o == null) {
                return 0.0;
            }
            BigDecimal n = ParserUtils.convertToNumber(o);
            if (n == null) {
                return 0.0;
            }
            return ((Number)n).doubleValue();
        }
        catch (Exception e) {
            throw new tinySQLException("Unable to convert to double", e);
        }
    }

    public BigDecimal getBigDecimal(int column, int scale) throws SQLException {
        try {
            Object o = this.getObject(column);
            if (o == null) {
                return null;
            }
            BigDecimal n = ParserUtils.convertToNumber(o);
            if (n == null) {
                return null;
            }
            return n.setScale(scale);
        }
        catch (Exception e) {
            throw new tinySQLException("Unable to convert to BigDecimal", e);
        }
    }

    public byte[] getBytes(int column) throws SQLException {
        String str = this.getString(column);
        if (str == null) {
            return null;
        }
        try {
            return str.getBytes(str);
        }
        catch (UnsupportedEncodingException e) {
            throw new tinySQLException("Bad bytes!: ", e);
        }
    }

    public Date getDate(int column) throws SQLException {
        Object o = this.getObject(column);
        if (o == null) {
            return null;
        }
        Date date = ParserUtils.convertToDate(o);
        if (date == null) {
            return null;
        }
        return date;
    }

    public Time getTime(int column) throws SQLException {
        Object o = this.getObject(column);
        if (o == null) {
            return null;
        }
        Time date = ParserUtils.convertToTime(o);
        if (date == null) {
            return null;
        }
        return date;
    }

    public Timestamp getTimestamp(int column) throws SQLException {
        Object o = this.getObject(column);
        if (o == null) {
            return null;
        }
        Timestamp date = ParserUtils.convertToTimestamp(o);
        if (date == null) {
            return null;
        }
        return date;
    }

    public InputStream getAsciiStream(int column) throws SQLException {
        return null;
    }

    public InputStream getUnicodeStream(int column) throws SQLException {
        return null;
    }

    public InputStream getBinaryStream(int column) throws SQLException {
        return null;
    }

    public String getCursorName() throws SQLException {
        return "";
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.meta == null) {
            this.meta = new tinySQLResultSetMetaData(this.result);
        }
        return this.meta;
    }

    public Object getObject(int column, int type, int scale) throws SQLException {
        switch (type) {
            case -7: {
                return new Boolean(this.getBoolean(column));
            }
            case -6: {
                return new Character((char)this.getInt(column));
            }
            case 5: {
                return new Integer(this.getShort(column));
            }
            case 4: {
                return new Integer(this.getInt(column));
            }
            case -5: {
                return new Long(this.getLong(column));
            }
            case 6: {
                return new Float(this.getFloat(column));
            }
            case 7: {
                return new Float(this.getFloat(column));
            }
            case 8: {
                return new Double(this.getDouble(column));
            }
            case 2: {
                return this.getBigDecimal(column, scale);
            }
            case 3: {
                return this.getBigDecimal(column, scale);
            }
            case 1: {
                return this.getString(column);
            }
            case 12: {
                return this.getString(column);
            }
            case -1: {
                return this.getString(column);
            }
            case 91: {
                return this.getDate(column);
            }
            case 92: {
                return this.getTime(column);
            }
            case 93: {
                return this.getTimestamp(column);
            }
            case -2: {
                return this.getBytes(column);
            }
            case -3: {
                return this.getBytes(column);
            }
            case -4: {
                return this.getBytes(column);
            }
        }
        return null;
    }

    public Object getObject(int column, int type) throws SQLException {
        return this.getObject(column, type, 0);
    }

    public Object getObject(int column) throws SQLException {
        return this.current_row.get(column - 1);
    }

    public String getString(String name) throws SQLException {
        String retval = this.getString(this.findColumn(name));
        return retval;
    }

    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    public Object getObject(String columnName, int sqlType, int scale) throws SQLException {
        return this.getObject(this.findColumn(columnName), sqlType, scale);
    }

    public Object getObject(String columnName, int type) throws SQLException {
        return this.getObject(this.findColumn(columnName), type, 0);
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    public int findColumn(String name) throws SQLException {
        return this.result.findColumn(name) + 1;
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return null;
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return null;
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        try {
            Object o = this.getObject(columnIndex);
            if (o == null) {
                return null;
            }
            BigDecimal n = ParserUtils.convertToNumber(o);
            if (n == null) {
                return null;
            }
            return n;
        }
        catch (Exception e) {
            throw new tinySQLException("Unable to convert to BigDecimal", e);
        }
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.current_row_index == -1;
    }

    public boolean isAfterLast() throws SQLException {
        if (this.current_row_index < 0) {
            return false;
        }
        return this.current_row_index == this.result.getResultSize();
    }

    public boolean isFirst() throws SQLException {
        if (this.current_row_index < 0) {
            return false;
        }
        return this.current_row_index == 0 && this.result.getResultSize() != 0;
    }

    public boolean isLast() throws SQLException {
        return false;
    }

    public void beforeFirst() throws SQLException {
    }

    public void afterLast() throws SQLException {
    }

    public boolean first() throws SQLException {
        return false;
    }

    public boolean last() throws SQLException {
        return false;
    }

    public int getRow() throws SQLException {
        return 0;
    }

    public boolean absolute(int row) throws SQLException {
        return false;
    }

    public boolean relative(int rows) throws SQLException {
        return false;
    }

    public boolean previous() throws SQLException {
        return false;
    }

    public void setFetchDirection(int direction) throws SQLException {
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public void setFetchSize(int rows) throws SQLException {
        if (rows <= 0) {
            throw new SQLException("Condition 0 <= rows <= this.getMaxRows() is not satisfied");
        }
        this.result.setFetchSize(rows);
    }

    public int getFetchSize() throws SQLException {
        return this.result.getFetchSize();
    }

    public int getType() throws SQLException {
        return this.result.getType();
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public void updateNull(int columnIndex) throws SQLException {
        throw new SQLException("tinySQL does not support updateNull.");
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new SQLException("tinySQL does not support updateBoolean.");
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new SQLException("tinySQL does not support updateByte.");
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new SQLException("tinySQL does not support updateShort.");
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new SQLException("tinySQL does not support updateInt.");
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new SQLException("tinySQL does not support updateLong.");
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new SQLException("tinySQL does not support updateFloat.");
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new SQLException("tinySQL does not support updateDouble.");
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new SQLException("tinySQL does not support updateBigDecimal.");
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        throw new SQLException("tinySQL does not support updateString.");
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new SQLException("tinySQL does not support updateBytes.");
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new SQLException("tinySQL does not support updateDate.");
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new SQLException("tinySQL does not support updateTime.");
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new SQLException("tinySQL does not support updateTimestamp.");
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("tinySQL does not support updateAsciiStream.");
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("tinySQL does not support updateBinaryStream.");
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new SQLException("tinySQL does not support updateCharacterStream.");
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw new SQLException("tinySQL does not support updateObject.");
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new SQLException("tinySQL does not support updateObject.");
    }

    public void updateNull(String columnName) throws SQLException {
        throw new SQLException("tinySQL does not support updateNull.");
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        throw new SQLException("tinySQL does not support updateBoolean.");
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        throw new SQLException("tinySQL does not support updateByte.");
    }

    public void updateShort(String columnName, short x) throws SQLException {
        throw new SQLException("tinySQL does not support updateShort.");
    }

    public void updateInt(String columnName, int x) throws SQLException {
        throw new SQLException("tinySQL does not support updateInt.");
    }

    public void updateLong(String columnName, long x) throws SQLException {
        throw new SQLException("tinySQL does not support updateLong.");
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        throw new SQLException("tinySQL does not support updateFloat.");
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        throw new SQLException("tinySQL does not support updateDouble.");
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        throw new SQLException("tinySQL does not support updateDecimal.");
    }

    public void updateString(String columnName, String x) throws SQLException {
        throw new SQLException("tinySQL does not support updateString.");
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        throw new SQLException("tinySQL does not support updateBytes.");
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        throw new SQLException("tinySQL does not support updateDate.");
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        throw new SQLException("tinySQL does not support updateTime.");
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        throw new SQLException("tinySQL does not support updateTimestamp.");
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw new SQLException("tinySQL does not support updateAsciiStream.");
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        throw new SQLException("tinySQL does not support updateBinaryStream.");
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        throw new SQLException("tinySQL does not support updateCharacter.");
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        throw new SQLException("tinySQL does not support updateObject.");
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        throw new SQLException("tinySQL does not support updateObject.");
    }

    public void insertRow() throws SQLException {
        throw new SQLException("tinySQL does not support insertRow.");
    }

    public void updateRow() throws SQLException {
        throw new SQLException("tinySQL does not support updateRow.");
    }

    public void deleteRow() throws SQLException {
        throw new SQLException("tinySQL does not support deleteRow.");
    }

    public void refreshRow() throws SQLException {
        throw new SQLException("tinySQL does not support RefreshRow.");
    }

    public void cancelRowUpdates() throws SQLException {
        throw new SQLException("tinySQL does not support cancelRowUpdate.");
    }

    public void moveToInsertRow() throws SQLException {
        throw new SQLException("tinySQL does not support moveToInsertRow.");
    }

    public void moveToCurrentRow() throws SQLException {
        throw new SQLException("tinySQL does not support moveToCurrentRow.");
    }

    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    public Object getObject(int i, Map map) throws SQLException {
        throw new SQLException("tinySQL does not support getObject.");
    }

    public Ref getRef(int i) throws SQLException {
        throw new SQLException("tinySQL does not support getRef.");
    }

    public Blob getBlob(int i) throws SQLException {
        throw new SQLException("tinySQL does not support getBlob.");
    }

    public Clob getClob(int i) throws SQLException {
        throw new SQLException("tinySQL does not support getClob.");
    }

    public Array getArray(int i) throws SQLException {
        throw new SQLException("tinySQL does not support getArray.");
    }

    public Object getObject(String colName, Map map) throws SQLException {
        throw new SQLException("tinySQL does not support getObject.");
    }

    public Ref getRef(String colName) throws SQLException {
        throw new SQLException("tinySQL does not support getRef.");
    }

    public Blob getBlob(String colName) throws SQLException {
        throw new SQLException("tinySQL does not support getBlob.");
    }

    public Clob getClob(String colName) throws SQLException {
        throw new SQLException("tinySQL does not support getClob.");
    }

    public Array getArray(String colName) throws SQLException {
        throw new SQLException("tinySQL does not support getArray.");
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException("tinySQL does not support getDate.");
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        throw new SQLException("tinySQL does not support getDate.");
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException("tinySQL does not support getTime.");
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        throw new SQLException("tinySQL does not support getTime.");
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException("tinySQL does not support getTimestamp.");
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        throw new SQLException("tinySQL does not support getTimestamp.");
    }
}

