/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL;

import ORG.as220.tinySQL.sqlparser.SQLStatement;
import ORG.as220.tinySQL.sqlparser.SQLStatementBatch;
import ORG.as220.tinySQL.tinySQLConnection;
import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tinySQLResultSet;
import ORG.as220.tinySQL.util.Log;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Vector;

public class tinySQLStatement
implements Statement {
    private SQLStatement statement;
    private Vector results;
    private tinySQLConnection connection;
    private tinySQLResultSet result;
    private int max_field_size = 0;
    private int max_rows = 0;
    private int timeout = 0;
    private int fetchsize = 2048;
    private int defaultResultSetType = 1004;
    private int defaultDirection = 1002;
    private SQLStatementBatch batch;

    public tinySQLStatement(tinySQLConnection conn) {
        this.connection = conn;
        this.results = new Vector();
        this.batch = new SQLStatementBatch(this);
    }

    public synchronized ResultSet executeQuery(String sql) throws SQLException {
        boolean result = this.execute(sql);
        if (result) {
            return this.getResultSet();
        }
        throw new tinySQLException("Statement returned an UpdateCount\n" + sql);
    }

    public synchronized int executeUpdate(String sql) throws SQLException {
        boolean result = this.execute(sql);
        if (!result) {
            return this.getUpdateCount();
        }
        throw new tinySQLException("Statement returned a ResultSet");
    }

    public synchronized boolean execute(String sql) throws SQLException {
        this.statement = this.connection.getDatabaseEngine().parse(this, sql);
        boolean result = this.statement.execute();
        return result;
    }

    public void close() throws SQLException {
        Vector v = new Vector(this.results);
        int i = 0;
        while (i < v.size()) {
            tinySQLResultSet res = (tinySQLResultSet)v.elementAt(i);
            res.close();
            ++i;
        }
    }

    public ResultSet getResultSet() throws SQLException {
        return this.statement.getResultSet();
    }

    public void onCreateResultSet(tinySQLResultSet result) {
        Log.debug("Statement: ResultSet opened");
        this.results.add(result);
    }

    public void onCloseResultSet(tinySQLResultSet result) {
        Log.debug("Statement: ResultSet close");
        this.results.remove(result);
    }

    public int getUpdateCount() throws SQLException {
        return this.statement.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        return this.statement.getMoreResults();
    }

    public int getMaxFieldSize() throws SQLException {
        return this.max_field_size;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.max_field_size = max;
    }

    public int getMaxRows() throws SQLException {
        return this.max_rows;
    }

    public void setMaxRows(int max) throws SQLException {
        this.max_rows = max;
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    public int getQueryTimeout() throws SQLException {
        return this.timeout;
    }

    public void setQueryTimeout(int x) throws SQLException {
        this.timeout = x;
    }

    public void cancel() {
    }

    public final SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public void setCursorName(String unused) throws SQLException {
        throw new SQLException("tinySQL does not support cursors.");
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.defaultDirection = direction;
    }

    public int getFetchDirection() throws SQLException {
        return this.defaultDirection;
    }

    public void setFetchSize(int rows) throws SQLException {
        if (rows <= 0 || rows >= this.getMaxRows()) {
            throw new SQLException("Condition 0 <= rows <= this.getMaxRows() is not satisfied");
        }
        this.fetchsize = rows;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchsize;
    }

    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    public int getResultSetType() throws SQLException {
        return this.defaultResultSetType;
    }

    public void setDefaultResultSetType(int type) {
        this.defaultResultSetType = type;
    }

    public void addBatch(String sql) throws SQLException {
        this.statement = this.connection.getDatabaseEngine().parse(this, sql);
        Vector params = this.statement.getParameters();
        if (params.size() != 0) {
            throw new tinySQLException("Parameterized statements are not supported, use PreparedStatement for Parameters");
        }
        this.addBatch(this.statement);
    }

    protected void addBatch(SQLStatement sql) throws SQLException {
        this.batch.add(sql);
    }

    public void clearBatch() throws SQLException {
        this.batch.clear();
    }

    public int[] executeBatch() throws SQLException {
        return this.batch.executeAll();
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    protected SQLStatement getStatement() {
        return this.statement;
    }

    protected void setStatement(SQLStatement statement) {
        this.statement = statement;
    }
}

