/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL;

import ORG.as220.tinySQL.tinySQLConverter;
import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tinySQLTableView;
import ORG.as220.tinySQL.tsColumn;
import ORG.as220.tinySQL.tsRawRow;
import ORG.as220.tinySQL.util.Log;
import java.util.Enumeration;
import java.util.Vector;

public abstract class tinySQLTable {
    private String table;
    private tinySQLConverter converter = null;
    private Vector views;

    public tinySQLTable(String tablename) {
        this.table = tablename;
        this.views = new Vector();
    }

    public String getName() {
        return this.table;
    }

    public void createdView(tinySQLTableView view) throws tinySQLException {
        this.views.addElement(view);
    }

    public void removedView(tinySQLTableView view) {
        this.views.removeElement(view);
        Log.warn("Table " + this.getName() + ": Open Views left: " + this.views.size());
    }

    public Enumeration getViews() {
        Vector v = new Vector(this.views);
        return v.elements();
    }

    public int getViewCount() {
        return this.views.size();
    }

    public tinySQLConverter getConverter() throws tinySQLException {
        if (this.converter == null) {
            this.converter = new tinySQLConverter();
        }
        return this.converter;
    }

    public abstract boolean close() throws tinySQLException;

    public abstract tsColumn getColumnDefinition(int var1);

    public abstract int getColumnCount();

    public abstract int getRowCount();

    public abstract void updateRow(int var1, tsRawRow var2) throws tinySQLException;

    public abstract tsRawRow getRow(int var1) throws tinySQLException;

    public abstract int insertRow(tsRawRow var1) throws tinySQLException;

    public abstract void deleteRow(int var1) throws tinySQLException;

    public abstract boolean isDeleted(int var1) throws tinySQLException;

    public boolean isReadOnly() {
        return false;
    }

    public abstract tsRawRow getInsertRow() throws tinySQLException;

    public tsRawRow getUpdateRow(int row) throws tinySQLException {
        return this.getRow(row);
    }
}

