/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL;

import ORG.as220.tinySQL.tinySQLDefaultIndex;
import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tinySQLIndex;
import ORG.as220.tinySQL.tinySQLTable;
import ORG.as220.tinySQL.tsColumn;
import ORG.as220.tinySQL.tsRawRow;
import ORG.as220.tinySQL.tsRow;
import ORG.as220.tinySQL.util.Log;
import java.util.Hashtable;

public class tinySQLTableView {
    private Hashtable colcache;
    private tinySQLTable table;
    private int _currentRowNumber;
    private tsRawRow _currentRow;
    private String alias;
    private tsColumn[] tsColumnCache;
    private boolean isClosed;
    private tinySQLIndex index;

    public tinySQLTableView(tinySQLTable table) throws tinySQLException {
        this(table, table.getName());
    }

    public tinySQLTableView(tinySQLTable table, String alias) throws tinySQLException {
        if (table == null) {
            throw new tinySQLException("No table?");
        }
        this.index = new tinySQLDefaultIndex();
        this.table = table;
        table.createdView(this);
        this.alias = alias;
        this.colcache = new Hashtable();
        this._currentRowNumber = -1;
    }

    public void close() throws tinySQLException {
        if (this.isClosed) {
            throw new tinySQLException("table is closed");
        }
        this.table.removedView(this);
        this.isClosed = true;
    }

    public String getColumnName(int col) {
        tsColumn coldef = this.getColumnDefinition(col);
        return coldef.getPhysicalName();
    }

    public int findColumn(String name) {
        Integer integ = (Integer)this.colcache.get(name);
        if (integ != null) {
            return integ;
        }
        int size = this.getColumnCount();
        int i = 0;
        while (i < size) {
            tsColumn column = this.getColumnDefinition(i);
            if (column.isValidName(name)) {
                this.colcache.put(name, new Integer(i));
                return i;
            }
            ++i;
        }
        Log.error("Column : " + name + " not found in this table");
        return -1;
    }

    public boolean isDeleted() throws tinySQLException {
        if (this.isClosed) {
            throw new tinySQLException("table is closed");
        }
        return this.table.isDeleted(this._currentRowNumber);
    }

    public void updateRow(tsRow data) throws tinySQLException {
        if (this.isClosed) {
            throw new tinySQLException("table is closed");
        }
        int physrow = this.index.reverseTranslation(this._currentRowNumber);
        this.table.updateRow(physrow, this.convertRowToNative(data, this._currentRow));
        this.loadRow(this._currentRowNumber);
    }

    public void insertRow(tsRow data) throws tinySQLException {
        if (this.isClosed) {
            throw new tinySQLException("table is closed");
        }
        int row = this.table.insertRow(this.convertRowToNative(data, this.table.getInsertRow()));
        this.loadRow(row);
    }

    public tsRawRow convertRowToNative(tsRow row, tsRawRow raw) throws tinySQLException {
        int size = row.size();
        int i = 0;
        while (i < size) {
            tsColumn col = row.getColumnDefinition(i);
            int idx = raw.findColumn(col.getPhysicalName());
            if (idx != -1) {
                raw.put(idx, row.get(i));
            } else {
                idx = raw.findColumn(col.getDisplayName());
                if (idx == -1) {
                    throw new tinySQLException("Column : " + col);
                }
                raw.put(idx, row.get(i));
            }
            ++i;
        }
        return raw;
    }

    public tsColumn getColumnDefinition(int column) {
        if (this.tsColumnCache == null) {
            this.tsColumnCache = new tsColumn[this.table.getColumnCount()];
        }
        if (this.tsColumnCache[column] == null) {
            tsColumn retval;
            this.tsColumnCache[column] = retval = new tsColumn(this, this.table.getColumnDefinition(column));
        }
        return this.tsColumnCache[column];
    }

    public String getName() {
        return this.table.getName();
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        if (alias == null) {
            throw new NullPointerException("Alias may not be null");
        }
        this.alias = alias;
    }

    private void setCurrentRow(int rcdn, tsRawRow row) {
        this._currentRow = row;
        this._currentRowNumber = rcdn;
    }

    public boolean next() throws tinySQLException {
        return this.loadRow(this._currentRowNumber + 1);
    }

    public boolean nextNonDeleted() throws tinySQLException {
        int currentRowNumber = this._currentRowNumber;
        boolean result = false;
        while (!result) {
            if (++currentRowNumber < this.getRowCount()) {
                result = !this.table.isDeleted(currentRowNumber);
                continue;
            }
            return false;
        }
        return this.loadRow(currentRowNumber);
    }

    public boolean refresh() throws tinySQLException {
        return this.loadRow(this._currentRowNumber);
    }

    protected boolean loadRow(int rowNumber) throws tinySQLException {
        if (this.isClosed) {
            throw new tinySQLException("table is closed");
        }
        tsRawRow row = this.table.getRow(this.index.translateRow(rowNumber));
        this.setCurrentRow(rowNumber, row);
        return row != null;
    }

    public boolean beforeFirst() throws tinySQLException {
        if (this.isClosed) {
            throw new tinySQLException("table is closed");
        }
        this.setCurrentRow(-1, null);
        return this.table.getRowCount() > 0;
    }

    public boolean isBeforeFirst() throws tinySQLException {
        if (this.isClosed) {
            throw new tinySQLException("table is closed");
        }
        return this._currentRowNumber == -1;
    }

    public boolean absolute(int row) throws tinySQLException {
        if (this.isClosed) {
            throw new tinySQLException("table is closed");
        }
        if (row < 0) {
            row = this.table.getRowCount() - row;
            if (row < 0) {
                return this.beforeFirst();
            }
        } else if (row > this.table.getRowCount()) {
            return this.afterLast();
        }
        return this.loadRow(row);
    }

    public boolean relative(int row) throws tinySQLException {
        return this.absolute(this._currentRowNumber + row);
    }

    public boolean last() throws tinySQLException {
        return this.loadRow(this.getRowCount() - 1);
    }

    public boolean afterLast() throws tinySQLException {
        this.setCurrentRow(this.table.getRowCount(), null);
        return false;
    }

    public int getColumnCount() {
        return this.table.getColumnCount();
    }

    public int getRowCount() throws tinySQLException {
        if (this.isClosed) {
            throw new tinySQLException("table is closed");
        }
        return this.table.getRowCount();
    }

    public Object getColumn(int col) throws tinySQLException {
        if (this.isClosed) {
            throw new tinySQLException("table is closed");
        }
        return this._currentRow.get(col);
    }

    public final Object getColumn(String col) throws tinySQLException {
        if (this.isClosed) {
            throw new tinySQLException("table is closed");
        }
        if (this._currentRow == null) {
            throw new tinySQLException("No such row or not initialized: " + this._currentRowNumber);
        }
        return this.getColumn(this.findColumn(col));
    }

    public int getCurrentRecordNumber() throws tinySQLException {
        if (this.isClosed) {
            throw new tinySQLException("table is closed");
        }
        return this._currentRowNumber;
    }

    public boolean isReadOnly() throws tinySQLException {
        if (this.isClosed) {
            throw new tinySQLException("table is closed");
        }
        return this.table.isReadOnly();
    }

    public void deleteRow() throws tinySQLException {
        if (this.isClosed) {
            throw new tinySQLException("table is closed");
        }
        this.table.deleteRow(this._currentRowNumber);
    }

    public boolean equals(Object o) {
        if (o instanceof tinySQLTableView) {
            tinySQLTableView vTable = (tinySQLTableView)o;
            String name = this.getName();
            if (name.equals(vTable.getName()) || name.equals(vTable.getAlias())) {
                return true;
            }
            name = this.getAlias();
            if (name.equals(vTable.getName()) || name.equals(vTable.getAlias())) {
                return true;
            }
        }
        return false;
    }

    public void setIndex(tinySQLIndex index) {
        this.index = index;
    }

    public tinySQLIndex getIndex() {
        return this.index;
    }
}

