/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL;

import ORG.as220.tinySQL.DBFHeader;
import ORG.as220.tinySQL.tinySQL;
import ORG.as220.tinySQL.tinySQLConnection;
import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tinySQLResultSet;
import ORG.as220.tinySQL.tinySQLTableView;
import ORG.as220.tinySQL.tsColumn;
import ORG.as220.tinySQL.tsPhysicalRow;
import ORG.as220.tinySQL.tsResultSet;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public abstract class tinySqlDatabaseMetaData
implements DatabaseMetaData {
    private tinySQLConnection connection = null;

    public tinySqlDatabaseMetaData(tinySQLConnection connection) {
        this.connection = connection;
    }

    public boolean allProceduresAreCallable() {
        return false;
    }

    public boolean allTablesAreSelectable() {
        return true;
    }

    public String getURL() {
        return this.connection.getUrl();
    }

    public String getUserName() {
        return this.connection.getUser();
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean nullsAreSortedHigh() {
        return false;
    }

    public boolean nullsAreSortedLow() {
        return !this.nullsAreSortedHigh();
    }

    public boolean nullsAreSortedAtStart() {
        return false;
    }

    public boolean nullsAreSortedAtEnd() {
        return false;
    }

    public String getDatabaseProductName() {
        return "tinySQL";
    }

    public String getDatabaseProductVersion() {
        return "(generic base implementation)";
    }

    public String getDriverName() {
        return "ORG.as220.tinySQL.dbfFileDriver";
    }

    public String getDriverVersion() {
        return "0.71 Alpha";
    }

    public int getDriverMajorVersion() {
        return 0;
    }

    public int getDriverMinorVersion() {
        return 7;
    }

    public boolean usesLocalFiles() {
        return true;
    }

    public boolean usesLocalFilePerTable() {
        return true;
    }

    public boolean supportsMixedCaseIdentifiers() {
        return true;
    }

    public boolean storesUpperCaseIdentifiers() {
        return false;
    }

    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() {
        return true;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() {
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() {
        return false;
    }

    public String getIdentifierQuoteString() {
        return "\"";
    }

    public String getSQLKeywords() {
        return "";
    }

    public String getNumericFunctions() {
        return "";
    }

    public String getStringFunctions() {
        return "";
    }

    public String getSystemFunctions() {
        return "";
    }

    public String getTimeDateFunctions() {
        return "";
    }

    public String getSearchStringEscape() {
        return "\\";
    }

    public String getExtraNameCharacters() {
        return "$";
    }

    public boolean supportsAlterTableWithAddColumn() {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() {
        return true;
    }

    public boolean supportsColumnAliasing() {
        return true;
    }

    public boolean nullPlusNonNullIsNull() {
        return true;
    }

    public boolean supportsConvert() {
        return false;
    }

    public boolean supportsConvert(int fromType, int toType) {
        return false;
    }

    public boolean supportsTableCorrelationNames() {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() {
        return false;
    }

    public boolean supportsExpressionsInOrderBy() {
        return false;
    }

    public boolean supportsOrderByUnrelated() {
        return false;
    }

    public boolean supportsGroupBy() {
        return false;
    }

    public boolean supportsGroupByUnrelated() {
        return false;
    }

    public boolean supportsGroupByBeyondSelect() {
        return false;
    }

    public boolean supportsLikeEscapeClause() {
        return false;
    }

    public boolean supportsMultipleResultSets() {
        return false;
    }

    public boolean supportsMultipleTransactions() {
        return false;
    }

    public boolean supportsNonNullableColumns() {
        return false;
    }

    public boolean supportsMinimumSQLGrammar() {
        return true;
    }

    public boolean supportsCoreSQLGrammar() {
        return false;
    }

    public boolean supportsExtendedSQLGrammar() {
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() {
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() {
        return false;
    }

    public boolean supportsANSI92FullSQL() {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() {
        return false;
    }

    public boolean supportsOuterJoins() {
        return false;
    }

    public boolean supportsFullOuterJoins() {
        return false;
    }

    public boolean supportsLimitedOuterJoins() {
        return false;
    }

    public String getSchemaTerm() throws SQLException {
        throw new SQLException("tinySQL does not support schema term.");
    }

    public String getProcedureTerm() throws SQLException {
        throw new SQLException("tinySQL does not support procedure.");
    }

    public String getCatalogTerm() throws SQLException {
        throw new SQLException("tinySQL does not support catalog.");
    }

    public boolean isCatalogAtStart() {
        return false;
    }

    public String getCatalogSeparator() throws SQLException {
        throw new SQLException("tinySQL does not catalog.");
    }

    public boolean supportsSchemasInDataManipulation() {
        return false;
    }

    public boolean supportsSchemasInProcedureCalls() {
        return false;
    }

    public boolean supportsSchemasInTableDefinitions() {
        return false;
    }

    public boolean supportsSchemasInIndexDefinitions() {
        return false;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() {
        return false;
    }

    public boolean supportsCatalogsInDataManipulation() {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    public boolean supportsPositionedDelete() {
        return false;
    }

    public boolean supportsPositionedUpdate() {
        return false;
    }

    public boolean supportsSelectForUpdate() {
        return false;
    }

    public boolean supportsStoredProcedures() {
        return false;
    }

    public boolean supportsSubqueriesInComparisons() {
        return false;
    }

    public boolean supportsSubqueriesInExists() {
        return false;
    }

    public boolean supportsSubqueriesInIns() {
        return false;
    }

    public boolean supportsSubqueriesInQuantifieds() {
        return false;
    }

    public boolean supportsCorrelatedSubqueries() {
        return false;
    }

    public boolean supportsUnion() {
        return false;
    }

    public boolean supportsUnionAll() {
        return false;
    }

    public boolean supportsOpenCursorsAcrossCommit() {
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() {
        return false;
    }

    public boolean supportsOpenStatementsAcrossRollback() {
        return false;
    }

    public int getMaxBinaryLiteralLength() {
        return 0;
    }

    public int getMaxCharLiteralLength() {
        return 0;
    }

    public int getMaxColumnNameLength() {
        return 0;
    }

    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    public int getMaxColumnsInIndex() {
        return 0;
    }

    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    public int getMaxColumnsInSelect() {
        return 0;
    }

    public int getMaxColumnsInTable() {
        return 0;
    }

    public int getMaxConnections() {
        return 0;
    }

    public int getMaxCursorNameLength() {
        return 0;
    }

    public int getMaxIndexLength() {
        return 0;
    }

    public int getMaxSchemaNameLength() {
        return 0;
    }

    public int getMaxProcedureNameLength() {
        return 0;
    }

    public int getMaxCatalogNameLength() {
        return 0;
    }

    public int getMaxRowSize() {
        return 0;
    }

    public boolean doesMaxRowSizeIncludeBlobs() {
        return false;
    }

    public int getMaxStatementLength() {
        return 0;
    }

    public int getMaxStatements() {
        return 0;
    }

    public int getMaxTableNameLength() {
        return 0;
    }

    public int getMaxTablesInSelect() {
        return 0;
    }

    public int getMaxUserNameLength() {
        return 0;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    public boolean supportsTransactions() {
        return false;
    }

    public boolean supportsTransactionIsolationLevel(int level) {
        return false;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return false;
    }

    public boolean supportsDataManipulationTransactionsOnly() {
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) {
        Vector<tsColumn> columns = new Vector<tsColumn>();
        tsColumn jsc = new tsColumn("PROCEDURE_CAT");
        jsc.setType(1);
        jsc.setDefaultValue("");
        jsc.setSize(10);
        columns.addElement(jsc);
        jsc = new tsColumn("PROCEDURE_SCHEM");
        jsc.setType(1);
        jsc.setDefaultValue("");
        jsc.setSize(10);
        columns.addElement(jsc);
        jsc = new tsColumn("PROCEDURE_NAME");
        jsc.setType(1);
        jsc.setDefaultValue("");
        jsc.setSize(10);
        columns.addElement(jsc);
        jsc = new tsColumn("RESERVED1");
        jsc.setType(1);
        jsc.setDefaultValue("");
        jsc.setSize(10);
        columns.addElement(jsc);
        jsc = new tsColumn("RESERVED2");
        jsc.setType(1);
        jsc.setDefaultValue("");
        jsc.setSize(10);
        columns.addElement(jsc);
        jsc = new tsColumn("RESERVED3");
        jsc.setType(1);
        jsc.setDefaultValue("");
        jsc.setSize(10);
        columns.addElement(jsc);
        jsc = new tsColumn("REMARKS");
        jsc.setType(1);
        jsc.setDefaultValue("");
        jsc.setSize(10);
        columns.addElement(jsc);
        jsc = new tsColumn("PROCEDURE_TYPE");
        jsc.setType(1);
        jsc.setDefaultValue("");
        jsc.setSize(10);
        columns.addElement(jsc);
        tsPhysicalRow row = new tsPhysicalRow(columns);
        tsResultSet res = new tsResultSet(row);
        return new tinySQLResultSet(res, null);
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) {
        Vector<tsColumn> columns = new Vector<tsColumn>();
        tsColumn jsc = new tsColumn("PROCEDURE_CAT");
        jsc.setType(1);
        jsc.setDefaultValue("");
        jsc.setSize(10);
        columns.addElement(jsc);
        jsc = new tsColumn("PROCEDURE_SCHEM");
        jsc.setType(1);
        jsc.setDefaultValue("");
        jsc.setSize(10);
        columns.addElement(jsc);
        jsc = new tsColumn("PROCEDURE_NAME");
        jsc.setType(1);
        jsc.setDefaultValue("");
        jsc.setSize(10);
        columns.addElement(jsc);
        jsc = new tsColumn("COLUMN_NAME");
        jsc.setType(1);
        jsc.setDefaultValue("");
        jsc.setSize(10);
        columns.addElement(jsc);
        jsc = new tsColumn("COLUMN_TYPE");
        jsc.setType(5);
        jsc.setDefaultValue("");
        jsc.setSize(10);
        columns.addElement(jsc);
        jsc = new tsColumn("DATA_TYPE");
        jsc.setType(5);
        jsc.setDefaultValue("");
        jsc.setSize(10);
        columns.addElement(jsc);
        jsc = new tsColumn("TYPE_NAME");
        jsc.setType(1);
        jsc.setDefaultValue("");
        jsc.setSize(10);
        columns.addElement(jsc);
        jsc = new tsColumn("PRECISION");
        jsc.setType(4);
        jsc.setDefaultValue("");
        jsc.setSize(10);
        columns.addElement(jsc);
        jsc = new tsColumn("LENGTH");
        jsc.setType(4);
        jsc.setDefaultValue("");
        jsc.setSize(10);
        columns.addElement(jsc);
        jsc = new tsColumn("SCALE");
        jsc.setType(5);
        jsc.setDefaultValue("");
        jsc.setSize(10);
        columns.addElement(jsc);
        jsc = new tsColumn("RADIX");
        jsc.setType(5);
        jsc.setDefaultValue("");
        jsc.setSize(10);
        columns.addElement(jsc);
        jsc = new tsColumn("NULLABLE");
        jsc.setType(5);
        jsc.setDefaultValue("");
        jsc.setSize(10);
        columns.addElement(jsc);
        jsc = new tsColumn("REMARKS");
        jsc.setType(1);
        jsc.setDefaultValue("");
        jsc.setSize(10);
        columns.addElement(jsc);
        tsPhysicalRow row = new tsPhysicalRow(columns);
        tsResultSet res = new tsResultSet(row);
        return new tinySQLResultSet(res, null);
    }

    public abstract ResultSet getTables(String var1, String var2, String var3, String[] var4) throws tinySQLException;

    public ResultSet getSchemas() throws SQLException {
        throw new SQLException("tinySQL does not support schemas.");
    }

    public ResultSet getCatalogs() throws SQLException {
        throw new SQLException("tinySQL does not support catalogues.");
    }

    public ResultSet getTableTypes() throws SQLException {
        Vector<tsColumn> columns = new Vector<tsColumn>();
        tsColumn jsc = new tsColumn("TABLE_TYPE");
        jsc.setType(1);
        jsc.setDefaultValue("");
        jsc.setSize(10);
        columns.addElement(jsc);
        tsPhysicalRow row = new tsPhysicalRow(columns);
        tsResultSet res = new tsResultSet(row);
        row = res.createPhysicalRow();
        row.put(0, "TABLE");
        res.addPhysicalRow(row);
        return new tinySQLResultSet(res, null);
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) {
        try {
            ResultSet tableRs = this.getTables(catalog, schemaPattern, tableNamePattern, null);
            Vector<tsColumn> columns = new Vector<tsColumn>();
            tsColumn jsc = new tsColumn("TABLE_CAT");
            jsc.setType(1);
            jsc.setSize(9);
            jsc.setDefaultValue("");
            columns.addElement(jsc);
            jsc = new tsColumn("TABLE_SCHEM");
            jsc.setType(1);
            jsc.setSize(11);
            jsc.setDefaultValue("");
            columns.addElement(jsc);
            jsc = new tsColumn("TABLE_NAME");
            jsc.setType(1);
            jsc.setSize(250);
            columns.addElement(jsc);
            jsc = new tsColumn("COLUMN_NAME");
            jsc.setType(1);
            jsc.setSize(11);
            columns.addElement(jsc);
            jsc = new tsColumn("DATA_TYPE");
            jsc.setType(2);
            jsc.setSize(6);
            columns.addElement(jsc);
            jsc = new tsColumn("TYPE_NAME");
            jsc.setType(1);
            jsc.setSize(9);
            columns.addElement(jsc);
            jsc = new tsColumn("COLUMN_SIZE");
            jsc.setType(2);
            jsc.setSize(8);
            columns.addElement(jsc);
            jsc = new tsColumn("DECIMAL_DIGITS");
            jsc.setType(2);
            jsc.setSize(8);
            columns.addElement(jsc);
            jsc = new tsColumn("NULLABLE");
            jsc.setType(2);
            jsc.setSize(8);
            columns.addElement(jsc);
            jsc = new tsColumn("REMARKS");
            jsc.setType(1);
            jsc.setSize(128);
            jsc.setDefaultValue("");
            columns.addElement(jsc);
            jsc = new tsColumn("COLUMN_DEF");
            jsc.setType(2);
            jsc.setSize(128);
            columns.addElement(jsc);
            jsc = new tsColumn("IS_NULLABLE");
            jsc.setType(1);
            jsc.setSize(3);
            columns.addElement(jsc);
            tsResultSet jrs = new tsResultSet(new tsPhysicalRow(columns));
            tinySQL sql = ((tinySQLConnection)this.getConnection()).getDatabaseEngine();
            while (tableRs.next()) {
                tinySQLTableView tbl;
                String tableName = tableRs.getString("TABLE_NAME");
                try {
                    if (tableName == null) continue;
                    tbl = sql.getTable(tableName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                int i = 0;
                while (i < tbl.getColumnCount()) {
                    tsColumn tsc = tbl.getColumnDefinition(i);
                    tsPhysicalRow record = jrs.createPhysicalRow();
                    record.put(record.findColumn("TABLE_CAT"), "");
                    record.put(record.findColumn("TABLE_SCHEM"), "");
                    record.put(record.findColumn("TABLE_NAME"), tableName);
                    record.put(record.findColumn("COLUMN_NAME"), tsc.getPhysicalName());
                    record.put(record.findColumn("DATA_TYPE"), new Integer(tsc.getType()).toString());
                    record.put(record.findColumn("TYPE_NAME"), DBFHeader.typeToLiteral(tsc.getType()).toString());
                    record.put(record.findColumn("COLUMN_SIZE"), new Integer(tsc.getSize()).toString());
                    record.put(record.findColumn("DECIMAL_DIGITS"), new Integer(tsc.getDecimalPlaces()).toString());
                    int nullable = 0;
                    if (tsc.isNullable()) {
                        nullable = 1;
                    }
                    record.put(record.findColumn("NULLABLE"), new Integer(nullable).toString());
                    Object defaultVal = tsc.getDefaultValue();
                    if (defaultVal == null) {
                        defaultVal = "";
                    }
                    record.put(record.findColumn("COLUMN_DEF"), defaultVal);
                    String isNullable = "NO";
                    if (tsc.isNullable()) {
                        isNullable = "YES";
                    }
                    record.put(record.findColumn("IS_NULLABLE"), isNullable);
                    jrs.addPhysicalRow(record);
                    ++i;
                }
                tbl.close();
            }
            return new tinySQLResultSet(jrs, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        throw new SQLException("tinySQL does not support column privileges.");
    }

    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new SQLException("tinySQL does not support table privileges.");
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        throw new SQLException("tinySQL does not support best row identifiers.");
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        throw new SQLException("tinySQL does not support version columns.");
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        throw new SQLException("tinySQL does not support primary keys.");
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        throw new SQLException("tinySQL does not support imported keys.");
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        throw new SQLException("tinySQL does not support exported keys.");
    }

    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        throw new SQLException("tinySQL does not support cross reference.");
    }

    public ResultSet getTypeInfo() throws SQLException {
        throw new SQLException("tinySQL getTypeInfo not yet implemented.");
    }

    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        throw new SQLException("tinySQL does not support index infos.");
    }

    public boolean supportsResultSetType(int type) {
        if (type == 1003) {
            return true;
        }
        return type == 1005;
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        return false;
    }

    public boolean ownUpdatesAreVisible(int type) {
        return false;
    }

    public boolean ownDeletesAreVisible(int type) {
        return false;
    }

    public boolean ownInsertsAreVisible(int type) {
        return false;
    }

    public boolean othersUpdatesAreVisible(int type) {
        return false;
    }

    public boolean othersDeletesAreVisible(int type) {
        return false;
    }

    public boolean othersInsertsAreVisible(int type) {
        return false;
    }

    public boolean updatesAreDetected(int type) {
        return false;
    }

    public boolean deletesAreDetected(int type) {
        return false;
    }

    public boolean insertsAreDetected(int type) {
        return false;
    }

    public boolean supportsBatchUpdates() {
        return false;
    }

    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        throw new SQLException("tinySQL does not support getUDTs.");
    }

    public Connection getConnection() {
        return this.connection;
    }
}

