/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL;

import ORG.as220.tinySQL.sqlparser.LValue;
import ORG.as220.tinySQL.tinySQLTableView;

public class tsColumn {
    public static final int COL_DATA = 0;
    public static final int COL_EXPR = 1;
    public static final int COL_INVALID = -1;
    private LValue expression;
    private String physName = null;
    private String displayName = null;
    private String fqname = null;
    private int datatype = -1;
    private int decimalPlaces = -1;
    private Object defaultVal = null;
    private boolean notNull = false;
    private int bytePos = -1;
    private int tablePos = -1;
    private int resultPos = -1;
    private int size = -1;
    private int coltype = -1;
    private tinySQLTableView table = null;

    public tsColumn(tinySQLTableView table, String col, String alias) {
        if (col == null) {
            throw new NullPointerException("Name must not be null");
        }
        if (col.indexOf(46) != -1) {
            throw new IllegalArgumentException();
        }
        this.table = table;
        this.physName = col;
        this.displayName = alias == null ? col : alias;
        this.coltype = 0;
    }

    public tsColumn(tinySQLTableView table, String col) {
        this(table, col, null);
    }

    public tsColumn(String col, LValue ex) {
        if (col == null) {
            throw new NullPointerException("Name must not be null");
        }
        this.expression = ex;
        this.physName = col;
        this.displayName = col;
        this.coltype = 1;
    }

    public tsColumn(String col) {
        if (col == null) {
            throw new NullPointerException("Name must not be null");
        }
        this.physName = col;
        this.displayName = col;
        this.coltype = -1;
    }

    public tsColumn(tsColumn col) {
        if (col == null) {
            throw new NullPointerException("Name was null?");
        }
        this.physName = col.physName;
        this.displayName = col.displayName;
        this.coltype = col.coltype;
        this.datatype = col.datatype;
        this.decimalPlaces = col.decimalPlaces;
        this.defaultVal = col.defaultVal;
        this.notNull = col.notNull;
        this.size = col.size;
        this.table = col.table;
        this.tablePos = col.tablePos;
        this.bytePos = col.bytePos;
        this.resultPos = col.resultPos;
    }

    public tsColumn(tinySQLTableView table, tsColumn col) {
        this(col);
        this.table = table;
    }

    public void setAll(tsColumn col) {
        this.coltype = col.coltype;
        this.datatype = col.datatype;
        this.decimalPlaces = col.decimalPlaces;
        this.defaultVal = col.defaultVal;
        this.notNull = col.notNull;
        this.size = col.size;
        this.tablePos = col.tablePos;
        this.bytePos = col.bytePos;
        this.resultPos = col.resultPos;
    }

    public String getPhysicalName() {
        return this.physName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getFQName() {
        return this.formColname(this.physName, this.table);
    }

    public void setPhysicalName(String name) {
        this.physName = name;
        this.fqname = null;
        this.coltype = -1;
    }

    public Object getDefaultValue() {
        return this.defaultVal;
    }

    public void setDefaultValue(Object value) {
        this.defaultVal = value;
    }

    public void setType(int type) {
        this.datatype = type;
    }

    public int getType() {
        return this.datatype;
    }

    public boolean isNullable() {
        return !this.notNull;
    }

    public void setNullable(boolean notNull) {
        this.notNull = notNull;
    }

    public void setSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Size must be >= 0");
        }
        this.size = size;
        this.decimalPlaces = 0;
    }

    public void setSize(int size, int decimals) {
        if (size < 0) {
            throw new IllegalArgumentException("Size must be >= 0");
        }
        if (decimals >= size) {
            throw new IllegalArgumentException("Decimals [" + decimals + "] must be < than size [" + size + "]");
        }
        this.size = size;
        this.decimalPlaces = decimals;
    }

    public int getSize() {
        return this.size;
    }

    public int getDecimalPlaces() {
        return this.decimalPlaces;
    }

    public void setResultPosition(int pos) {
        this.resultPos = pos;
    }

    public int getResultPosition() {
        return this.resultPos;
    }

    public void setBytePosition(int pos) {
        this.bytePos = pos;
    }

    public int getBytePosition() {
        return this.bytePos;
    }

    public int getTablePosition() {
        if (this.table == null) {
            return -1;
        }
        if (this.tablePos == -1) {
            this.tablePos = this.table.findColumn(this.getPhysicalName());
        }
        return this.tablePos;
    }

    public void setTablePosition(int pos) {
        this.tablePos = pos;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("tsColumn:={FQName =");
        b.append(this.getFQName());
        b.append(", display_name=");
        b.append(this.displayName);
        b.append(", tablepos=" + this.getTablePosition());
        b.append(", bytepos=" + this.getBytePosition());
        b.append(", size= (" + this.size);
        b.append("," + this.decimalPlaces + ")");
        b.append(", type=" + this.datatype);
        b.append(", coltype=" + this.coltype);
        b.append("}");
        return b.toString();
    }

    public int getColumnType() {
        return this.coltype;
    }

    public tinySQLTableView getTable() {
        return this.table;
    }

    public LValue getExpression() {
        return this.expression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof tsColumn)) return false;
        tsColumn col = (tsColumn)o;
        if (col.getColumnType() != this.getColumnType()) {
            return false;
        }
        if (this.physName != null && col.physName == null) {
            return false;
        }
        if (this.physName == null && col.physName != null) {
            return false;
        }
        if (col.getTable() == null) {
            if (this.getTable() != null) {
                return false;
            }
            if (col.getExpression() == null) {
                if (this.getExpression() != null) return false;
                return true;
            }
            if (this.getExpression() != null) return col.getExpression().equals(this.getExpression());
            return false;
        }
        if (this.getTable() == null) {
            return false;
        }
        if (this.getTablePosition() != col.getTablePosition()) return false;
        return true;
    }

    public boolean isValidName(String name) {
        if (name == null) {
            return false;
        }
        if (name.equals(this.getPhysicalName())) {
            return true;
        }
        if (name.equals(this.getDisplayName())) {
            return true;
        }
        return name.equals(this.getFQName());
    }

    private String formColname(String column, tinySQLTableView table) {
        if (table == null) {
            return column;
        }
        if (this.fqname == null) {
            this.fqname = table.getName() + "." + column;
        }
        return this.fqname;
    }
}

