/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL;

import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tinySQLTableView;
import ORG.as220.tinySQL.tsColumn;
import ORG.as220.tinySQL.tsRow;
import ORG.as220.tinySQL.util.ArrayEnumeration;
import ORG.as220.tinySQL.util.Log;
import java.util.Enumeration;
import java.util.Vector;

public class tsPhysicalRow
extends tsRow {
    private Object[] data;
    private tsColumn[] coldefs;

    public tsPhysicalRow(Vector columns) {
        this.coldefs = new tsColumn[columns.size()];
        this.data = new Object[columns.size()];
        int size = columns.size();
        int i = 0;
        while (i < size) {
            tsColumn col = (tsColumn)columns.elementAt(i);
            col.setResultPosition(i);
            this.data[i] = col.getDefaultValue();
            this.coldefs[i] = col;
            ++i;
        }
    }

    public tsPhysicalRow(tsPhysicalRow copycon) {
        super(copycon);
        this.data = new Object[copycon.data.length];
        System.arraycopy(copycon.data, 0, this.data, 0, this.data.length);
        this.coldefs = copycon.coldefs;
    }

    public Object get(int col) throws tinySQLException {
        return this.data[col];
    }

    public void put(int col, Object value) throws tinySQLException {
        this.data[col] = value;
    }

    public tsColumn getColumnDefinition(int col) {
        return this.coldefs[col];
    }

    public Enumeration getAllDefinitions() {
        return new ArrayEnumeration(this.coldefs);
    }

    public int size() {
        return this.data.length;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[tsPhysicalRow=(");
        int i = 0;
        while (i < this.data.length) {
            if (i != 0) {
                b.append(", ");
            }
            b.append(this.data[i]);
            ++i;
        }
        b.append(")]");
        return b.toString();
    }

    public void refresh() throws tinySQLException {
        int size = this.size();
        int i = 0;
        while (i < size) {
            tsColumn currColDef = this.getColumnDefinition(i);
            if (currColDef.getColumnType() == 0) {
                tinySQLTableView table = currColDef.getTable();
                Object o = table.getColumn(currColDef.getTablePosition());
                this.put(i, o);
            } else {
                Log.debug("Refresh: Ignoring row:" + currColDef + " - not a data row");
            }
            ++i;
        }
    }
}

