/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL;

import ORG.as220.tinySQL.tinySQLConverter;
import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tsColumn;
import ORG.as220.tinySQL.tsPhysicalRow;
import ORG.as220.tinySQL.util.Log;
import java.util.Vector;

public abstract class tsRawRow
extends tsPhysicalRow {
    private Object[] cache = null;
    private tinySQLConverter converter;

    public tsRawRow(Vector columns, tinySQLConverter converter) {
        super(columns);
        this.converter = converter;
        this.cache = new Object[columns.size()];
    }

    public tsRawRow(tsRawRow copy) {
        super(copy);
        this.converter = copy.converter;
        this.cache = new Object[this.size()];
    }

    public void putNative(int column, Object o) throws tinySQLException {
        this.nativePut(this.getColumnDefinition(column), o);
        this.cache[column] = null;
    }

    public Object getNative(int column) throws tinySQLException {
        return this.nativeGet(this.getColumnDefinition(column));
    }

    public void clearCache() {
        this.cache = new Object[this.size()];
    }

    public Object get(int col) {
        Object co = this.cache[col];
        if (co == null) {
            try {
                tsColumn coldef = this.getColumnDefinition(col);
                this.cache[col] = co = this.converter.convertNativeToJDBC(coldef, this.nativeGet(coldef));
            }
            catch (Exception e) {
                Log.error("Failed to getColumn", e);
                return null;
            }
        }
        return co;
    }

    public void put(int col, Object o) throws tinySQLException {
        this.cache[col] = o;
        tsColumn coldef = this.getColumnDefinition(col);
        this.nativePut(coldef, this.converter.convertJDBCToNative(coldef, o));
    }

    protected abstract Object nativeGet(tsColumn var1) throws tinySQLException;

    protected abstract void nativePut(tsColumn var1, Object var2) throws tinySQLException;
}

