/*
 * Decompiled with CFR 0.152.
 */
package ORG.as220.tinySQL;

import ORG.as220.tinySQL.sqlparser.LValue;
import ORG.as220.tinySQL.tinySQLException;
import ORG.as220.tinySQL.tsColumn;
import ORG.as220.tinySQL.tsPhysicalRow;
import ORG.as220.tinySQL.tsRow;
import ORG.as220.tinySQL.util.Log;
import java.util.Arrays;
import java.util.Vector;

public class tsResultRow
extends tsRow {
    private tsRow prototype;
    private tsRow row;
    private tsColumn[] myColumns;
    private Object[] cache;
    private int[] translationTable;
    private boolean[] evalStack;

    public tsResultRow(Vector cols) {
        tsPhysicalRow empty = new tsPhysicalRow(new Vector());
        this.init(cols, empty);
    }

    public tsResultRow(Vector cols, tsRow prototype) {
        this.init(cols, prototype);
    }

    private void init(Vector cols, tsRow prototype) {
        int size = cols.size();
        this.myColumns = new tsColumn[size];
        this.translationTable = new int[size];
        int i = 0;
        while (i < size) {
            tsColumn column;
            this.myColumns[i] = column = (tsColumn)cols.elementAt(i);
            this.translationTable[i] = prototype.findColumn(column.getPhysicalName());
            ++i;
        }
        this.prototype = prototype;
        this.cache = new Object[size];
        this.evalStack = new boolean[size];
        this.row = prototype;
    }

    public tsResultRow(tsRow prototype) {
        Vector<tsColumn> cols = new Vector<tsColumn>();
        int i = 0;
        while (i < prototype.size()) {
            cols.add(prototype.getColumnDefinition(i));
            ++i;
        }
        this.init(cols, prototype);
    }

    public tsResultRow(tsResultRow copy) {
        int size = copy.size();
        this.myColumns = copy.myColumns;
        this.translationTable = copy.translationTable;
        this.prototype = copy.prototype;
        this.cache = new Object[size];
        this.evalStack = new boolean[size];
    }

    public void setParent(tsRow parent) {
        if (parent == null) {
            throw new NullPointerException("Parent may not be null");
        }
        this.row = parent;
    }

    private final int lookup(int myColumn) {
        int in = this.translationTable[myColumn];
        return in;
    }

    public synchronized Object get(int column) throws tinySQLException {
        tsColumn myColumn;
        LValue expr;
        int rowcol = this.lookup(column);
        if (rowcol != -1) {
            return this.row.get(rowcol);
        }
        if (this.evalStack[column]) {
            Log.warn("Self-Referenced column detected, returning null");
            throw new tinySQLException("Self-Referenced column detected");
        }
        this.evalStack[column] = true;
        Object result = this.cache[column];
        if (result == null && (expr = (myColumn = this.getColumnDefinition(column)).getExpression()) != null) {
            this.cache[column] = result = expr.evaluate(this);
        }
        this.evalStack[column] = false;
        return result;
    }

    public tsColumn getColumnDefinition(int column) {
        return this.myColumns[column];
    }

    public int size() {
        return this.myColumns.length;
    }

    public void refresh() throws tinySQLException {
        Arrays.fill(this.cache, null);
        this.row.refresh();
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < this.size()) {
            if (i != 0) {
                b.append(", ");
            }
            tsColumn col = this.getColumnDefinition(i);
            b.append("[");
            b.append(col.getDisplayName());
            b.append("]");
            try {
                b.append(this.get(i));
            }
            catch (Exception e) {
                b.append("<!EXCEPTION>");
            }
            ++i;
        }
        return b.toString();
    }
}

